/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.batch;

import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.core.batch.BatchInterface;
import com.dtstep.lighthouse.core.batch.IntervalBatchHandler;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BatchAdapter.class);
    private static final IntervalBatchHandler intervalBatchHandler = new IntervalBatchHandler();

    public static String generateLimitKey(String mapperStatId, int dataVersion, long batchTime) {
        return Md5Util.getMD5((String)(mapperStatId + "_" + dataVersion + "_" + batchTime));
    }

    public static List<Long> queryBatchTimeList(String timeParam, long startTime, long endTime) throws Exception {
        return BatchAdapter.queryBatchTimeList(timeParam, startTime, endTime, -1);
    }

    public static List<Long> queryBatchTimeList(String timeParam, long startTime, long endTime, int limitSize) throws Exception {
        return Objects.requireNonNull(BatchAdapter.getBatchInterface(timeParam)).queryBatchTimeList(timeParam, startTime, endTime, limitSize);
    }

    public static String dateTimeFormat(String timeParam, long batchTime) {
        return Objects.requireNonNull(BatchAdapter.getBatchInterface(timeParam)).dateTimeFormat(timeParam, batchTime);
    }

    static BatchInterface getBatchInterface(String timeParam) {
        return intervalBatchHandler;
    }

    @Deprecated
    private static long binaryBatchSearch(long[] batchArray, long tempTime) throws Exception {
        int low = 0;
        int high = batchArray.length - 1;
        if (tempTime > batchArray[high] || tempTime < batchArray[low]) {
            return -1L;
        }
        while (low <= high) {
            int mid = low + high >> 1;
            if (batchArray[mid] > tempTime && batchArray[mid - 1] > tempTime) {
                high = mid - 1;
                continue;
            }
            if (batchArray[mid] < tempTime && batchArray[mid + 1] <= tempTime) {
                low = mid + 1;
                continue;
            }
            if (batchArray[mid] > tempTime && batchArray[mid - 1] <= tempTime) {
                return batchArray[mid - 1];
            }
            return batchArray[mid];
        }
        throw new Exception("binary batch search error");
    }
}

