/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.batch;

import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.batch.BatchInterface;
import com.dtstep.lighthouse.core.sort.SortOperator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class IntervalBatchHandler
implements BatchInterface {
    @Override
    public String dateTimeFormat(String timeParam, long batchTime) {
        if (timeParam.endsWith("hour")) {
            return DateUtil.formatTimeStamp((long)batchTime, (String)"MMdd HH:00");
        }
        if (timeParam.endsWith("minute")) {
            return DateUtil.formatTimeStamp((long)batchTime, (String)"MMdd HH:mm");
        }
        if (timeParam.endsWith("day")) {
            return DateUtil.formatTimeStamp((long)batchTime, (String)"yyyyMMdd");
        }
        return null;
    }

    @Override
    public List<Long> queryBatchTimeList(String timeParam, long startDate, long endDate, int limitSize) throws Exception {
        long tempTime = endDate;
        ArrayList dateList = Lists.newArrayList();
        while (tempTime > startDate && (limitSize == -1 || dateList.size() < limitSize)) {
            long t = this.getBatch(timeParam, tempTime);
            dateList.add(t);
            tempTime = t - 1L;
        }
        SortOperator.sortList(dateList);
        return dateList;
    }

    @Override
    public long getBatch(int interval, TimeUnit timeUnit, long current) {
        return DateUtil.batchTime((int)interval, (TimeUnit)timeUnit, (long)current);
    }

    @Override
    @Deprecated
    public long getBatch(String timeParam, long t) {
        String[] timeParamArr = timeParam.split("-");
        int interval = Integer.parseInt(timeParamArr[0]);
        TimeUnit timeUnit = null;
        if ("second".equals(timeParamArr[1])) {
            timeUnit = TimeUnit.SECONDS;
        } else if ("minute".equals(timeParamArr[1])) {
            timeUnit = TimeUnit.MINUTES;
        } else if ("hour".equals(timeParamArr[1])) {
            timeUnit = TimeUnit.HOURS;
        } else if ("day".equals(timeParamArr[1])) {
            timeUnit = TimeUnit.DAYS;
        }
        return this.getBatch(interval, timeUnit, t);
    }
}

