/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.builtin;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.core.config.LDPConfig;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerStat {
    private static final Logger logger = LoggerFactory.getLogger(CallerStat.class);

    public static void stat(int callerId, String function, int status, Long inBytes, Long outBytes) {
        try {
            if (!LightHouse.isInit()) {
                LightHouse.init((String)LDPConfig.getVal("lighthouse.ice.locators"));
            }
        }
        catch (Exception ex) {
            logger.error("CallerStat initialization error!", (Throwable)ex);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("callerId", callerId);
        paramMap.put("function", function);
        paramMap.put("status", status);
        paramMap.put("in_bytes", inBytes);
        paramMap.put("out_bytes", outBytes);
        try {
            LightHouse.stat((String)"_builtin_caller_stat", (String)"2l2ipBHOssTzsHsdErKDcarxjU6rKZwo", paramMap, (long)System.currentTimeMillis());
        }
        catch (Exception ex) {
            logger.error("caller stat error!", (Throwable)ex);
        }
    }
}

