/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.callback;

import com.dtstep.lighthouse.core.callback.CacheValue;
import com.github.benmanes.caffeine.cache.Expiry;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CaffeineExpiry {

    public static class ExpiryAfterLastAccess<K, V extends CacheValue>
    implements Expiry<K, V> {
        private long expireMills;

        public ExpiryAfterLastAccess(long expireNanos) {
            this.expireMills = expireNanos;
        }

        public long getExpireMills() {
            return this.expireMills;
        }

        public void setExpireMills(long expireMills) {
            this.expireMills = expireMills;
        }

        public long expireAfterCreate(@NonNull K k, @NonNull V v, long l) {
            if (((CacheValue)v).getAccessTime() + this.expireMills > System.currentTimeMillis()) {
                return l + 1L;
            }
            return 0L;
        }

        public long expireAfterUpdate(@NonNull K k, @NonNull V v, long l, @NonNegative long l1) {
            if (((CacheValue)v).getAccessTime() + this.expireMills > System.currentTimeMillis()) {
                return l + 1L;
            }
            return 0L;
        }

        public long expireAfterRead(@NonNull K k, @NonNull V v, long l, @NonNegative long l1) {
            if (((CacheValue)v).getAccessTime() + this.expireMills > System.currentTimeMillis()) {
                return l + 1L;
            }
            return 0L;
        }
    }

    public static class ExpiryAfterCreate<K, V extends CacheValue>
    implements Expiry<K, V> {
        private long expireMills;

        public ExpiryAfterCreate(long expireMills) {
            this.expireMills = expireMills;
        }

        public long getExpireMills() {
            return this.expireMills;
        }

        public void setExpireMills(long expireMills) {
            this.expireMills = expireMills;
        }

        public long expireAfterCreate(@NonNull K k, @NonNull V v, long l) {
            if (((CacheValue)v).getCreateTime() + this.expireMills > System.currentTimeMillis()) {
                return l + 1L;
            }
            return 0L;
        }

        public long expireAfterUpdate(@NonNull K k, @NonNull V v, long l, @NonNegative long l1) {
            if (((CacheValue)v).getCreateTime() + this.expireMills > System.currentTimeMillis()) {
                return l + 1L;
            }
            return 0L;
        }

        public long expireAfterRead(@NonNull K k, @NonNull V v, long l, @NonNegative long l1) {
            if (((CacheValue)v).getCreateTime() + this.expireMills > System.currentTimeMillis()) {
                return l + 1L;
            }
            return 0L;
        }
    }
}

