/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.consumer;

import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.event.SimpleSlotEvent;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.core.consumer.ExpandedEventRunnable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public final class ExpandedConsumer {
    private final int threadSize;
    private final EventPool<SimpleSlotEvent> eventPool;
    private final ScheduledExecutorService service;

    ExpandedConsumer(EventPool<SimpleSlotEvent> eventPool, int threadSize) {
        this.eventPool = eventPool;
        this.threadSize = threadSize;
        this.service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)threadSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("expanded-event-schedule-pool-%d").daemon(true).build());
    }

    public void start() {
        for (int i = 0; i < this.threadSize; ++i) {
            this.service.scheduleWithFixedDelay(new ExpandedEventRunnable(this.eventPool), 0L, 5L, TimeUnit.SECONDS);
        }
    }
}

