/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.dao;

import com.dtstep.lighthouse.core.dao.RDBMSConfiguration;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBConnectionSource {
    private static final Logger logger = LoggerFactory.getLogger(DBConnectionSource.class);
    private static final HashMap<String, BasicDataSource> dataSourceMap = new HashMap();

    public static void init(RDBMSConfiguration rdbmsConfiguration) {
        try {
            Properties p = new Properties();
            p.setProperty("driverClassName", rdbmsConfiguration.getDriverClassName());
            p.setProperty("url", rdbmsConfiguration.getConnectionURL());
            p.setProperty("username", rdbmsConfiguration.getConnectionUserName());
            p.setProperty("password", rdbmsConfiguration.getConnectionPassword());
            p.setProperty("maxActive", "-1");
            p.setProperty("maxIdle", "10");
            p.setProperty("maxWait", "1000");
            p.setProperty("removeAbandoned", "true");
            p.setProperty("removeAbandonedTimeout", "120");
            p.setProperty("testOnBorrow", "false");
            p.setProperty("logAbandoned", "true");
            p.setProperty("validationQuery", "SELECT 1");
            p.setProperty("testWhileIdle", "true");
            p.setProperty("timeBetweenEvictionRunsMillis", "30000");
            p.setProperty("minEvictableIdleTimeMillis", "180000");
            p.setProperty("numTestsPerEvictionRun", "3");
            BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)p);
            dataSourceMap.put(rdbmsConfiguration.getDatabase(), dataSource);
        }
        catch (Exception e) {
            logger.error("get db connection error", (Throwable)e);
        }
    }

    public static synchronized BasicDataSource getBasicDataSource(RDBMSConfiguration rdbmsConfiguration) throws SQLException {
        String database = rdbmsConfiguration.getDatabase();
        Validate.notNull((Object)database);
        if (!dataSourceMap.containsKey(database)) {
            DBConnectionSource.init(rdbmsConfiguration);
        }
        return dataSourceMap.get(database);
    }
}

