/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.distinct;

import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.util.BinaryUtil;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.redis.RedisClient;
import com.dtstep.lighthouse.core.redis.RedisOperator;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public final class RedisRoaringFilter<T> {
    private static final Logger logger = LoggerFactory.getLogger(RedisRoaringFilter.class);
    private static final KeyGenerator keyGenerator = new DefaultKeyGenerator();
    public static final String BLOOM_LUA_SCRIPT_LOCAL_HASH = "local function split(fullStr, separator) \n    local startIndex = 1 \n    local splitIndex = 1 \n    local splitArray = {} \n    while true do \n        local lastIndex = string.find(fullStr, separator, startIndex) \n        if not lastIndex then \n            splitArray[splitIndex] = string.sub(fullStr, startIndex, string.len(fullStr)) \n            break \n        end \n        splitArray[splitIndex] = string.sub(fullStr, startIndex, lastIndex - 1) \n        startIndex = lastIndex + string.len(separator) \n        splitIndex = splitIndex + 1 \n    end \n    return splitArray \nend \n\nlocal list = split(ARGV[1], \";\") \nlocal array = {} \nfor i = 1, #list do \n    local temp = list[i] \n    local tempArray = split(temp, \",\") \n    for j = 1, #tempArray do \n        local key = KEYS[1] .. '_' .. j .. '{' .. KEYS[1] .. '}' \n        local m = redis.call('r.getbit', key, math.abs(tonumber(tempArray[j], 36))) \n        if(m == 0) then \n            array[i] = 0 \n            break \n        else \n            array[i] = 1 \n        end \n    end \nend \n\nlocal notExistSize = 0 \nfor i = 1, #array do \n    local temp = array[i] \n    if(temp == 0) then \n        notExistSize = notExistSize + 1 \n        local tempArray = split(list[i], \",\") \n        for j = 1, #tempArray do \n            local key = KEYS[1] .. '_' .. j .. '{' .. KEYS[1] .. '}' \n            redis.call('r.setbit', key, math.abs(tonumber(tempArray[j], 36)), 1) \n            if(tonumber(ARGV[2]) ~= -1) then \n                redis.call('expire', key, ARGV[2]) \n            end \n        end \n    end \nend \n\nreturn notExistSize\n";
    private String sha;
    private static final RedisRoaringFilter<CharSequence> instance = new RedisRoaringFilter();

    public RedisRoaringFilter() {
        try {
            this.sha = RedisClient.scriptLoad(BLOOM_LUA_SCRIPT_LOCAL_HASH);
        }
        catch (Exception ex) {
            logger.error("redis script load error", (Throwable)ex);
        }
    }

    public static RedisRoaringFilter<CharSequence> getInstance() {
        return instance;
    }

    public long filterWithRoaringMap(String key, List<T> valueList, long expireSeconds, int part) {
        if (CollectionUtils.isEmpty(valueList)) {
            return 0L;
        }
        RedisOperator redisOperator = RedisClient.getInstance().getRedisOperator();
        try {
            if (StringUtil.isEmpty((String)this.sha)) {
                this.sha = redisOperator.scriptLoad(BLOOM_LUA_SCRIPT_LOCAL_HASH, key);
            }
            Map<Integer, List<Object>> distinctMap = valueList.parallelStream().collect(Collectors.groupingBy(x -> Math.abs(x.hashCode()) % part));
            return distinctMap.entrySet().parallelStream().map(x -> {
                int partIndex = (Integer)x.getKey();
                List list = (List)x.getValue();
                List parts = Lists.partition((List)list, (int)200);
                return parts.parallelStream().map(subList -> {
                    ArrayList offsetStrArray = Lists.newArrayList();
                    for (Object t : subList) {
                        long hash = Long.parseLong(t.toString(), 36);
                        int low = (int)hash;
                        int high = (int)(hash >>> 32);
                        if (low < 0) {
                            low ^= 0xFFFFFFFF;
                        }
                        if (high < 0) {
                            high ^= 0xFFFFFFFF;
                        }
                        offsetStrArray.add(BinaryUtil.translateTenTo36((long)low) + "," + BinaryUtil.translateTenTo36((long)high));
                    }
                    String str = StringUtils.join((Iterable)offsetStrArray, (String)";");
                    Object result = redisOperator.evalsha(this.sha, 1, Md5Util.get16MD5((String)(key + "_" + partIndex)), str, String.valueOf(expireSeconds));
                    if (result != null && StringUtil.isNumber((String)result.toString())) {
                        return CollectionUtils.isNotEmpty((Collection)subList) ? Long.parseLong(result.toString()) : 0L;
                    }
                    logger.error("redis roaring check exist error,result:" + result);
                    return 0L;
                }).mapToLong(z -> z).sum();
            }).mapToLong(x -> x).sum();
        }
        catch (JedisNoScriptException ex) {
            IntStream.range(0, part).forEach(x -> {
                logger.info("put roaring lua-script to remote server again,key:{}", (Object)key);
                this.sha = redisOperator.scriptLoad(BLOOM_LUA_SCRIPT_LOCAL_HASH, Md5Util.get16MD5((String)(key + "_" + x)));
            });
            return this.filterWithRoaringMap(key, valueList, expireSeconds, part);
        }
        catch (Exception ex) {
            logger.error("redis roaring check exist error!", (Throwable)ex);
            return 0L;
        }
    }

    public String concatDistinctValue(String distinctValue, String dimensValue, long batchTime) {
        if (StringUtil.isEmpty((String)dimensValue)) {
            return distinctValue + "_" + batchTime;
        }
        return distinctValue + "_" + dimensValue + "_" + batchTime;
    }

    public String getBloomFilterKey(StatExtEntity statExtEntity, String dimensValue, int functionIndex, long batchTime) {
        if (StringUtil.isEmpty((String)statExtEntity.getTemplateEntity().getDimens())) {
            long aggregateTime = DateUtil.batchTime((int)20, (TimeUnit)TimeUnit.MINUTES, (long)batchTime);
            String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, functionIndex, null, aggregateTime);
            return "b_d_" + aggregateKey;
        }
        long aggregateTime = DateUtil.batchTime((int)20, (TimeUnit)TimeUnit.MINUTES, (long)batchTime);
        String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, functionIndex, null, aggregateTime);
        return "b_d_" + aggregateKey + "_" + Math.abs(dimensValue.hashCode()) % 3;
    }
}

