/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.formula;

import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.ColumnTypeEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.core.expression.embed.AviatorHandler;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.dtstep.lighthouse.core.formula.FormulaTranslate;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImitateCompile {
    private static final Logger logger = LoggerFactory.getLogger(ImitateCompile.class);

    public static boolean imitateStatFormula(int statId, String formula, List<Column> columnList) {
        try {
            String tempFormula = formula;
            Pair<String, List<StatState>> pair = FormulaTranslate.translate(formula);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (columnList != null) {
                for (Column metaColumn : columnList) {
                    if (metaColumn.getType() == ColumnTypeEnum.STRING) {
                        paramMap.put(metaColumn.getName(), UUID.randomUUID().toString());
                        continue;
                    }
                    if (metaColumn.getType() != ColumnTypeEnum.NUMBER) continue;
                    paramMap.put(metaColumn.getName(), new Random().nextInt(10000));
                }
            }
            List stateList = (List)pair.getValue();
            for (StatState statState : stateList) {
                boolean valid = FormulaCalculate.valid(statState, paramMap, System.currentTimeMillis());
                if (!valid) {
                    logger.error("xl-formula stat format check failed,statId:[{}],formula:[{}]!", (Object)statId, (Object)formula);
                    return false;
                }
                tempFormula = tempFormula.replace(statState.getStateBody(), String.valueOf(1.0));
            }
            AviatorHandler.compileStatFormula(tempFormula);
        }
        catch (Exception ex) {
            logger.error("xl-formula stat format check failed,statId:[{}],formula:[{}]!", (Object)statId, (Object)formula);
            return false;
        }
        return true;
    }

    public static boolean imitateDimensFormula(int statId, String formula, List<Column> columnList) {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (columnList != null) {
                for (Column metaColumn : columnList) {
                    if (metaColumn.getType() == ColumnTypeEnum.STRING) {
                        paramMap.put(metaColumn.getName(), UUID.randomUUID().toString());
                        continue;
                    }
                    if (metaColumn.getType() != ColumnTypeEnum.NUMBER) continue;
                    paramMap.put(metaColumn.getName(), new Random().nextInt(10000));
                }
            }
            AviatorHandler.compileDimensFormula(formula, paramMap);
        }
        catch (Exception ex) {
            logger.error("xl-formula dimens format check failed,statId:[{}],formula:[{}]!", (Object)statId, (Object)formula);
            return false;
        }
        return true;
    }
}

