/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.BlockingEventPool;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.calculate.MicroBucket;
import com.dtstep.lighthouse.common.entity.calculate.MicroCalculateEnum;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.distinct.RedisRoaringFilter;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.dtstep.lighthouse.core.functions.ResultStorageThread;
import com.dtstep.lighthouse.core.functions.StatProcess;
import com.dtstep.lighthouse.core.roaring.BitSetFilterSupplier;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitCountStatProcess
extends StatProcess<Pair<String, Long>> {
    private static final long serialVersionUID = 7650995793688292626L;
    private static final Logger logger = LoggerFactory.getLogger(BitCountStatProcess.class);
    private static final int poolSlotSize = 10;
    private static final EventPool<MicroBucket> eventPool = new BlockingEventPool("BitCountStorageEventPool", 10, 400000);

    public BitCountStatProcess(StatExtEntity statExtEntity, String metaName, String aggregateKey, String dimensValue) {
        this.statExtEntity = statExtEntity;
        this.metaName = metaName;
        this.aggregateKey = aggregateKey;
        int tempIndex = aggregateKey.indexOf(";");
        String rowKey = aggregateKey.substring(0, tempIndex);
        String delta = aggregateKey.substring(tempIndex + 1);
        this.rowKey = rowKey;
        this.delta = delta;
        this.dimensValue = dimensValue;
        this.ttl = this.getTTL(statExtEntity.getExpired());
    }

    @Override
    public void evaluate(StatState statState, List<Pair<String, Long>> messageList, long batchTime) throws Exception {
        int part;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        TemplateEntity templateEntity = this.statExtEntity.getTemplateEntity();
        if (logger.isTraceEnabled()) {
            logger.trace("lighthouse trace,bitcount stat:{},batchTime:{},messageList:{}", new Object[]{this.statExtEntity.getId(), DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss"), JsonUtil.toJSONString(messageList)});
        }
        Object[] distinctArray = messageList.parallelStream().map(x -> {
            HashMap<String, Object> envMap;
            if (!StringUtil.isEmptyOrNullStr((String)((String)x.getKey()))) {
                Map paramMap = Splitter.on((String)"\u0005").withKeyValueSeparator("\u0006").split((CharSequence)x.getKey());
                envMap = new HashMap(paramMap);
            } else {
                envMap = new HashMap<String, Object>();
            }
            long calculate = FormulaCalculate.calculate(statState, envMap, batchTime);
            boolean check = calculate != 999999999999999998L && calculate != 999999999999999997L;
            String distinctValue = null;
            if (check) {
                distinctValue = String.valueOf(envMap.get("_d"));
            }
            return Pair.of((Object)check, distinctValue);
        }).filter(Pair::getKey).map(Pair::getValue).distinct().toArray();
        List distinctList = Arrays.stream(distinctArray).collect(Collectors.toList());
        GroupExtEntity groupExtEntity = GroupDBWrapper.queryById(this.statExtEntity.getGroupId());
        if (groupExtEntity == null) {
            return;
        }
        String distinctKey = RedisRoaringFilter.getInstance().getBloomFilterKey(this.statExtEntity, this.dimensValue, statState.getFunctionIndex(), batchTime);
        BitSetFilterSupplier bitSetFilterSupplier = BitSetFilterSupplier.getInstance();
        Iterator iterator = distinctList.iterator();
        while (iterator.hasNext()) {
            String temp = (String)iterator.next();
            long hash = Long.parseLong(temp, 36);
            if (!bitSetFilterSupplier.check(distinctKey, hash)) continue;
            iterator.remove();
        }
        if (distinctList.isEmpty()) {
            return;
        }
        int limit = groupExtEntity.getExtendConfig().getLimitingConfig().getOrDefault(LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING, -1);
        int n = part = limit > 8000 ? 5 : 1;
        long expireSeconds = this.statExtEntity.getTimeUnit() == TimeUnit.DAYS ? TimeUnit.DAYS.toSeconds(2L) : (this.statExtEntity.getTimeUnit() == TimeUnit.HOURS ? TimeUnit.HOURS.toSeconds(2L) : TimeUnit.HOURS.toSeconds(1L));
        long result = RedisRoaringFilter.getInstance().filterWithRoaringMap(distinctKey, distinctList, expireSeconds, part);
        if (logger.isTraceEnabled()) {
            logger.trace("lighthouse trace,distinct evaluate,statId:{},bloomDistinctKey:{},dimens:{},distinctList:{},bloom filter result:{}", new Object[]{this.statExtEntity.getId(), distinctKey, this.dimensValue, JsonUtil.toJSONString(distinctList), result});
        }
        if (result == 0L) {
            return;
        }
        MicroBucket microBucket = new MicroBucket.Builder().setStatId(this.statExtEntity.getId().intValue()).setBatchTime(batchTime).setRowKey(this.rowKey).setDimensValue(this.dimensValue).setCalculateEnum(MicroCalculateEnum.IncCalculate).isLimit(templateEntity.isLimitFlag()).setMetaName(this.metaName).setFunctionIndex(statState.getFunctionIndex()).setColumn(this.delta).setTTL(this.ttl).setValue(result * 1000L).create();
        this.produce(eventPool, microBucket);
        if (logger.isTraceEnabled()) {
            logger.trace("lighthouse trace,bit count evaluate,stat:{},formula:{},dimens:{},message size:{},cost:{}", new Object[]{this.statExtEntity.getId(), templateEntity.getStat(), this.dimensValue, messageList.size(), stopWatch.getTime()});
        }
    }

    static {
        int threadSize = 2;
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("bitcount-consumer-schedule-pool-%d").daemon(true).build());
        for (int i = 0; i < 2; ++i) {
            service.scheduleWithFixedDelay(new ResultStorageThread(eventPool, 5000), 0L, 5L, TimeUnit.SECONDS);
        }
    }
}

