/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.BlockingEventPool;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.counter.CycleCounterAdvisor;
import com.dtstep.lighthouse.common.entity.event.DimensBucket;
import com.dtstep.lighthouse.common.entity.event.SlotEvent;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.functions.DimensStorageThread;
import com.dtstep.lighthouse.core.functions.Process;
import com.dtstep.lighthouse.core.roaring.BitSetFilterSupplier;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.google.common.hash_snp.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DimensStatProcess
extends Process {
    private static final EventPool<DimensBucket> eventPool = new BlockingEventPool("DimensStorageEventPool", 4, 100000);
    private static final DimensStatProcess instance = new DimensStatProcess();
    private static final Logger logger = LoggerFactory.getLogger(DimensStatProcess.class);

    public static DimensStatProcess getInstance() {
        return instance;
    }

    public void process(StatExtEntity statExtEntity, String dimensValue) throws Exception {
        GroupExtEntity groupExtEntity = GroupDBWrapper.queryById(statExtEntity.getGroupId());
        if (groupExtEntity == null) {
            return;
        }
        BitSetFilterSupplier roaringBitMap = BitSetFilterSupplier.getInstance();
        TemplateEntity templateEntity = statExtEntity.getTemplateEntity();
        String[] dimensArr = templateEntity.getDimensArray();
        int i = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(dimensValue, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String value = stringTokenizer.nextToken();
            String existKey = groupExtEntity.getToken() + "_" + dimensArr[i] + "_" + value;
            long hash = Math.abs(Hashing.murmur3_128().hashBytes(existKey.getBytes(StandardCharsets.UTF_8)).asLong());
            if (!roaringBitMap.check("dimens_filter_keys", hash)) {
                long winTime = DateUtil.batchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
                String symbol = "dimens_storage_limit_" + groupExtEntity.getToken() + "_" + dimensArr[i];
                if (CycleCounterAdvisor.incrementAndGet((String)symbol, (long)winTime) > 600L) continue;
                long ttl = this.getTTL(groupExtEntity.getDataExpire());
                if (logger.isTraceEnabled()) {
                    logger.trace("lighthouse trace,save dimens,token:{},dimens:{},dimensValue:{},ttl:{}", new Object[]{groupExtEntity.getToken(), dimensArr[i], value, ttl});
                }
                DimensBucket dimensBucket = new DimensBucket((Group)groupExtEntity, dimensArr[i], value, ttl);
                int slot = HashUtil.getHashIndex((String)(dimensBucket.getGroup().getRandomId() + "_" + dimensBucket.getDimens() + "_" + dimensBucket.getDimensValue()), (int)eventPool.slotSize());
                eventPool.put(slot, (SlotEvent)dimensBucket);
            }
            ++i;
        }
    }

    static {
        int threadSize = 2;
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("dimens-consumer-schedule-pool-%d").daemon(true).build());
        for (int i = 0; i < 2; ++i) {
            service.scheduleWithFixedDelay(new DimensStorageThread(eventPool), 0L, 20L, TimeUnit.SECONDS);
        }
    }
}

