/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.aggregator.SlotsGroup;
import com.dtstep.lighthouse.common.entity.event.DimensBucket;
import com.dtstep.lighthouse.core.storage.dimens.DimensStorageSelector;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DimensStorageThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DimensStorageThread.class);
    private static final long _threadConsumePeriod = TimeUnit.SECONDS.toMillis(20L);
    private static final long _maximumBacklogPeriod = TimeUnit.MINUTES.toMillis(3L);
    private final EventPool<DimensBucket> eventPool;
    private static final int batchSize = 2000;

    DimensStorageThread(EventPool<DimensBucket> eventPool) {
        this.eventPool = eventPool;
    }

    @Override
    public void run() {
        IntStream.range(0, this.eventPool.slotSize()).forEach(this::consumer);
    }

    public void consumer(int slot) {
        try {
            SlotsGroup.SlotWrapper slotWrapper = this.eventPool.take(slot);
            while ((double)slotWrapper.size() > 10000.0 || System.currentTimeMillis() - slotWrapper.getLastAccessTime() > _threadConsumePeriod || System.currentTimeMillis() - slotWrapper.getHeadElementTime() > _maximumBacklogPeriod) {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                List events = slotWrapper.getEvents(2000);
                if (!CollectionUtils.isEmpty((Collection)events)) {
                    DimensStorageSelector.put(events);
                    long cost = stopWatch.getTime();
                    logger.info("process dimens events,thread:{},slot:{},process size:{},remaining size:{},capacity:{},accessTime:{},cost:{}ms", new Object[]{Thread.currentThread().getName(), slot, events.size(), slotWrapper.size(), slotWrapper.getCapacity(), slotWrapper.getLastAccessTime(), cost});
                    if (cost <= _threadConsumePeriod) continue;
                    logger.warn("batch processing dimens events takes too long, and may cause message delays,thread:{},slot:{},cost:{}", new Object[]{Thread.currentThread().getName(), slot, String.format("[%sms > %sms]", cost, _threadConsumePeriod)});
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error("process dimens events error!", (Throwable)ex);
        }
    }
}

