/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.BlockingEventPool;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.calculate.MicroBucket;
import com.dtstep.lighthouse.common.entity.event.LimitBucket;
import com.dtstep.lighthouse.common.entity.event.SlotEvent;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.core.functions.LimitStorageThread;
import com.dtstep.lighthouse.core.functions.Process;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitStatProcess
extends Process {
    private static final EventPool<LimitBucket> eventPool = new BlockingEventPool("LimitStorageEventPool", 5, 500000);
    private static final LimitStatProcess instance = new LimitStatProcess();
    private static final Logger logger = LoggerFactory.getLogger(LimitStatProcess.class);

    public static LimitStatProcess getInstance() {
        return instance;
    }

    public void process(List<MicroBucket> microBucketList) throws Exception {
        if (CollectionUtils.isEmpty(microBucketList)) {
            return;
        }
        for (MicroBucket microBucket : microBucketList) {
            LimitBucket limitBucket = new LimitBucket(microBucket);
            int slot = HashUtil.getHashIndex((String)(limitBucket.getStatId() + "_" + limitBucket.getBatchTime()), (int)eventPool.slotSize());
            eventPool.put(slot, (SlotEvent)limitBucket);
        }
    }

    static {
        int threadSize = 2;
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("limit-consumer-schedule-pool-%d").daemon(true).build());
        for (int i = 0; i < 2; ++i) {
            service.scheduleWithFixedDelay(new LimitStorageThread(eventPool), 0L, 10L, TimeUnit.SECONDS);
        }
    }
}

