/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.aggregator.SlotsGroup;
import com.dtstep.lighthouse.common.entity.event.LimitBucket;
import com.dtstep.lighthouse.core.storage.limit.LimitStorageSelector;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitStorageThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(LimitStorageThread.class);
    private static final long _threadConsumePeriod = TimeUnit.SECONDS.toMillis(90L);
    private static final long _maximumBacklogPeriod = TimeUnit.MINUTES.toMillis(3L);
    private final EventPool<LimitBucket> eventPool;
    private static final int batchSize = 20000;

    LimitStorageThread(EventPool<LimitBucket> eventPool) {
        this.eventPool = eventPool;
    }

    @Override
    public void run() {
        IntStream.range(0, this.eventPool.slotSize()).forEach(this::consumer);
    }

    public void consumer(int slot) {
        try {
            SlotsGroup.SlotWrapper slotWrapper = this.eventPool.take(slot);
            while ((double)slotWrapper.size() > 100000.0 || System.currentTimeMillis() - slotWrapper.getLastAccessTime() > _threadConsumePeriod || System.currentTimeMillis() - slotWrapper.getHeadElementTime() > _maximumBacklogPeriod) {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                List events = slotWrapper.getEvents(20000);
                if (!CollectionUtils.isEmpty((Collection)events)) {
                    LimitStorageSelector.limit(events);
                    long cost = stopWatch.getTime();
                    logger.info("process limit events,thread:{},slot:{},process size:{},remaining size:{},capacity:{},accessTime:{},cost:{}ms", new Object[]{Thread.currentThread().getName(), slot, events.size(), slotWrapper.size(), slotWrapper.getCapacity(), slotWrapper.getLastAccessTime(), cost});
                    if (cost <= _threadConsumePeriod) continue;
                    logger.warn("batch processing limit events takes too long, and may cause message delays,thread:{},slot:{},cost:{}", new Object[]{Thread.currentThread().getName(), slot, String.format("[%sms > %sms]", cost, _threadConsumePeriod)});
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error("process limit events error!", (Throwable)ex);
        }
    }
}

