/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.BlockingEventPool;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.calculate.MicroBucket;
import com.dtstep.lighthouse.common.entity.calculate.MicroCalculateEnum;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.dtstep.lighthouse.core.functions.ResultStorageThread;
import com.dtstep.lighthouse.core.functions.StatProcess;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinStatProcess
extends StatProcess<Pair<String, Long>> {
    private static final long serialVersionUID = -3787393649084533158L;
    private static final Logger logger = LoggerFactory.getLogger(MinStatProcess.class);
    private static final int poolSlotSize = 10;
    private static final EventPool<MicroBucket> eventPool = new BlockingEventPool("MinStorageEventPool", 10, 300000);
    private static final Cache<String, Long> MIN_CACHE = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(10000L).softValues().build();

    public MinStatProcess(StatExtEntity statExtEntity, String metaName, String aggregateKey, String dimensValue) {
        this.statExtEntity = statExtEntity;
        this.metaName = metaName;
        this.aggregateKey = aggregateKey;
        int tempIndex = aggregateKey.indexOf(";");
        String rowKey = aggregateKey.substring(0, tempIndex);
        String delta = aggregateKey.substring(tempIndex + 1);
        this.rowKey = rowKey;
        this.delta = delta;
        this.dimensValue = dimensValue;
        this.ttl = this.getTTL(statExtEntity.getExpired());
    }

    @Override
    public void evaluate(StatState statState, List<Pair<String, Long>> messageList, long batchTime) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        TemplateEntity templateEntity = this.statExtEntity.getTemplateEntity();
        long result = messageList.parallelStream().map(x -> {
            HashMap<String, Object> envMap;
            if (!StringUtil.isEmptyOrNullStr((String)((String)x.getKey()))) {
                Map paramMap = Splitter.on((String)"\u0005").withKeyValueSeparator("\u0006").split((CharSequence)x.getKey());
                envMap = new HashMap(paramMap);
            } else {
                envMap = new HashMap<String, Object>();
            }
            return FormulaCalculate.calculate(statState, envMap, batchTime);
        }).filter(x -> x != 999999999999999998L && x != 999999999999999997L).mapToLong(x -> x).min().orElse(0L);
        Long cacheVar = (Long)MIN_CACHE.getIfPresent((Object)this.aggregateKey);
        if (result == 0L || cacheVar != null && result >= cacheVar) {
            return;
        }
        MIN_CACHE.put((Object)this.aggregateKey, (Object)result);
        MicroBucket microBucket = new MicroBucket.Builder().setStatId(this.statExtEntity.getId().intValue()).setBatchTime(batchTime).setRowKey(this.rowKey).setDimensValue(this.dimensValue).setCalculateEnum(MicroCalculateEnum.MinCalculate).isLimit(templateEntity.isLimitFlag()).setMetaName(this.metaName).setFunctionIndex(statState.getFunctionIndex()).setColumn(this.delta).setTTL(this.ttl).setValue(result).create();
        this.produce(eventPool, microBucket);
        if (logger.isTraceEnabled()) {
            logger.trace("lighthouse trace,min evaluate,stat:{},formula:{},dimens:{},rowKey:{},message size:{},cost:{}", new Object[]{this.statExtEntity.getId(), templateEntity.getStat(), this.dimensValue, this.rowKey, messageList.size(), stopWatch.getTime()});
        }
    }

    static {
        int threadSize = 2;
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)2, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("min-consumer-schedule-pool-%d").daemon(true).build());
        for (int i = 0; i < 2; ++i) {
            service.scheduleWithFixedDelay(new ResultStorageThread(eventPool, 5000), 0L, 5L, TimeUnit.SECONDS);
        }
    }
}

