/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.functions;

import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.aggregator.SlotsGroup;
import com.dtstep.lighthouse.common.entity.calculate.MicroBucket;
import com.dtstep.lighthouse.common.entity.calculate.MicroCalculateEnum;
import com.dtstep.lighthouse.core.functions.LimitStatProcess;
import com.dtstep.lighthouse.core.storage.result.ResultStorageSelector;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultStorageThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ResultStorageThread.class);
    private static final long _threadConsumePeriod = TimeUnit.SECONDS.toMillis(20L);
    private static final long _maximumBacklogPeriod = TimeUnit.MINUTES.toMillis(2L);
    private final EventPool<MicroBucket> eventPool;
    private final int batchSize;

    ResultStorageThread(EventPool<MicroBucket> eventPool, int batchSize) {
        this.eventPool = eventPool;
        this.batchSize = batchSize;
    }

    @Override
    public void run() {
        IntStream.range(0, this.eventPool.slotSize()).forEach(this::consumer);
    }

    public void consumer(int slot) {
        try {
            SlotsGroup.SlotWrapper slotWrapper = this.eventPool.take(slot);
            while ((double)slotWrapper.size() > (double)this.batchSize * 8.0 || System.currentTimeMillis() - slotWrapper.getLastAccessTime() > _threadConsumePeriod || System.currentTimeMillis() - slotWrapper.getHeadElementTime() > _maximumBacklogPeriod) {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                List events = slotWrapper.getEvents(this.batchSize);
                if (!CollectionUtils.isEmpty((Collection)events)) {
                    List<MicroBucket> limitList;
                    List<MicroBucket> seqPutList;
                    List<MicroBucket> minPutList;
                    List<MicroBucket> maxPutList;
                    List<MicroBucket> incrementList;
                    if (logger.isDebugEnabled()) {
                        logger.debug("process storage events start,thread:{},slot:{},process size:{}", new Object[]{Thread.currentThread().getName(), slot, events.size()});
                    }
                    if (!(incrementList = events.stream().filter(x -> x.getCalculateEnum() == MicroCalculateEnum.IncCalculate).collect(Collectors.toList())).isEmpty()) {
                        ResultStorageSelector.increment(incrementList);
                    }
                    if (!(maxPutList = events.stream().filter(x -> x.getCalculateEnum() == MicroCalculateEnum.MaxCalculate).collect(Collectors.toList())).isEmpty()) {
                        ResultStorageSelector.maxPut(maxPutList);
                    }
                    if (!(minPutList = events.stream().filter(x -> x.getCalculateEnum() == MicroCalculateEnum.MinCalculate).collect(Collectors.toList())).isEmpty()) {
                        ResultStorageSelector.minPut(minPutList);
                    }
                    if (!(seqPutList = events.stream().filter(x -> x.getCalculateEnum() == MicroCalculateEnum.SeqCalculate).collect(Collectors.toList())).isEmpty()) {
                        ResultStorageSelector.put(seqPutList);
                    }
                    if (!(limitList = events.stream().filter(MicroBucket::isLimit).collect(Collectors.toList())).isEmpty()) {
                        LimitStatProcess.getInstance().process(limitList);
                    }
                    long cost = stopWatch.getTime();
                    logger.info("process storage events,thread:{},slot:{},process size:{},remaining size:{},capacity:{},accessTime:{},cost:{}ms", new Object[]{Thread.currentThread().getName(), slot, events.size(), slotWrapper.size(), slotWrapper.getCapacity(), slotWrapper.getLastAccessTime(), cost});
                    if (cost <= _threadConsumePeriod) continue;
                    logger.warn("batch processing storage events takes too long, and may cause message delays,thread:{},slot:{},cost:{}", new Object[]{Thread.currentThread().getName(), slot, String.format("[%sms > %sms]", cost, _threadConsumePeriod)});
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error("process storage events error!", (Throwable)ex);
        }
    }
}

