/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.http;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.common.entity.ApiResultCode;
import com.dtstep.lighthouse.common.entity.ApiResultData;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.exception.LimitExceedException;
import com.dtstep.lighthouse.common.exception.PermissionException;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.CallerStat;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.ipc.RPCServer;
import com.dtstep.lighthouse.core.ipc.impl.RPCServerImpl;
import com.dtstep.lighthouse.core.tools.ObjectSize;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(HttpProcessor.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final RPCServer rpc = new RPCServerImpl();

    public static ApiResultData stats(String requestBody) throws Exception {
        List list;
        try {
            list = (List)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        for (Map requestMap : list) {
            ApiResultData apiResultData = HttpProcessor.stat(requestMap);
            if (apiResultData.getCode().equals(ApiResultCode.Success.getCode())) continue;
            return apiResultData;
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage());
    }

    public static ApiResultData stat(String requestBody) throws Exception {
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        return HttpProcessor.stat(requestMap);
    }

    public static ApiResultData stat(Map<String, Object> requestMap) throws Exception {
        String token = (String)requestMap.get("token");
        String secretKey = (String)requestMap.get("secretKey");
        Map params = (Map)requestMap.get("params");
        Long timestamp = (Long)requestMap.get("timestamp");
        Integer repeat = (Integer)requestMap.get("repeat");
        if (token == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"token"}));
        }
        if (secretKey == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"secretKey"}));
        }
        if (params == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"params"}));
        }
        if (timestamp != null && !StringUtil.isNumber((String)timestamp.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"timestamp"}));
        }
        if (repeat != null && !StringUtil.isNumber((String)repeat.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"repeat"}));
        }
        if (repeat != null && Integer.parseInt(repeat.toString()) <= 0) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"repeat <= 0"}));
        }
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        if (repeat == null) {
            repeat = 1;
        }
        try {
            LightHouse.stat((String)token, (String)secretKey, (Map)params, (int)Integer.parseInt(repeat.toString()), (long)Long.parseLong(timestamp.toString()));
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage());
    }

    public static ApiResultData dataQuery(String callerName, String callerKey, String requestBody) throws Exception {
        List<StatValue> data;
        int callerId;
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        Object statIdObj = requestMap.get("statId");
        Object dimensValueObj = requestMap.get("dimensValue");
        List batchList = (List)requestMap.get("batchList");
        if (statIdObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (!StringUtil.isNumber((String)statIdObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (StringUtil.isEmpty((String)callerName)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerName"}));
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerKey"}));
        }
        if (CollectionUtils.isEmpty((Collection)batchList) || !(batchList.get(0) instanceof Long)) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"batchList"}));
        }
        String dimensValue = null;
        if (dimensValueObj != null) {
            dimensValue = dimensValueObj.toString();
        }
        try {
            callerId = rpc.authVerification(callerName, callerKey, Integer.parseInt(statIdObj.toString()), ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.AuthorizationError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize(callerName) + ObjectSize.getObjectSize(callerKey) + ObjectSize.getObjectSize(batchList);
        long outBytes = 0L;
        try {
            data = rpc.dataQuery(Integer.parseInt(statIdObj.toString()), dimensValue, batchList);
            outBytes = ObjectSize.getObjectSize(data);
            CallerStat.stat(callerId, "dataQuery", 0, inBytes, outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat(callerId, "dataQuery", 1, inBytes, outBytes);
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage(), data);
    }

    public static ApiResultData dataDurationQuery(String callerName, String callerKey, String requestBody) throws Exception {
        List<StatValue> data;
        int callerId;
        long endTimeStamp;
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        Object statIdObj = requestMap.get("statId");
        Object dimensValueObj = requestMap.get("dimensValue");
        Object startTimeObj = requestMap.get("startTime");
        Object endTimeObj = requestMap.get("endTime");
        if (statIdObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (!StringUtil.isNumber((String)statIdObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (StringUtil.isEmpty((String)callerName)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerName"}));
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerKey"}));
        }
        String dimensValue = null;
        if (dimensValueObj != null) {
            dimensValue = dimensValueObj.toString();
        }
        if (startTimeObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"startTime"}));
        }
        if (!StringUtil.isNumber((String)startTimeObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"startTime"}));
        }
        if (endTimeObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"endTime"}));
        }
        if (!StringUtil.isNumber((String)endTimeObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"endTime"}));
        }
        long startTimeStamp = Long.parseLong(startTimeObj.toString());
        if (startTimeStamp >= (endTimeStamp = Long.parseLong(endTimeObj.toString()))) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"startTime >= endTime"}));
        }
        try {
            callerId = rpc.authVerification(callerName, callerKey, Integer.parseInt(statIdObj.toString()), ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.AuthorizationError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize(callerName) + ObjectSize.getObjectSize(callerKey) + ObjectSize.getObjectSize(dimensValue);
        long outBytes = 0L;
        try {
            data = rpc.dataDurationQuery(Integer.parseInt(statIdObj.toString()), dimensValue, startTimeStamp, endTimeStamp);
            outBytes = ObjectSize.getObjectSize(data);
            CallerStat.stat(callerId, "dataDurationQuery", 0, inBytes, outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat(callerId, "dataDurationQuery", 1, inBytes, outBytes);
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage(), data);
    }

    public static ApiResultData dataQueryWithDimensList(String callerName, String callerKey, String requestBody) throws Exception {
        Map<String, List<StatValue>> data;
        int callerId;
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        Object statIdObj = requestMap.get("statId");
        List dimensValueListObj = (List)requestMap.get("dimensValueList");
        List batchList = (List)requestMap.get("batchList");
        if (statIdObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (!StringUtil.isNumber((String)statIdObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (StringUtil.isEmpty((String)callerName)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerName"}));
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerKey"}));
        }
        if (dimensValueListObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"dimensValueList"}));
        }
        if (CollectionUtils.isEmpty((Collection)batchList) || !(batchList.get(0) instanceof Long)) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"batchList"}));
        }
        try {
            callerId = rpc.authVerification(callerName, callerKey, Integer.parseInt(statIdObj.toString()), ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.AuthorizationError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize(callerName) + ObjectSize.getObjectSize(callerKey) + ObjectSize.getObjectSize(dimensValueListObj) + ObjectSize.getObjectSize(batchList);
        long outBytes = 0L;
        try {
            data = rpc.dataQueryWithDimensList(Integer.parseInt(statIdObj.toString()), dimensValueListObj, batchList);
            outBytes = ObjectSize.getObjectSize(data);
            CallerStat.stat(callerId, "dataQueryWithDimensList", 0, inBytes, outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat(callerId, "dataQueryWithDimensList", 1, inBytes, outBytes);
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage(), data);
    }

    public static ApiResultData dataDurationQueryWithDimensList(String callerName, String callerKey, String requestBody) throws Exception {
        Map<String, List<StatValue>> data;
        int callerId;
        long endTimeStamp;
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        Object statIdObj = requestMap.get("statId");
        Object dimensValueListObj = requestMap.get("dimensValueList");
        Object startTimeObj = requestMap.get("startTime");
        Object endTimeObj = requestMap.get("endTime");
        if (statIdObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (!StringUtil.isNumber((String)statIdObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (StringUtil.isEmpty((String)callerName)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerName"}));
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerKey"}));
        }
        if (dimensValueListObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"dimensValueList"}));
        }
        if (!(dimensValueListObj instanceof List)) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"dimensValueList"}));
        }
        if (startTimeObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"startTime"}));
        }
        if (!StringUtil.isNumber((String)startTimeObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"startTime"}));
        }
        if (endTimeObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"endTime"}));
        }
        if (!StringUtil.isNumber((String)endTimeObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"endTime"}));
        }
        long startTimeStamp = Long.parseLong(startTimeObj.toString());
        if (startTimeStamp >= (endTimeStamp = Long.parseLong(endTimeObj.toString()))) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"startTime >= endTime"}));
        }
        try {
            callerId = rpc.authVerification(callerName, callerKey, Integer.parseInt(statIdObj.toString()), ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.AuthorizationError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize(callerName) + ObjectSize.getObjectSize(callerKey) + ObjectSize.getObjectSize(dimensValueListObj);
        long outBytes = 0L;
        try {
            data = rpc.dataDurationQueryWithDimensList(Integer.parseInt(statIdObj.toString()), (List)dimensValueListObj, startTimeStamp, endTimeStamp);
            outBytes = ObjectSize.getObjectSize(data);
            CallerStat.stat(callerId, "dataDurationQueryWithDimensList", 0, inBytes, outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat(callerId, "dataDurationQueryWithDimensList", 1, inBytes, outBytes);
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage(), data);
    }

    public static ApiResultData limitQuery(String callerName, String callerKey, String requestBody) throws Exception {
        List<LimitValue> data;
        int callerId;
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        Object statIdObj = requestMap.get("statId");
        Object batchTimeObj = requestMap.get("batchTime");
        if (statIdObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (!StringUtil.isNumber((String)statIdObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"statId"}));
        }
        if (StringUtil.isEmpty((String)callerName)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerName"}));
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerKey"}));
        }
        if (batchTimeObj == null) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"batchTime"}));
        }
        if (!StringUtil.isNumber((String)batchTimeObj.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.IllegalParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"batchTime"}));
        }
        try {
            callerId = rpc.authVerification(callerName, callerKey, Integer.parseInt(statIdObj.toString()), ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.AuthorizationError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize(callerName) + ObjectSize.getObjectSize(callerKey) + ObjectSize.getObjectSize(batchTimeObj);
        long outBytes = 0L;
        try {
            data = rpc.limitQuery(Integer.parseInt(statIdObj.toString()), Long.parseLong(batchTimeObj.toString()));
            outBytes = ObjectSize.getObjectSize(data);
            CallerStat.stat(callerId, "limitQuery", 0, inBytes, outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat(callerId, "limitQuery", 1, inBytes, outBytes);
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage(), data);
    }

    public static ApiResultData viewQuery(String callerName, String callerKey, String requestBody) throws Exception {
        Object result;
        Map requestMap;
        try {
            requestMap = (Map)objectMapper.readValue(requestBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ParametersParseException;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (MapUtils.isEmpty((Map)requestMap)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParams;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.getMessage());
        }
        if (StringUtil.isEmpty((String)callerName)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerName"}));
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"callerKey"}));
        }
        Object source = requestMap.get("source");
        Object config = requestMap.get("config");
        if (source == null || StringUtil.isEmpty((String)source.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"source"}));
        }
        if (config == null || StringUtil.isEmpty((String)config.toString())) {
            ApiResultCode apiResultCode = ApiResultCode.MissingParam;
            return new ApiResultData(apiResultCode.getCode(), apiResultCode.formatMessage(new String[]{"config"}));
        }
        try {
            result = rpc.viewQuery(callerName, callerKey, source.toString(), config.toString());
        }
        catch (PermissionException ex) {
            ApiResultCode apiResultCode = ApiResultCode.AuthorizationError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        catch (LimitExceedException ex) {
            ApiResultCode apiResultCode = ApiResultCode.DataQueryLimitExceedsError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        catch (Exception ex) {
            ApiResultCode apiResultCode = ApiResultCode.ProcessError;
            return new ApiResultData(apiResultCode.getCode(), ex.getMessage());
        }
        return new ApiResultData(ApiResultCode.Success.getCode(), ApiResultCode.Success.getMessage(), result);
    }

    static {
        try {
            if (!LightHouse.isInit()) {
                LightHouse.init((String)LDPConfig.getVal("lighthouse.ice.locators"));
            }
        }
        catch (Exception ex) {
            logger.error("CallerStat initialization error!", (Throwable)ex);
        }
    }
}

