/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.http;

import com.dtstep.lighthouse.common.entity.ApiResultCode;
import com.dtstep.lighthouse.common.entity.ApiResultData;
import com.dtstep.lighthouse.common.entity.monitor.ClusterInfo;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.http.HttpProcessor;
import com.dtstep.lighthouse.core.reactor.AsyncReactorExecutor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServiceHandler.class);
    private static final long JVM_START_TIME = ManagementFactory.getRuntimeMXBean().getStartTime();
    private static final Pattern API_PATTERN = Pattern.compile("/api/rpc/v1/([^/]+)");

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        try {
            if (request.method() == HttpMethod.GET) {
                this.handleGetRequest(ctx, request);
            } else if (request.method() == HttpMethod.POST) {
                this.handlePostRequest(ctx, request);
            } else {
                this.sendError(ctx, request, HttpResponseStatus.METHOD_NOT_ALLOWED, "Unsupported HTTP method.");
            }
        }
        catch (Exception ex) {
            logger.error("Unhandled exception in channelRead0", (Throwable)ex);
            this.sendError(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Internal server error.");
        }
    }

    private void handleGetRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        try {
            String uri = request.uri();
            if (uri.startsWith("/clusterInfo")) {
                ClusterInfo clusterInfo = new ClusterInfo();
                clusterInfo.setRunningMode(LDPConfig.getRunningMode());
                clusterInfo.setStartTime(JVM_START_TIME);
                clusterInfo.setRunningTime(System.currentTimeMillis() - JVM_START_TIME);
                this.sendObjectResponse(ctx, request, HttpResponseStatus.OK, clusterInfo);
            } else {
                logger.warn("The current http service does not allow GET request type! URI: {}", (Object)uri);
                this.sendError(ctx, request, HttpResponseStatus.METHOD_NOT_ALLOWED, "The current http service does not allow GET request type!");
            }
        }
        catch (Exception ex) {
            logger.error("process get error!", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePostRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        boolean isSync;
        request.retain();
        ByteBuf byteBuf = request.content();
        String requestBody = byteBuf.isReadable() ? byteBuf.toString(StandardCharsets.UTF_8) : "";
        String uri = request.uri();
        HttpHeaders headers = request.headers();
        String callerName = Optional.ofNullable(headers.get("Caller-Name")).orElse("");
        String callerKey = Optional.ofNullable(headers.get("Caller-Key")).orElse("");
        long startTime = System.currentTimeMillis();
        boolean bl = isSync = uri.startsWith("/clusterInfo") || uri.startsWith("/api/rpc/v1/stat") || uri.startsWith("/api/rpc/v1/stats");
        if (isSync) {
            try {
                ApiResultData result2;
                if (uri.startsWith("/clusterInfo")) {
                    ClusterInfo clusterInfo = new ClusterInfo();
                    clusterInfo.setRunningMode(LDPConfig.getRunningMode());
                    clusterInfo.setStartTime(JVM_START_TIME);
                    clusterInfo.setRunningTime(System.currentTimeMillis() - JVM_START_TIME);
                    result2 = clusterInfo;
                } else {
                    result2 = this.request(uri, callerName, callerKey, requestBody);
                }
                long duration = System.currentTimeMillis() - startTime;
                logger.debug("Sync request completed in {}ms: {}", (Object)duration, (Object)uri);
                this.sendObjectResponse(ctx, request, HttpResponseStatus.OK, result2);
            }
            catch (Exception e) {
                logger.error("Sync request failed for {}: {}", new Object[]{uri, e.getMessage(), e});
                ApiResultData errorResult = this.buildErrorResult(e);
                this.sendObjectResponse(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR, errorResult);
            }
            finally {
                this.safeRelease(request);
            }
        } else {
            AsyncReactorExecutor.executeAsync(() -> {
                try {
                    return this.request(uri, callerName, callerKey, requestBody);
                }
                catch (Exception e) {
                    logger.error("Error executing async task for URI: {}", (Object)uri, (Object)e);
                    throw new RuntimeException("Async task execution failed: " + e.getMessage(), e);
                }
            }, 60000L).subscribe(result -> ctx.executor().execute(() -> {
                try {
                    long duration = System.currentTimeMillis() - startTime;
                    logger.debug("Async request completed in {}ms: {}", (Object)duration, (Object)uri);
                    this.sendObjectResponse(ctx, request, HttpResponseStatus.OK, result);
                }
                catch (Exception ex) {
                    logger.error("Failed to send async response for {}: {}", new Object[]{uri, ex.getMessage(), ex});
                    this.sendError(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to send response");
                }
                finally {
                    this.safeRelease(request);
                }
            }), error -> ctx.executor().execute(() -> {
                try {
                    long duration = System.currentTimeMillis() - startTime;
                    logger.error("Async HTTP POST processing failed in {}ms: {}", new Object[]{duration, uri, error});
                    ApiResultData errorResult = this.buildErrorResult((Throwable)error);
                    this.sendObjectResponse(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR, errorResult);
                }
                catch (Exception ex) {
                    logger.error("Failed to send async error response for {}: {}", new Object[]{uri, ex.getMessage(), ex});
                    this.sendError(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to send error response");
                }
                finally {
                    this.safeRelease(request);
                }
            }));
        }
    }

    private ApiResultData request(String uri, String callerName, String callerKey, String requestBody) {
        try {
            if (uri.startsWith("/api/rpc/v1/")) {
                String interfaceName;
                switch (interfaceName = this.getInterfaceName(uri)) {
                    case "stat": {
                        return HttpProcessor.stat(requestBody);
                    }
                    case "stats": {
                        return HttpProcessor.stats(requestBody);
                    }
                    case "dataQuery": {
                        return HttpProcessor.dataQuery(callerName, callerKey, requestBody);
                    }
                    case "dataDurationQuery": {
                        return HttpProcessor.dataDurationQuery(callerName, callerKey, requestBody);
                    }
                    case "dataQueryWithDimensList": {
                        return HttpProcessor.dataQueryWithDimensList(callerName, callerKey, requestBody);
                    }
                    case "dataDurationQueryWithDimensList": {
                        return HttpProcessor.dataDurationQueryWithDimensList(callerName, callerKey, requestBody);
                    }
                    case "limitQuery": {
                        return HttpProcessor.limitQuery(callerName, callerKey, requestBody);
                    }
                    case "viewQuery": {
                        return HttpProcessor.viewQuery(callerName, callerKey, requestBody);
                    }
                }
                logger.warn("Unsupported API interface: {}", (Object)interfaceName);
                return new ApiResultData(ApiResultCode.ApiNotSupported.getCode(), ApiResultCode.ApiNotSupported.getMessage());
            }
            return new ApiResultData(ApiResultCode.ApiNotSupported.getCode(), ApiResultCode.ApiNotSupported.getMessage());
        }
        catch (Exception e) {
            logger.error("Error processing request for URI: {}", (Object)uri, (Object)e);
            throw new RuntimeException("Request processing failed: " + e.getMessage(), e);
        }
    }

    private ApiResultData buildErrorResult(Throwable error) {
        String errorMessage = error instanceof TimeoutException ? "Request timeout" : (error.getCause() != null ? error.getCause().getMessage() : error.getMessage());
        if (errorMessage == null || errorMessage.trim().isEmpty()) {
            errorMessage = "Internal server error";
        }
        return new ApiResultData(ApiResultCode.SystemError.getCode(), errorMessage);
    }

    private String getInterfaceName(String uri) {
        String cleanedUrl = uri.replaceAll("/+", "/");
        Matcher matcher = API_PATTERN.matcher(cleanedUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Unhandled exception caught in pipeline, closing channel", cause);
        ctx.close();
    }

    private void sendObjectResponse(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status, Object responseObj) {
        try {
            String jsonResponse = JsonUtil.toJSONString((Object)responseObj);
            byte[] responseBytes = jsonResponse.getBytes(StandardCharsets.UTF_8);
            ByteBuf buf = ctx.alloc().ioBuffer(responseBytes.length);
            buf.writeBytes(responseBytes);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buf);
            HttpHeaders headers = response.headers();
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
            headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)responseBytes.length);
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            if (keepAlive) {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
            ChannelFuture future = ctx.writeAndFlush((Object)response);
            if (!keepAlive) {
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            logger.error("Failed to send object response", (Throwable)e);
            this.sendError(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Error generating response");
        }
    }

    private void sendError(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status, String message) {
        try {
            ApiResultData errorResult = new ApiResultData(ApiResultCode.ProcessError.getCode(), message);
            String jsonResponse = JsonUtil.toJSONString((Object)errorResult);
            byte[] content = jsonResponse.getBytes(StandardCharsets.UTF_8);
            ByteBuf buf = ctx.alloc().ioBuffer(content.length);
            buf.writeBytes(content);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buf);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length);
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (Exception e) {
            logger.error("Failed to send error response", (Throwable)e);
            ctx.close();
        }
    }

    private void safeRelease(FullHttpRequest request) {
        if (request != null && request.refCnt() > 0) {
            request.release();
        }
    }
}

