/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.ipc.impl;

import com.dtstep.lighthouse.common.entity.LabelValue;
import com.dtstep.lighthouse.common.entity.ViewStatBindItem;
import com.dtstep.lighthouse.common.entity.ViewStatBindsInfo;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.StatVerifyEntity;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.CallerStateEnum;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.exception.LimitExceedException;
import com.dtstep.lighthouse.common.exception.PermissionException;
import com.dtstep.lighthouse.common.modal.Caller;
import com.dtstep.lighthouse.common.modal.HttpRequestConfig;
import com.dtstep.lighthouse.common.modal.IndicatorValue;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.OkHttpUtil;
import com.dtstep.lighthouse.common.util.SnappyUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.batch.BatchAdapter;
import com.dtstep.lighthouse.core.ipc.DisruptorEventProducer;
import com.dtstep.lighthouse.core.ipc.RPCServer;
import com.dtstep.lighthouse.core.storage.common.IndicatorGet;
import com.dtstep.lighthouse.core.storage.limit.LimitStorageSelector;
import com.dtstep.lighthouse.core.storage.result.ResultStorageSelector;
import com.dtstep.lighthouse.core.tools.TimePeriodUtil;
import com.dtstep.lighthouse.core.tools.TimePointUtil;
import com.dtstep.lighthouse.core.wrapper.CallerDBWrapper;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.core.wrapper.PermissionDBWrapper;
import com.dtstep.lighthouse.core.wrapper.RoleDBWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.google.common.base.Splitter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCServerImpl
implements RPCServer {
    private static final Logger logger = LoggerFactory.getLogger(RPCServerImpl.class);
    private static final DisruptorEventProducer eventProducer = new DisruptorEventProducer();

    @Override
    public int authVerification(String callerName, String callerKey, int resourceId, ResourceTypeEnum resourceTypeEnum) throws Exception {
        if (StringUtil.isEmpty((String)callerName)) {
            throw new IllegalArgumentException("Missing required parameters[callerName]!");
        }
        if (StringUtil.isEmpty((String)callerKey)) {
            throw new IllegalArgumentException("Missing required parameters[callerKey]!");
        }
        Caller caller = CallerDBWrapper.queryByName(callerName);
        if (caller == null) {
            throw new PermissionException("API caller[" + callerName + "] does not exist!");
        }
        if (caller.getState() != CallerStateEnum.NORMAL) {
            throw new PermissionException("API caller[" + callerName + "] status is unavailable!");
        }
        if (!callerKey.equals(caller.getSecretKey())) {
            throw new PermissionException("API caller[" + callerName + "] secret-key verification failed!");
        }
        Role role = RoleDBWrapper.queryAccessRoleByResource(resourceId, resourceTypeEnum);
        if (role == null) {
            throw new PermissionException("API caller[" + callerName + "] is not authorized to access this resource!");
        }
        boolean hasPermission = PermissionDBWrapper.hasPermission(caller.getId(), OwnerTypeEnum.CALLER, role.getId());
        if (!hasPermission) {
            throw new PermissionException("API caller[" + callerName + "] is not authorized to access this resource!");
        }
        return caller.getId();
    }

    @Override
    public GroupVerifyEntity queryGroupInfo(String token) throws Exception {
        GroupExtEntity groupExtEntity = GroupDBWrapper.queryByToken(token);
        GroupVerifyEntity groupVerifyEntity = null;
        if (groupExtEntity != null) {
            groupVerifyEntity = new GroupVerifyEntity();
            groupVerifyEntity.setVerifyKey(groupExtEntity.getVerifyKey());
            groupVerifyEntity.setRelationColumns(groupExtEntity.getRunningRelatedColumns());
            groupVerifyEntity.setState(groupExtEntity.getState());
            groupVerifyEntity.setGroupId(groupExtEntity.getId().intValue());
            groupVerifyEntity.setToken(groupExtEntity.getToken());
            groupVerifyEntity.setMinTimeParam(groupExtEntity.getMinTimeParam());
            if (logger.isTraceEnabled()) {
                logger.trace("query groupInfo by token,token:{},groupInfo:{}", (Object)token, (Object)JsonUtil.toJSONString((Object)groupVerifyEntity));
            }
        }
        return groupVerifyEntity;
    }

    @Override
    public StatVerifyEntity queryStatInfo(int id) throws Exception {
        StatExtEntity statExtEntity = StatDBWrapper.queryById(id);
        StatVerifyEntity statVerifyEntity = null;
        if (statExtEntity != null) {
            statVerifyEntity = new StatVerifyEntity();
            String token = statExtEntity.getToken();
            GroupVerifyEntity groupVerifyEntity = this.queryGroupInfo(token);
            statVerifyEntity.setStatId(id);
            statVerifyEntity.setVerifyKey(groupVerifyEntity.getVerifyKey());
        }
        return statVerifyEntity;
    }

    @Override
    public void process(byte[] bytes) throws Exception {
        if (bytes == null) {
            return;
        }
        String data = SnappyUtil.isCompress((byte[])bytes) ? SnappyUtil.uncompressByte((byte[])bytes) : new String(bytes, StandardCharsets.UTF_8);
        if (StringUtil.isEmpty((String)data)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("lighthouse debug,ice service receive message:{}", (Object)data);
        }
        for (String temp : Splitter.on((String)"\u0003").split((CharSequence)data)) {
            if (StringUtil.isEmpty((String)temp)) continue;
            int index = temp.lastIndexOf("\u0004");
            eventProducer.onData(temp.substring(0, index), Integer.parseInt(temp.substring(index + 1)));
        }
    }

    @Override
    public List<StatValue> dataQuery(int statId, String dimensValue, List<Long> batchList) throws Exception {
        StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
        if (statExtEntity == null) {
            throw new IllegalArgumentException("statistic:" + statId + " not exist!");
        }
        return ResultStorageSelector.query(statExtEntity, dimensValue, batchList);
    }

    @Override
    public List<StatValue> dataDurationQuery(int statId, String dimensValue, long startTime, long endTime) throws Exception {
        List<Long> batchList;
        StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
        if (statExtEntity == null) {
            throw new IllegalArgumentException("statistic:" + statId + " not exist!");
        }
        try {
            batchList = BatchAdapter.queryBatchTimeList(statExtEntity.getTimeparam(), startTime, endTime);
        }
        catch (Exception ex) {
            logger.error("query batch list error,statId:{}", (Object)statId, (Object)ex);
            throw ex;
        }
        return ResultStorageSelector.query(statExtEntity, dimensValue, batchList);
    }

    @Override
    public Map<String, List<StatValue>> dataQueryWithDimensList(int statId, List<String> dimensValueList, List<Long> batchList) throws Exception {
        StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
        if (statExtEntity == null) {
            throw new IllegalArgumentException("statistic:" + statId + " not exist!");
        }
        return ResultStorageSelector.queryWithDimensList(statExtEntity, dimensValueList, batchList);
    }

    @Override
    public Map<String, List<StatValue>> dataDurationQueryWithDimensList(int statId, List<String> dimensValueList, long startTime, long endTime) throws Exception {
        List<Long> batchList;
        StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
        if (statExtEntity == null) {
            throw new IllegalArgumentException("statistic:" + statId + " not exist!");
        }
        try {
            batchList = BatchAdapter.queryBatchTimeList(statExtEntity.getTimeparam(), startTime, endTime);
        }
        catch (Exception ex) {
            logger.error("query batch list error,statId:{}", (Object)statId, (Object)ex);
            throw ex;
        }
        return ResultStorageSelector.queryWithDimensList(statExtEntity, dimensValueList, batchList);
    }

    @Override
    public List<LimitValue> limitQuery(int statId, long batchTime) throws Exception {
        StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
        if (statExtEntity == null) {
            throw new IllegalArgumentException("statistic:" + statId + " not exist!");
        }
        return LimitStorageSelector.query(statExtEntity, batchTime);
    }

    @Override
    public Object viewQuery(String callerName, String callerKey, String source, String config) throws Exception {
        if ("remote".equals(source)) {
            HttpRequestConfig httpRequestConfig = (HttpRequestConfig)JsonUtil.toJavaObject((String)config, HttpRequestConfig.class);
            if (httpRequestConfig == null) {
                throw new IllegalArgumentException();
            }
            if (StringUtil.isEmpty((String)httpRequestConfig.getUrl())) {
                throw new IllegalArgumentException();
            }
            if (StringUtil.isEmpty((String)httpRequestConfig.getMethod())) {
                throw new IllegalArgumentException();
            }
            Validate.notNull((Object)httpRequestConfig);
            return OkHttpUtil.request((HttpRequestConfig)httpRequestConfig);
        }
        if ("stat".equals(source)) {
            ViewStatBindsInfo bindsInfo = (ViewStatBindsInfo)JsonUtil.toJavaObject((String)config, ViewStatBindsInfo.class);
            if (bindsInfo == null || bindsInfo.getBinds() == null) {
                throw new IllegalArgumentException();
            }
            return this.queryStatData(callerName, callerKey, bindsInfo);
        }
        throw new IllegalArgumentException();
    }

    private List<IndicatorValue> queryStatData(String callerName, String callerKey, ViewStatBindsInfo viewStatBindsInfo) throws Exception {
        String mode = viewStatBindsInfo.getMode();
        if ("period".equals(mode)) {
            return this.queryStatDataByPeriod(callerName, callerKey, viewStatBindsInfo.getBinds(), viewStatBindsInfo.getDimens());
        }
        return this.queryStatDataByPoint(callerName, callerKey, viewStatBindsInfo.getBinds(), viewStatBindsInfo.getDimens());
    }

    private List<IndicatorValue> queryStatDataByPeriod(String callerName, String callerKey, List<ViewStatBindItem> binds, List<LabelValue> globalDimensList) throws Exception {
        ArrayList<IndicatorGet> indicatorGets = new ArrayList<IndicatorGet>();
        HashMap<String, String> globalDimensMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(globalDimensList)) {
            for (LabelValue labelValue : globalDimensList) {
                globalDimensMap.put(labelValue.getValue().toString(), labelValue.getLabel());
            }
        }
        HashMap localDimensMap = new HashMap();
        HashMap<CallSite, Object> aliasMap = new HashMap<CallSite, Object>();
        ArrayList<TimeUnit> timeUnits = new ArrayList<TimeUnit>();
        ArrayList<IndicatorValue> valueList = new ArrayList<IndicatorValue>();
        for (ViewStatBindItem bindItem : binds) {
            long[] periodArr;
            List localDimensList;
            int indicator;
            StatExtEntity statExtEntity;
            Integer statId = bindItem.getStatId();
            if (statId == null || (statExtEntity = StatDBWrapper.queryById(statId)) == null || (indicator = bindItem.getIndicator().intValue()) > statExtEntity.getTemplateEntity().getStatStateList().size()) continue;
            this.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
            ArrayList<LabelValue> allDimensList = new ArrayList<LabelValue>();
            if (CollectionUtils.isNotEmpty(globalDimensList)) {
                allDimensList.addAll(globalDimensList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(localDimensList = bindItem.getDimens()))) {
                allDimensList.addAll(localDimensList);
                HashMap<String, String> statMapper = new HashMap<String, String>();
                for (LabelValue labelValue : localDimensList) {
                    statMapper.put(String.valueOf(labelValue.getValue()), labelValue.getLabel());
                }
                localDimensMap.put((CallSite)((Object)(statId + "-" + indicator)), statMapper);
            }
            TimeUnit timeUnit = statExtEntity.getTimeUnit();
            timeUnits.add(timeUnit);
            Object alias = bindItem.getAlias();
            if (alias == null || "".equals(alias)) {
                alias = indicator == 0 ? "[" + statId + "]-Default" : "[" + statId + "]-Indicator" + indicator;
            }
            aliasMap.put((CallSite)((Object)(statId + "-" + indicator)), alias);
            String period = bindItem.getTimePeriod();
            try {
                periodArr = TimePeriodUtil.resolvePeriod(period);
            }
            catch (Exception ex) {
                return valueList;
            }
            long startTime = periodArr[0];
            long endTime = periodArr[1];
            List<Long> batchList = BatchAdapter.queryBatchTimeList(statExtEntity.getTimeparam(), startTime, endTime);
            int dimensLength = statExtEntity.getTemplateEntity().getDimensArray().length;
            if (dimensLength > 0) {
                for (LabelValue labelValue : allDimensList) {
                    String value = labelValue.getValue().toString();
                    if (value.split(";").length != dimensLength) continue;
                    for (Long batchTime : batchList) {
                        IndicatorGet indicatorGet = new IndicatorGet();
                        indicatorGet.setDimensValue(value);
                        indicatorGet.setStatId(statId);
                        indicatorGet.setBatchTime(batchTime);
                        indicatorGet.setIndicatorIndex(indicator);
                        if (indicatorGets.size() > 50000) {
                            throw new LimitExceedException();
                        }
                        indicatorGets.add(indicatorGet);
                    }
                }
                continue;
            }
            for (Long batchTime : batchList) {
                IndicatorGet indicatorGet = new IndicatorGet();
                indicatorGet.setDimensValue(null);
                indicatorGet.setStatId(statId);
                indicatorGet.setBatchTime(batchTime);
                indicatorGet.setIndicatorIndex(bindItem.getIndicator());
                if (indicatorGets.size() > 50000) {
                    throw new LimitExceedException();
                }
                indicatorGets.add(indicatorGet);
            }
        }
        String timeFormat = RPCServerImpl.resolveDateFormat(timeUnits);
        HashMap<IndicatorGet, Object> resultMap = ResultStorageSelector.query(indicatorGets);
        if (MapUtils.isNotEmpty(resultMap)) {
            for (IndicatorGet indicatorGet : resultMap.keySet()) {
                IndicatorValue indicatorValue = new IndicatorValue();
                int statId = indicatorGet.getStatId();
                int indicator = indicatorGet.getIndicatorIndex();
                indicatorValue.setAlias((String)aliasMap.get(statId + "-" + indicator));
                indicatorValue.setValue(resultMap.get(indicatorGet));
                String rawDimensValue = indicatorGet.getDimensValue();
                String mappedLabel = RPCServerImpl.mapDimensValue(rawDimensValue, (Map)localDimensMap.get(statId + "-" + indicator), globalDimensMap);
                indicatorValue.setCategory(DateUtil.formatTimeStamp((long)indicatorGet.getBatchTime(), (String)timeFormat));
                indicatorValue.setSeries(mappedLabel);
                valueList.add(indicatorValue);
            }
        }
        valueList.sort(Comparator.comparing(IndicatorValue::getCategory, Comparator.nullsFirst(String::compareTo)).thenComparing(IndicatorValue::getAlias, Comparator.nullsFirst(String::compareTo)));
        return valueList;
    }

    private List<IndicatorValue> queryStatDataByPoint(String callerName, String callerKey, List<ViewStatBindItem> binds, List<LabelValue> globalDimensList) throws Exception {
        ArrayList<IndicatorGet> indicatorGets = new ArrayList<IndicatorGet>();
        HashMap<String, String> globalDimensMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(globalDimensList)) {
            for (LabelValue labelValue : globalDimensList) {
                globalDimensMap.put(labelValue.getValue().toString(), labelValue.getLabel());
            }
        }
        HashMap localDimensMap = new HashMap();
        HashMap<CallSite, Object> aliasMap = new HashMap<CallSite, Object>();
        ArrayList<TimeUnit> timeUnits = new ArrayList<TimeUnit>();
        ArrayList<IndicatorValue> valueList = new ArrayList<IndicatorValue>();
        for (ViewStatBindItem bindItem : binds) {
            Object alias;
            List localDimensList;
            StatExtEntity statExtEntity;
            Integer statId = bindItem.getStatId();
            if (statId == null || (statExtEntity = StatDBWrapper.queryById(statId)) == null) continue;
            this.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
            int indicator = bindItem.getIndicator();
            if (indicator > statExtEntity.getTemplateEntity().getStatStateList().size()) continue;
            TimeUnit timeUnit = statExtEntity.getTimeUnit();
            timeUnits.add(timeUnit);
            ArrayList<LabelValue> allDimensList = new ArrayList<LabelValue>();
            if (CollectionUtils.isNotEmpty(globalDimensList)) {
                allDimensList.addAll(globalDimensList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(localDimensList = bindItem.getDimens()))) {
                allDimensList.addAll(localDimensList);
                HashMap<String, String> statMapper = new HashMap<String, String>();
                for (LabelValue labelValue : localDimensList) {
                    statMapper.put(String.valueOf(labelValue.getValue()), labelValue.getLabel());
                }
                localDimensMap.put((CallSite)((Object)(statId + "-" + indicator)), statMapper);
            }
            if ((alias = bindItem.getAlias()) == null || "".equals(alias)) {
                alias = indicator == 0 ? "[" + statId + "]-Default" : "[" + statId + "]-Indicator" + indicator;
            }
            aliasMap.put((CallSite)((Object)(statId + "-" + indicator)), alias);
            String timePoint = bindItem.getTimePoint();
            long batchTime = TimePointUtil.getBatchTime(statExtEntity, System.currentTimeMillis(), timePoint);
            if (batchTime == 999999999999999997L) {
                return valueList;
            }
            int dimensLength = statExtEntity.getTemplateEntity().getDimensArray().length;
            if (dimensLength > 0) {
                for (LabelValue labelValue : allDimensList) {
                    String value = labelValue.getValue().toString();
                    if (value.split(";").length != dimensLength) continue;
                    IndicatorGet indicatorGet = new IndicatorGet();
                    indicatorGet.setDimensValue(value);
                    indicatorGet.setStatId(statId);
                    indicatorGet.setBatchTime(batchTime);
                    indicatorGet.setIndicatorIndex(indicator);
                    if (indicatorGets.size() > 50000) {
                        throw new LimitExceedException();
                    }
                    indicatorGets.add(indicatorGet);
                }
                continue;
            }
            IndicatorGet indicatorGet = new IndicatorGet();
            indicatorGet.setDimensValue(null);
            indicatorGet.setStatId(statId);
            indicatorGet.setBatchTime(batchTime);
            indicatorGet.setIndicatorIndex(bindItem.getIndicator());
            if (indicatorGets.size() > 50000) {
                throw new LimitExceedException();
            }
            indicatorGets.add(indicatorGet);
        }
        String timeFormat = RPCServerImpl.resolveDateFormat(timeUnits);
        HashMap<IndicatorGet, Object> resultMap = ResultStorageSelector.query(indicatorGets);
        if (MapUtils.isNotEmpty(resultMap)) {
            for (IndicatorGet indicatorGet : resultMap.keySet()) {
                IndicatorValue indicatorValue = new IndicatorValue();
                int statId = indicatorGet.getStatId();
                int indicator = indicatorGet.getIndicatorIndex();
                indicatorValue.setAlias((String)aliasMap.get(statId + "-" + indicator));
                indicatorValue.setValue(resultMap.get(indicatorGet));
                indicatorValue.setCategory(DateUtil.formatTimeStamp((long)indicatorGet.getBatchTime(), (String)timeFormat));
                String rawDimensValue = indicatorGet.getDimensValue();
                String mappedLabel = RPCServerImpl.mapDimensValue(rawDimensValue, (Map)localDimensMap.get(statId + "-" + indicator), globalDimensMap);
                indicatorValue.setSeries(mappedLabel);
                valueList.add(indicatorValue);
            }
        }
        valueList.sort(Comparator.comparing(IndicatorValue::getAlias, Comparator.nullsFirst(String::compareTo)).thenComparing(IndicatorValue::getCategory, Comparator.nullsFirst(String::compareTo)));
        return valueList;
    }

    private static String mapDimensValue(String rawValue, Map<String, String> statDimensMap, Map<String, String> globalDimensMap) {
        if (rawValue == null) {
            return null;
        }
        if (statDimensMap != null && statDimensMap.containsKey(rawValue)) {
            return statDimensMap.get(rawValue);
        }
        if (globalDimensMap != null && globalDimensMap.containsKey(rawValue)) {
            return globalDimensMap.get(rawValue);
        }
        return rawValue;
    }

    public static String resolveDateFormat(Collection<TimeUnit> units) {
        if (units == null || units.isEmpty()) {
            return "MMdd HH:mm";
        }
        boolean hasDay = false;
        boolean hasHour = false;
        boolean hasMinute = false;
        for (TimeUnit unit : units) {
            switch (unit) {
                case DAYS: {
                    hasDay = true;
                    break;
                }
                case HOURS: {
                    hasHour = true;
                    break;
                }
                case MINUTES: {
                    hasMinute = true;
                    break;
                }
            }
        }
        if (hasDay) {
            if (hasHour || hasMinute) {
                return "yyyyMMdd HH:mm";
            }
            return "yyyyMMdd";
        }
        if (hasHour) {
            if (hasMinute) {
                return "MMdd HH:mm";
            }
            return "MMdd HH:00";
        }
        if (hasMinute) {
            return "MMdd HH:mm";
        }
        return "MMdd HH:mm";
    }
}

