/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.limiting;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.core.callback.CallBackMain;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.limiting.strategy.Strategy;
import com.dtstep.lighthouse.core.limiting.strategy.impl.GroupMsgStrategyService;
import com.dtstep.lighthouse.core.limiting.strategy.impl.StatResultStrategyService;
import com.dtstep.lighthouse.core.limiting.trigger.Trigger;
import com.dtstep.lighthouse.core.limiting.trigger.impl.GroupLimitingTrigger;
import com.dtstep.lighthouse.core.limiting.trigger.impl.StatLimitingTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LimitingContext {
    private static final Logger logger = LoggerFactory.getLogger(LimitingContext.class);
    private static final LimitingContext context = new LimitingContext();
    private static final Strategy<GroupExtEntity> groupLimitingService = new GroupMsgStrategyService();
    private static final Strategy<StatExtEntity> statLimitingService = new StatResultStrategyService();
    private static final Trigger<GroupExtEntity> groupTrigger = new GroupLimitingTrigger();
    private static final Trigger<StatExtEntity> statTrigger = new StatLimitingTrigger();

    private LimitingContext() {
    }

    public static LimitingContext getInstance() {
        return context;
    }

    public boolean tryAcquire(GroupExtEntity groupExtEntity, int permitsPerSecond, int step) {
        if (!LDPConfig.limitedEnable()) {
            return true;
        }
        if (groupExtEntity.getState() == GroupStateEnum.LIMITING) {
            return false;
        }
        if (permitsPerSecond == -1) {
            return true;
        }
        boolean isAcquire = false;
        try {
            isAcquire = groupLimitingService.process(groupExtEntity, permitsPerSecond, step);
        }
        catch (Exception ex) {
            logger.error("limiting tryAcquire error!", (Throwable)ex);
        }
        if (!isAcquire) {
            try {
                CallBackMain.getInstance().execute(groupTrigger, groupExtEntity);
            }
            catch (Exception ex) {
                logger.error("group limiting callback execute error!", (Throwable)ex);
            }
        }
        return isAcquire;
    }

    public boolean tryAcquire(StatExtEntity statExtEntity, int permitsPerSecond, int step) {
        if (!LDPConfig.limitedEnable()) {
            return true;
        }
        if (statExtEntity.getState() == StatStateEnum.LIMITING) {
            return false;
        }
        if (permitsPerSecond == -1) {
            return true;
        }
        boolean isAcquire = false;
        try {
            isAcquire = statLimitingService.process(statExtEntity, permitsPerSecond, step);
        }
        catch (Exception ex) {
            logger.error("check stat limiting error!", (Throwable)ex);
        }
        if (!isAcquire) {
            try {
                CallBackMain.getInstance().execute(statTrigger, statExtEntity);
            }
            catch (Exception ex) {
                logger.error("stat limiting callback execute error!", (Throwable)ex);
            }
        }
        return isAcquire;
    }
}

