/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.limiting.strategy.impl;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.limiting.device.CountingDevice;
import com.dtstep.lighthouse.core.limiting.strategy.AbstractStrategy;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class GroupMsgStrategyService
extends AbstractStrategy<GroupExtEntity> {
    private static final List<CountingDevice> countingDeviceList = GroupMsgStrategyService.getDeviceList(LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING);
    private static final StatExtEntity builtInStat = BuiltinLoader.getBuiltinStat(1014);

    @Override
    public boolean process(GroupExtEntity groupExtEntity, int permitsPerSecond, int step) throws Exception {
        CountingDevice.Params params = new CountingDevice.Params(LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING, builtInStat, groupExtEntity.getId(), permitsPerSecond, step);
        if (CollectionUtils.isEmpty(countingDeviceList)) {
            return true;
        }
        for (CountingDevice recorder : countingDeviceList) {
            if (recorder.tryRequire(params)) continue;
            return false;
        }
        return true;
    }
}

