/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.limiting.trigger.impl;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.RecordTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.modal.Record;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.limiting.trigger.Trigger;
import com.dtstep.lighthouse.core.lock.RedissonLock;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.core.wrapper.LimitingWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupLimitingTrigger
implements Trigger<GroupExtEntity> {
    private static final Logger logger = LoggerFactory.getLogger(GroupLimitingTrigger.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(GroupExtEntity groupExtEntity) throws Exception {
        String lockKey = "lock_group_limited_" + groupExtEntity.getId();
        boolean isLock = RedissonLock.tryLock(lockKey, 30L, 120L, TimeUnit.SECONDS);
        if (isLock) {
            try {
                LocalDateTime localDateTime = LocalDateTime.now();
                int result = GroupDBWrapper.changeState(groupExtEntity.getId(), GroupStateEnum.LIMITING, localDateTime);
                if (result == 1) {
                    logger.info("group changed to the limiting state,groupId:{}", (Object)groupExtEntity.getId());
                    Record limitingRecord = new Record();
                    long startTime = DateUtil.translateToTimeStamp((LocalDateTime)localDateTime);
                    limitingRecord.setRecordType(RecordTypeEnum.GROUP_MESSAGE_LIMITING);
                    limitingRecord.setResourceId(groupExtEntity.getId());
                    limitingRecord.setResourceType(ResourceTypeEnum.Group);
                    ObjectNode extendNode = JsonUtil.createObjectNode();
                    extendNode.put("strategy", LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING.getStrategy());
                    extendNode.put("startTime", startTime);
                    extendNode.put("endTime", DateUtil.getMinuteAfter((long)startTime, (int)15));
                    limitingRecord.setExtend(extendNode.toString());
                    limitingRecord.setCreateTime(localDateTime);
                    LimitingWrapper.record(limitingRecord);
                }
            }
            catch (Exception ex) {
                logger.error("group limiting trigger process error!", (Throwable)ex);
            }
            finally {
                RedissonLock.unLock(lockKey);
            }
        }
    }
}

