/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.limiting.trigger.impl;

import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.RecordTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.common.modal.Record;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.limiting.trigger.Trigger;
import com.dtstep.lighthouse.core.lock.RedissonLock;
import com.dtstep.lighthouse.core.wrapper.LimitingWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatLimitingTrigger
implements Trigger<StatExtEntity> {
    private static final Logger logger = LoggerFactory.getLogger(StatLimitingTrigger.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(StatExtEntity statExtEntity) throws Exception {
        String lockKey = "lock_stat_limited_" + statExtEntity.getId();
        boolean isLock = RedissonLock.tryLock(lockKey, 30L, 120L, TimeUnit.SECONDS);
        if (isLock) {
            try {
                LocalDateTime localDateTime = LocalDateTime.now();
                int result = StatDBWrapper.changeState(statExtEntity.getId(), StatStateEnum.LIMITING, localDateTime);
                if (result == 1) {
                    logger.info("lighthouse limited,the statistics stat was changed to the current limiting state,statId:{}", (Object)statExtEntity.getId());
                    Record limitingRecord = new Record();
                    long startTime = DateUtil.translateToTimeStamp((LocalDateTime)localDateTime);
                    limitingRecord.setRecordType(RecordTypeEnum.STAT_RESULT_LIMITING);
                    limitingRecord.setResourceId(statExtEntity.getId());
                    limitingRecord.setResourceType(ResourceTypeEnum.Stat);
                    limitingRecord.setCreateTime(LocalDateTime.now());
                    ObjectNode extendNode = JsonUtil.createObjectNode();
                    extendNode.put("strategy", LimitingStrategyEnum.STAT_RESULT_SIZE_LIMITING.getStrategy());
                    extendNode.put("startTime", startTime);
                    extendNode.put("endTime", DateUtil.getMinuteAfter((long)startTime, (int)15));
                    limitingRecord.setExtend(extendNode.toString());
                    LimitingWrapper.record(limitingRecord);
                }
            }
            catch (Exception ex) {
                logger.error("stat limiting trigger process error!", (Throwable)ex);
            }
            finally {
                RedissonLock.unLock(lockKey);
            }
        }
    }
}

