/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.preparing.handler.expand;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.result.MessageCaptchaEnum;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.sbr.StringBuilderHolder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.distinct.RedisRoaringFilter;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.dtstep.lighthouse.core.limiting.LimitingContext;
import com.dtstep.lighthouse.core.preparing.handler.expand.ExpandEvent;
import com.dtstep.lighthouse.core.preparing.handler.expand.ExpandHandler;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.dtstep.lighthouse.core.wrapper.DimensDBWrapper;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash_snp.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpandHandler
implements ExpandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpandHandler.class);
    private static final KeyGenerator keyGenerator = new DefaultKeyGenerator();

    @Override
    public List<ExpandEvent> expand(MessageCaptchaEnum messageCaptchaEnum, LightMessage lightMessage) throws Exception {
        ImmutableMap paramMap;
        List<ExpandEvent> list;
        GroupExtEntity groupEntity = GroupDBWrapper.queryById(lightMessage.getGroupId());
        if (groupEntity == null || groupEntity.getState() != GroupStateEnum.RUNNING) {
            return null;
        }
        ArrayList<ExpandEvent> eventList = new ArrayList<ExpandEvent>();
        int captcha = messageCaptchaEnum.getCaptcha();
        if (!groupEntity.isBuiltIn() && CollectionUtils.isNotEmpty(list = this.appendBuiltInMonitor("_builtin_msg_stat", (Map<String, String>)(paramMap = ImmutableMap.of((Object)"groupId", (Object)String.valueOf(groupEntity.getId()), (Object)"captcha", (Object)String.valueOf(captcha))), lightMessage.getRepeat()))) {
            eventList.addAll(list);
        }
        if (messageCaptchaEnum != MessageCaptchaEnum.SUCCESS) {
            return eventList;
        }
        List<StatExtEntity> statList = StatDBWrapper.queryRunningListByGroupId(groupEntity.getId());
        if (CollectionUtils.isNotEmpty(statList)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Group:{},valid statistical items size:{}", (Object)groupEntity.getId(), (Object)statList.size());
            }
            for (StatExtEntity statEntity : statList) {
                List<ExpandEvent> childList = this.append(statEntity, groupEntity, lightMessage);
                if (!CollectionUtils.isNotEmpty(childList)) continue;
                eventList.addAll(childList);
            }
        }
        return eventList;
    }

    private List<ExpandEvent> append(StatExtEntity statEntity, GroupExtEntity groupEntity, LightMessage message) throws Exception {
        TemplateEntity templateEntity = statEntity.getTemplateEntity();
        String dimensValue = null;
        long batchTime = DateUtil.batchTime((int)statEntity.getTimeParamInterval(), (TimeUnit)statEntity.getTimeUnit(), (long)message.getTime());
        HashMap<String, Object> envMap = new HashMap<String, Object>(message.getParamMap());
        if (!StringUtil.isEmpty((String)templateEntity.getDimens())) {
            dimensValue = DimensDBWrapper.getDimensValue(envMap, templateEntity.getDimensArray(), batchTime);
            int threshold = groupEntity.getExtendConfig().getLimitingConfig().getOrDefault(LimitingStrategyEnum.STAT_RESULT_SIZE_LIMITING, -1);
            if (!LimitingContext.getInstance().tryAcquire(statEntity, threshold, 1)) {
                logger.error("limiting trigger strategy:STAT_RESULT_SIZE_LIMIT,token:{},stat:{},threshold:{}", new Object[]{groupEntity.getToken(), statEntity.getId(), (long)threshold * 60L});
                return null;
            }
        }
        ArrayList<ExpandEvent> eventList = new ArrayList<ExpandEvent>();
        List statStateList = templateEntity.getStatStateList();
        for (StatState statState : statStateList) {
            try {
                ImmutableMap paramMap;
                List<ExpandEvent> builtInEvents;
                boolean isDistinct = StatState.isBitCountState((StatState)statState);
                String distinctValue = null;
                if (isDistinct) {
                    distinctValue = String.valueOf(FormulaCalculate.parseVariableEntity(StatState.getFirstUnit((StatState)statState), envMap, batchTime));
                    if (logger.isTraceEnabled()) {
                        logger.trace("expand message,stat:{},envMap:{},batchTime:{},distinctValue:{}", new Object[]{statEntity.getId(), JsonUtil.toJSONString(envMap), DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss"), distinctValue});
                    }
                    distinctValue = RedisRoaringFilter.getInstance().concatDistinctValue(distinctValue, dimensValue, batchTime);
                    long hash = Hashing.murmur3_128().hashBytes(distinctValue.getBytes(StandardCharsets.UTF_8)).asLong();
                    distinctValue = Long.toString(Math.abs(hash), 36);
                    envMap.put("_d", distinctValue);
                }
                String aggregateKey = keyGenerator.resultKey((Stat)statEntity, statState.getFunctionIndex(), dimensValue, batchTime);
                if (!groupEntity.isBuiltIn() && CollectionUtils.isNotEmpty(builtInEvents = this.appendBuiltInMonitor("_builtin_result_stat", (Map<String, String>)(paramMap = ImmutableMap.of((Object)"statId", (Object)String.valueOf(statEntity.getId()), (Object)"resultKey", (Object)aggregateKey)), message.getRepeat()))) {
                    eventList.addAll(builtInEvents);
                }
                String data = envMap.entrySet().stream().filter(x -> statState.getRelatedColumnSet().contains(x.getKey()) || ((String)x.getKey()).equals("_d")).map(x -> (String)x.getKey() + "\u0006" + x.getValue()).collect(Collectors.joining("\u0005"));
                String result = StringBuilderHolder.Smaller.getStringBuilder().append(aggregateKey).append("\u0004").append(statEntity.getId()).append("\u0004").append(data).append("\u0004").append(dimensValue).append("\u0004").append(statState.getFunctionIndex()).append("\u0004").append(batchTime).toString();
                if (logger.isTraceEnabled()) {
                    logger.trace("deliver stat message,statId:{},distinct:{},evnMap:{},dimens:{},repeat:{},result:{},batch:{}", new Object[]{statEntity.getId(), distinctValue, JsonUtil.toJSONString(envMap), dimensValue, message.getRepeat(), result, DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss")});
                }
                ExpandEvent expandEvent = new ExpandEvent(this.getSlot(aggregateKey), result, message.getRepeat());
                eventList.add(expandEvent);
            }
            catch (Exception ex) {
                logger.error("deliver message error,group:{}", (Object)groupEntity.getId(), (Object)ex);
            }
        }
        return eventList;
    }

    private List<ExpandEvent> appendBuiltInMonitor(String builtInToken, Map<String, String> paramMap, int repeat) throws Exception {
        GroupExtEntity monitorGroup = BuiltinLoader.getBuiltinGroup(builtInToken);
        if (monitorGroup == null) {
            return null;
        }
        LightMessage monitorMessage = new LightMessage();
        monitorMessage.setParamMap(paramMap);
        monitorMessage.setGroupId(monitorGroup.getId().intValue());
        monitorMessage.setRepeat(repeat);
        monitorMessage.setTime(System.currentTimeMillis());
        List<StatExtEntity> monitorStats = StatDBWrapper.queryRunningListByGroupId(monitorGroup.getId());
        ArrayList<ExpandEvent> result = new ArrayList<ExpandEvent>();
        for (StatExtEntity monitorStat : monitorStats) {
            List<ExpandEvent> subList = this.append(monitorStat, monitorGroup, monitorMessage);
            if (!CollectionUtils.isNotEmpty(subList)) continue;
            result.addAll(subList);
        }
        return result;
    }

    private int getSlot(String aggregateKey) {
        return HashUtil.getHashIndex((String)aggregateKey, (int)10);
    }
}

