/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.preparing.handler.valid;

import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.enums.ColumnTypeEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.util.StringUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageValid {
    private static final Logger logger = LoggerFactory.getLogger(MessageValid.class);

    public static boolean valid(int groupId, LightMessage message, List<Column> columnList) throws Exception {
        if (CollectionUtils.isEmpty(columnList)) {
            return true;
        }
        for (Column metaColumn : columnList) {
            if (MessageValid.valid(groupId, message, metaColumn)) continue;
            return false;
        }
        return true;
    }

    public static boolean valid(int groupId, LightMessage message, Column column) {
        boolean is;
        String columnName = column.getName();
        String value = (String)message.getParamMap().get(columnName);
        if (StringUtil.isEmptyOrNullStr((String)value)) {
            return true;
        }
        ColumnTypeEnum columnTypeEnum = column.getType();
        boolean bl = is = columnTypeEnum != ColumnTypeEnum.NUMBER || StringUtil.isNumber((String)value);
        if (!is) {
            logger.error("valid group {} message failed,column:{},column type:{}", new Object[]{groupId, columnName, columnTypeEnum.getType()});
        }
        return is;
    }
}

