/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.reactor;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class AsyncReactorExecutor {
    private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(8, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    private static final Scheduler SCHEDULER = Schedulers.fromExecutor((Executor)EXECUTOR);
    private static final long DEFAULT_TIMEOUT = 60000L;

    private AsyncReactorExecutor() {
    }

    public static <T> Mono<T> executeAsync(Callable<T> task) {
        return AsyncReactorExecutor.executeAsync(task, 60000L);
    }

    public static <T> Mono<T> executeAsync(Callable<T> task, long timeoutMillis) {
        return Mono.fromCallable(task).subscribeOn(SCHEDULER).timeout(Duration.ofMillis(timeoutMillis));
    }

    public static <T> T executeBlocking(Callable<T> task, long timeoutMillis) throws Exception {
        return (T)AsyncReactorExecutor.executeAsync(task, timeoutMillis).block(Duration.ofMillis(timeoutMillis));
    }

    public static void shutdown() {
        EXECUTOR.shutdown();
    }
}

