/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.roaring;

import com.dtstep.lighthouse.common.lru.Cache;
import com.dtstep.lighthouse.common.lru.LRU;
import com.dtstep.lighthouse.core.roaring.service.RoaringBitMapExtend;
import com.google.common.util.concurrent.Striped;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitSetFilterSupplier {
    private static final Logger logger = LoggerFactory.getLogger(BitSetFilterSupplier.class);
    private static final Cache<String, RoaringBitMapExtend> bitCache = LRU.newBuilder().maximumSize(200000L).expireAfterWrite(10L, TimeUnit.MINUTES).softValues().build();
    private static final BitSetFilterSupplier instance = new BitSetFilterSupplier();
    private static final Striped<Lock> stripedLock = Striped.lazyWeakLock((int)300);

    private BitSetFilterSupplier() {
    }

    public static BitSetFilterSupplier getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String bitKey, long bitIndex) {
        Lock lock = (Lock)stripedLock.get((Object)bitKey);
        lock.lock();
        try {
            RoaringBitMapExtend roaringBitMap = (RoaringBitMapExtend)bitCache.get((Object)bitKey, k -> new RoaringBitMapExtend());
            if (roaringBitMap == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = roaringBitMap.checkAndPut(bitIndex);
            return bl;
        }
        catch (Exception ex) {
            logger.error("lighthouse stat,set bit process error,bitIndex:{}", (Object)bitIndex, (Object)ex);
        }
        finally {
            lock.unlock();
        }
        return false;
    }
}

