/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.roaring.service;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Objects;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.CharIterator;
import org.roaringbitmap.Container;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.Util;
import org.roaringbitmap.art.ContainerIterator;
import org.roaringbitmap.art.KeyIterator;
import org.roaringbitmap.art.LeafNode;
import org.roaringbitmap.art.LeafNodeIterator;
import org.roaringbitmap.longlong.ContainerWithIndex;
import org.roaringbitmap.longlong.HighLowContainer;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.LongConsumer;
import org.roaringbitmap.longlong.LongIterator;
import org.roaringbitmap.longlong.LongUtils;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class RoaringBitMapEmbed
implements Externalizable,
LongBitmapDataProvider {
    private static final long serialVersionUID = -8201254780288457436L;
    private HighLowContainer highLowContainer = new HighLowContainer();

    public void addInt(int x) {
        this.addLong(x);
    }

    public void addLong(long x) {
        byte[] high = LongUtils.highPart((long)x);
        char low = LongUtils.lowPart((long)x);
        ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
        if (containerWithIndex != null) {
            Container container = containerWithIndex.getContainer();
            Container freshOne = container.add(low);
            this.highLowContainer.replaceContainer(containerWithIndex.getContainerIdx(), freshOne);
        } else {
            ArrayContainer arrayContainer = new ArrayContainer();
            arrayContainer.add(low);
            this.highLowContainer.put(high, (Container)arrayContainer);
        }
    }

    public long getLongCardinality() {
        if (this.highLowContainer.isEmpty()) {
            return 0L;
        }
        ContainerIterator containerIterator = this.highLowContainer.containerIterator();
        long cardinality = 0L;
        while (containerIterator.hasNext()) {
            Container container = (Container)containerIterator.next();
            cardinality += (long)container.getCardinality();
        }
        return cardinality;
    }

    public int getIntCardinality() throws UnsupportedOperationException {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Can not call .getIntCardinality as the cardinality is bigger than Integer.MAX_VALUE");
        }
        return (int)cardinality;
    }

    public long select(long j) throws IllegalArgumentException {
        long left = j;
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIterator(false);
        while (leafNodeIterator.hasNext()) {
            LeafNode leafNode = leafNodeIterator.next();
            long containerIdx = leafNode.getContainerIdx();
            Container container = this.highLowContainer.getContainer(containerIdx);
            int card = container.getCardinality();
            if (left < (long)card) {
                byte[] high = leafNode.getKeyBytes();
                int leftAsUnsignedInt = (int)left;
                char low = container.select(leftAsUnsignedInt);
                return LongUtils.toLong((byte[])high, (char)low);
            }
            left -= (long)card;
        }
        return this.throwSelectInvalidIndex(j);
    }

    private long throwSelectInvalidIndex(long j) {
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getLongCardinality());
    }

    public Iterator<Long> iterator() {
        final LongIterator it = this.getLongIterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Long next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void forEach(LongConsumer lc) {
        KeyIterator keyIterator = this.highLowContainer.highKeyIterator();
        while (keyIterator.hasNext()) {
            byte[] high = keyIterator.next();
            long containerIdx = keyIterator.currentContainerIdx();
            Container container = this.highLowContainer.getContainer(containerIdx);
            PeekableCharIterator charIterator = container.getCharIterator();
            while (charIterator.hasNext()) {
                char low = charIterator.next();
                long v = LongUtils.toLong((byte[])high, (char)low);
                lc.accept(v);
            }
        }
    }

    public long rankLong(long id) {
        long result = 0L;
        byte[] high = LongUtils.highPart((long)id);
        char low = LongUtils.lowPart((long)id);
        ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
        KeyIterator keyIterator = this.highLowContainer.highKeyIterator();
        if (containerWithIndex == null) {
            byte[] key;
            int res;
            while (keyIterator.hasNext() && (res = LongUtils.compareHigh((byte[])(key = keyIterator.next()), (byte[])high)) <= 0) {
                long containerIdx = keyIterator.currentContainerIdx();
                Container container = this.highLowContainer.getContainer(containerIdx);
                result += (long)container.getCardinality();
            }
        } else {
            while (keyIterator.hasNext()) {
                byte[] key = keyIterator.next();
                long containerIdx = keyIterator.currentContainerIdx();
                Container container = this.highLowContainer.getContainer(containerIdx);
                if (LongUtils.compareHigh((byte[])key, (byte[])high) == 0) {
                    result += (long)container.rank(low);
                    break;
                }
                result += (long)container.getCardinality();
            }
        }
        return result;
    }

    public void or(RoaringBitMapEmbed x2) {
        KeyIterator highIte2 = x2.highLowContainer.highKeyIterator();
        while (highIte2.hasNext()) {
            Container container2clone;
            byte[] high = highIte2.next();
            long containerIdx = highIte2.currentContainerIdx();
            Container container2 = x2.highLowContainer.getContainer(containerIdx);
            ContainerWithIndex containerWithIdx = this.highLowContainer.searchContainer(high);
            if (containerWithIdx == null) {
                container2clone = container2.clone();
                this.highLowContainer.put(high, container2clone);
                continue;
            }
            container2clone = containerWithIdx.getContainer().ior(container2);
            this.highLowContainer.replaceContainer(containerWithIdx.getContainerIdx(), container2clone);
        }
    }

    public void xor(RoaringBitMapEmbed x2) {
        KeyIterator keyIterator = x2.highLowContainer.highKeyIterator();
        while (keyIterator.hasNext()) {
            Container containerClone2;
            byte[] high = keyIterator.next();
            long containerIdx = keyIterator.currentContainerIdx();
            Container container = x2.highLowContainer.getContainer(containerIdx);
            ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
            if (containerWithIndex == null) {
                containerClone2 = container.clone();
                this.highLowContainer.put(high, containerClone2);
                continue;
            }
            containerClone2 = containerWithIndex.getContainer().ixor(container);
            this.highLowContainer.replaceContainer(containerWithIndex.getContainerIdx(), containerClone2);
        }
    }

    public void and(RoaringBitMapEmbed x2) {
        KeyIterator thisIterator = this.highLowContainer.highKeyIterator();
        while (thisIterator.hasNext()) {
            byte[] highKey = thisIterator.next();
            long containerIdx = thisIterator.currentContainerIdx();
            ContainerWithIndex containerWithIdx = x2.highLowContainer.searchContainer(highKey);
            if (containerWithIdx == null) {
                thisIterator.remove();
                continue;
            }
            Container container1 = this.highLowContainer.getContainer(containerIdx);
            Container freshContainer = container1.iand(containerWithIdx.getContainer());
            this.highLowContainer.replaceContainer(containerIdx, freshContainer);
        }
    }

    public void andNot(RoaringBitMapEmbed x2) {
        KeyIterator thisKeyIterator = this.highLowContainer.highKeyIterator();
        while (thisKeyIterator.hasNext()) {
            byte[] high = thisKeyIterator.next();
            long containerIdx = thisKeyIterator.currentContainerIdx();
            ContainerWithIndex containerWithIdx2 = x2.highLowContainer.searchContainer(high);
            if (containerWithIdx2 == null) continue;
            Container thisContainer = this.highLowContainer.getContainer(containerIdx);
            Container freshContainer = thisContainer.iandNot(containerWithIdx2.getContainer());
            this.highLowContainer.replaceContainer(containerIdx, freshContainer);
            if (!freshContainer.isEmpty()) {
                this.highLowContainer.replaceContainer(containerIdx, freshContainer);
                continue;
            }
            thisKeyIterator.remove();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        LongIterator i = this.getLongIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            if (answer.length() > 524288) {
                answer.append("...");
                break;
            }
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public LongIterator getLongIterator() {
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIterator(false);
        return this.toIterator(leafNodeIterator, false);
    }

    protected LongIterator toIterator(final LeafNodeIterator keyIte, final boolean reverse) {
        return new LongIterator(){
            private byte[] high;
            private CharIterator charIterator;
            private boolean hasNextCalled = false;

            public boolean hasNext() {
                this.hasNextCalled = true;
                if (this.charIterator != null && !this.charIterator.hasNext()) {
                    do {
                        if (!keyIte.hasNext()) {
                            return false;
                        }
                        LeafNode leafNode = keyIte.next();
                        this.high = leafNode.getKeyBytes();
                        long containerIdx = leafNode.getContainerIdx();
                        Container container = RoaringBitMapEmbed.this.highLowContainer.getContainer(containerIdx);
                        this.charIterator = !reverse ? container.getCharIterator() : container.getReverseCharIterator();
                    } while (!this.charIterator.hasNext());
                    return true;
                }
                if (this.charIterator != null && this.charIterator.hasNext()) {
                    return true;
                }
                if (this.charIterator == null) {
                    do {
                        if (!keyIte.hasNext()) {
                            return false;
                        }
                        LeafNode leafNode = keyIte.next();
                        this.high = leafNode.getKeyBytes();
                        long containerIdx = leafNode.getContainerIdx();
                        Container container = RoaringBitMapEmbed.this.highLowContainer.getContainer(containerIdx);
                        this.charIterator = !reverse ? container.getCharIterator() : container.getReverseCharIterator();
                    } while (!this.charIterator.hasNext());
                    return true;
                }
                return false;
            }

            public long next() {
                boolean hasNext = true;
                if (!this.hasNextCalled) {
                    hasNext = this.hasNext();
                    this.hasNextCalled = false;
                }
                if (hasNext) {
                    char low = this.charIterator.next();
                    return LongUtils.toLong((byte[])this.high, (char)low);
                }
                throw new IllegalStateException("empty");
            }

            public LongIterator clone() {
                throw new UnsupportedOperationException("TODO");
            }
        };
    }

    public boolean contains(long x) {
        byte[] high = LongUtils.highPart((long)x);
        ContainerWithIndex containerWithIdx = this.highLowContainer.searchContainer(high);
        if (containerWithIdx == null) {
            return false;
        }
        char low = LongUtils.lowPart((long)x);
        return containerWithIdx.getContainer().contains(low);
    }

    public int getSizeInBytes() {
        throw new UnsupportedOperationException();
    }

    public long getLongSizeInBytes() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.getLongCardinality() == 0L;
    }

    public ImmutableLongBitmapDataProvider limit(long x) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean runOptimize() {
        boolean hasChanged = false;
        ContainerIterator containerIterator = this.highLowContainer.containerIterator();
        while (containerIterator.hasNext()) {
            Container container = containerIterator.next();
            Container freshContainer = container.runOptimize();
            if (!(freshContainer instanceof RunContainer)) continue;
            hasChanged = true;
            containerIterator.replace(freshContainer);
        }
        return hasChanged;
    }

    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    public void serialize(ByteBuffer byteBuffer) throws IOException {
        this.highLowContainer.serialize(byteBuffer);
    }

    public void deserialize(DataInput in) throws IOException {
        this.clear();
        this.highLowContainer.deserialize(in);
    }

    public void deserialize(ByteBuffer in) throws IOException {
        this.clear();
        this.highLowContainer.deserialize(in);
    }

    public long serializedSizeInBytes() {
        long nbBytes = this.highLowContainer.serializedSizeInBytes();
        return nbBytes;
    }

    public void clear() {
        if (this.highLowContainer != null) {
            ContainerIterator it = this.highLowContainer.containerIterator();
            while (it.hasNext()) {
                Container container = it.next();
                container.clear();
            }
            this.highLowContainer.clear();
            this.highLowContainer = null;
        }
    }

    public long[] toArray() {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new IllegalStateException("The cardinality does not fit in an array");
        }
        long[] array = new long[(int)cardinality];
        int pos = 0;
        LongIterator it = this.getLongIterator();
        while (it.hasNext()) {
            array[pos++] = it.next();
        }
        return array;
    }

    public static Roaring64Bitmap bitmapOf(long ... dat) {
        Roaring64Bitmap ans = new Roaring64Bitmap();
        ans.add(dat);
        return ans;
    }

    public void add(long ... dat) {
        long[] var2 = dat;
        int var3 = dat.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            long oneLong = var2[var4];
            this.addLong(oneLong);
        }
    }

    public void add(long rangeStart, long rangeEnd) {
        byte[] startHigh = LongUtils.highPart((long)rangeStart);
        char startLow = LongUtils.lowPart((long)rangeStart);
        byte[] endHigh = LongUtils.highPart((long)(rangeEnd - 1L));
        int endLow = LongUtils.lowPart((long)(rangeEnd - 1L));
        long rangeStartVal = rangeStart;
        byte[] startHighKey = startHigh;
        while (LongUtils.compareHigh((byte[])startHighKey, (byte[])endHigh) <= 0) {
            char containerStart = LongUtils.compareHigh((byte[])startHighKey, (byte[])startHigh) == 0 ? startLow : (char)'\u0000';
            int containerLast = LongUtils.compareHigh((byte[])startHighKey, (byte[])endHigh) == 0 ? endLow : Util.maxLowBitAsInteger();
            ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(startHighKey);
            if (containerWithIndex != null) {
                long containerIdx = containerWithIndex.getContainerIdx();
                Container freshContainer = this.highLowContainer.getContainer(containerIdx).iadd((int)containerStart, containerLast + 1);
                this.highLowContainer.replaceContainer(containerIdx, freshContainer);
            } else {
                Container freshContainer = Container.rangeOfOnes((int)containerStart, (int)(containerLast + 1));
                this.highLowContainer.put(startHighKey, freshContainer);
            }
            rangeStartVal = rangeStartVal + (long)(containerLast - containerStart) + 1L;
            startHighKey = LongUtils.highPart((long)rangeStartVal);
        }
    }

    public LongIterator getReverseLongIterator() {
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIterator(true);
        return this.toIterator(leafNodeIterator, true);
    }

    public void removeLong(long x) {
        byte[] high = LongUtils.highPart((long)x);
        ContainerWithIndex containerWithIdx = this.highLowContainer.searchContainer(high);
        if (containerWithIdx != null) {
            char low = LongUtils.lowPart((long)x);
            Container container = containerWithIdx.getContainer();
            Container freshContainer = container.remove(low);
            this.highLowContainer.replaceContainer(containerWithIdx.getContainerIdx(), freshContainer);
        }
    }

    public void trim() {
        if (!this.highLowContainer.isEmpty()) {
            KeyIterator keyIterator = this.highLowContainer.highKeyIterator();
            while (keyIterator.hasNext()) {
                long containerIdx = keyIterator.currentContainerIdx();
                Container container = this.highLowContainer.getContainer(containerIdx);
                if (container.isEmpty()) {
                    keyIterator.remove();
                    continue;
                }
                container.trim();
            }
        }
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoaringBitMapEmbed other = (RoaringBitMapEmbed)obj;
        return Objects.equals(this.highLowContainer, other.highLowContainer);
    }

    public void flip(long x) {
        byte[] high = LongUtils.highPart((long)x);
        ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
        if (containerWithIndex == null) {
            this.addLong(x);
        } else {
            char low = LongUtils.lowPart((long)x);
            Container freshOne = containerWithIndex.getContainer().flip(low);
            this.highLowContainer.replaceContainer(containerWithIndex.getContainerIdx(), freshOne);
        }
    }

    public RoaringBitMapEmbed clone() {
        long sizeInBytesL = this.serializedSizeInBytes();
        if (sizeInBytesL >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        int sizeInBytesInt = (int)sizeInBytesL;
        ByteBuffer byteBuffer = ByteBuffer.allocate(sizeInBytesInt).order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.serialize(byteBuffer);
            byteBuffer.flip();
            RoaringBitMapEmbed freshOne = new RoaringBitMapEmbed();
            freshOne.deserialize(byteBuffer);
            return freshOne;
        }
        catch (Exception var6) {
            throw new RuntimeException("fail to clone thorough the ser/deser", var6);
        }
    }
}

