/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.sort;

import com.dtstep.lighthouse.common.util.ReflectUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class SortOperator {
    public static void sortList(List list) throws Exception {
        list.sort(Comparator.naturalOrder());
    }

    public static <T> List<T> sortList(List<T> list, String field, boolean isAsc) throws Exception {
        Ordering ordering = Ordering.from(SortOperator.getComparator(isAsc, field));
        return ordering.sortedCopy(list);
    }

    private static Comparator<Object> getComparator(boolean isAsc, String fieldName) {
        return (o1, o2) -> {
            Object value2;
            Object value1;
            if (StringUtil.isEmpty((String)fieldName)) {
                value1 = o1;
                value2 = o2;
            } else {
                value1 = ReflectUtil.getFieldValue((Object)o1, (String)fieldName);
                value2 = ReflectUtil.getFieldValue((Object)o2, (String)fieldName);
            }
            return SortOperator.compareTo(isAsc, value1, value2);
        };
    }

    private static int compareTo(boolean isAsc, Object object1, Object object2) {
        int result = 0;
        try {
            result = SortOperator.compareTo(object1, object2);
            if (!isAsc) {
                result = -result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static int compareTo(Object object1, Object object2) {
        boolean isEmptyV2;
        boolean isEmptyV1 = object1 == null;
        boolean bl = isEmptyV2 = object2 == null;
        if (!isEmptyV1 && !isEmptyV2) {
            String value1 = object1.toString();
            String value2 = object2.toString();
            if (object1 instanceof Date) {
                return ((Date)object1).compareTo((Date)object2);
            }
            if (object1 instanceof Number || StringUtil.isNumber((String)value1) && StringUtil.isNumber((String)value2)) {
                try {
                    return new BigDecimal(value1).compareTo(new BigDecimal(value2));
                }
                catch (Exception e) {
                    return value1.compareTo(value2);
                }
            }
            return value1.compareTo(value2);
        }
        if (!isEmptyV1 && isEmptyV2) {
            return 1;
        }
        if (isEmptyV1 && !isEmptyV2) {
            return -1;
        }
        return 0;
    }
}

