/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.cmdb;

import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.mysql.MySQLCMDBStorageEngine;
import java.sql.Connection;
import org.jsoup.helper.Validate;

public class CMDBStorageEngineProxy {
    private static CMDBStorageEngine<Connection> storageEngine;

    private static void loadStorageEngine() {
        String engine = LDPConfig.getVal("cmdb.storage.engine");
        Validate.isTrue((boolean)StringUtil.isNotEmpty((String)engine));
        if (!"mysql".equals(engine)) {
            throw new RuntimeException("cmdb engine[" + engine + "] not support!");
        }
        storageEngine = new MySQLCMDBStorageEngine();
    }

    public static CMDBStorageEngine<Connection> getInstance() {
        return storageEngine;
    }

    static {
        CMDBStorageEngineProxy.loadStorageEngine();
    }
}

