/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.warehouse;

import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngine;
import com.dtstep.lighthouse.core.storage.warehouse.hbase.HBaseWarehouseStorageEngine;
import com.dtstep.lighthouse.core.storage.warehouse.mysql.MySQLWarehouseStorageEngine;
import org.jsoup.helper.Validate;

public class WarehouseStorageEngineProxy {
    private static WarehouseStorageEngine storageEngine;

    private static void loadStorageEngine() {
        String engine = LDPConfig.getVal("warehouse.storage.engine");
        Validate.isTrue((boolean)StringUtil.isNotEmpty((String)engine));
        if ("hbase".equals(engine)) {
            if (storageEngine == null) {
                storageEngine = new HBaseWarehouseStorageEngine();
            }
        } else if ("mysql".equals(engine)) {
            if (storageEngine == null) {
                storageEngine = new MySQLWarehouseStorageEngine();
            }
        } else {
            throw new RuntimeException("warehouse engine[" + engine + "] not support!");
        }
    }

    public static WarehouseStorageEngine getInstance() {
        return storageEngine;
    }

    static {
        WarehouseStorageEngineProxy.loadStorageEngine();
    }
}

