/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.warehouse.hbase;

import com.dtstep.lighthouse.common.constant.SysConst;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.util.ListUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.lock.RedissonLock;
import com.dtstep.lighthouse.core.storage.common.CompareOperator;
import com.dtstep.lighthouse.core.storage.common.LdpGet;
import com.dtstep.lighthouse.core.storage.common.LdpIncrement;
import com.dtstep.lighthouse.core.storage.common.LdpPut;
import com.dtstep.lighthouse.core.storage.common.LdpResult;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseWarehouseStorageEngine
implements WarehouseStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(HBaseWarehouseStorageEngine.class);
    private static Compression.Algorithm algorithm = null;
    private static final int PrePartitionsPerRegionServer = 4;
    private static volatile Connection connection = null;
    private static final int batchSalt = 4;
    private static final String COMPARE_PUT_LOCK_PREFIX = "COMPARE_PUT_LOCK";
    private static final ExecutorService pool;
    private static final int BATCH_GET_SIZE = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getConnection() throws Exception {
        if (connection != null && !connection.isClosed() && !connection.isAborted()) return connection;
        Class<HBaseWarehouseStorageEngine> clazz = HBaseWarehouseStorageEngine.class;
        synchronized (HBaseWarehouseStorageEngine.class) {
            if (connection != null && !connection.isClosed() && !connection.isAborted()) return connection;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            String zooQuorum = LDPConfig.getVal("warehouse.storage.engine.hbase.zookeeper.quorum");
            String port = LDPConfig.getVal("warehouse.storage.engine.hbase.zookeeper.quorum.port");
            Configuration hBaseConfiguration = HBaseConfiguration.create();
            hBaseConfiguration.set("hbase.zookeeper.quorum", zooQuorum);
            hBaseConfiguration.set("hbase.zookeeper.property.clientPort", port);
            hBaseConfiguration.setInt("hbase.client.ipc.pool.size", 10);
            hBaseConfiguration.setInt("hbase.rpc.timeout", 180000);
            hBaseConfiguration.setInt("hbase.client.operation.timeout", 240000);
            hBaseConfiguration.setInt("hbase.client.scanner.timeout.period", 180000);
            connection = ConnectionFactory.createConnection((Configuration)hBaseConfiguration);
            logger.info("create hbase connection,thread:{},cost:{}", (Object)Thread.currentThread().getName(), (Object)stopWatch.getTime());
            // ** MonitorExit[var0] (shouldn't be in output)
            return connection;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNameSpaceExist(String namespace) throws Exception {
        try (Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();){
            String[] namespaceArr;
            for (String dbNamespace : namespaceArr = hBaseAdmin.listNamespaces()) {
                if (!dbNamespace.equals(namespace)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            logger.error("check namespace exist error,namespace:{}", (Object)namespace, (Object)ex);
            throw ex;
        }
    }

    @Override
    public String getDefaultNamespace() {
        String clusterName = LDPConfig.getVal("lighthouse.cluster.id");
        Validate.notNull((Object)clusterName);
        return String.format("cluster_%s_ldp_warehouse", clusterName);
    }

    @Override
    public void createNamespaceIfNotExist(String namespace) throws Exception {
        try (Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();){
            if (this.isNameSpaceExist(namespace)) {
                return;
            }
            NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)namespace).build();
            hBaseAdmin.createNamespace(namespaceDescriptor);
            logger.info("create namespace {} success!", (Object)namespace);
        }
        catch (Exception ex) {
            logger.error("createNamespaceIfNotExist error,namespace:{}", (Object)namespace, (Object)ex);
            throw ex;
        }
    }

    private TableName getTableName(String tableName) {
        if (tableName.contains(":")) {
            return TableName.valueOf((String)tableName);
        }
        return TableName.valueOf((String)String.format("%s:%s", this.getDefaultNamespace(), tableName));
    }

    private int getDefaultPrePartitionSize() throws Exception {
        int n;
        block8: {
            Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();
            try {
                Collection collection = hBaseAdmin.getRegionServers();
                int prePartitionSize = Math.min(collection.size() * 4, SysConst._DBKeyPrefixArray.length);
                logger.info("getDefaultPrePartitionSize,region server size:{},pre-partition size:{}!", (Object)collection.size(), (Object)prePartitionSize);
                n = prePartitionSize;
                if (hBaseAdmin == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseAdmin != null) {
                        try {
                            hBaseAdmin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("getDefaultPrePartitionSize error!", (Throwable)ex);
                    throw ex;
                }
            }
            hBaseAdmin.close();
        }
        return n;
    }

    @Override
    public void createResultTable(String tableName) throws Exception {
        boolean isResult;
        int prePartitionsSize = this.getDefaultPrePartitionSize();
        String[] keys = SysConst._DBKeyPrefixArray;
        List<String> keysList = Arrays.asList(keys);
        List totalGroupKeyList = ListUtil.listPartition(keysList, (int)prePartitionsSize);
        TreeSet<byte[]> rows = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < prePartitionsSize; ++i) {
            List groupKeyList = (List)totalGroupKeyList.get(i);
            if (!CollectionUtils.isNotEmpty((Collection)groupKeyList)) continue;
            String key = (String)((List)totalGroupKeyList.get(i)).get(0);
            rows.add(Bytes.toBytes((String)key));
        }
        byte[][] splitKeys = new byte[rows.size()][];
        Iterator rowKeyIterator = rows.iterator();
        int i = 0;
        while (rowKeyIterator.hasNext()) {
            byte[] tempRow = (byte[])rowKeyIterator.next();
            rowKeyIterator.remove();
            splitKeys[i] = tempRow;
            ++i;
        }
        TableDescriptorBuilder tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.getTableName(tableName));
        ColumnFamilyDescriptor family = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f")).setMaxVersions(1).setInMemory(false).setBloomFilterType(BloomType.ROW).setCompressTags(true).setTimeToLive((int)TimeUnit.DAYS.toSeconds(1095L)).setCompactionCompressionType(algorithm).setCompressionType(algorithm).setBlocksize(16384).setDataBlockEncoding(DataBlockEncoding.FAST_DIFF).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build();
        tableDescriptor.setColumnFamily(family);
        try (Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();){
            hBaseAdmin.createTable(tableDescriptor.build(), (byte[][])splitKeys);
        }
        catch (Exception ex) {
            logger.error("create hbase table,system error.metaName:{}", (Object)tableName, (Object)ex);
            throw ex;
        }
        try {
            isResult = this.isTableExist(tableName);
        }
        catch (Exception ex) {
            logger.error(String.format("create hbase table,check status error.metaName:%s", tableName), (Throwable)ex);
            throw ex;
        }
        if (!isResult) {
            logger.info("create hbase table error,table not created.metaName:{}", (Object)tableName);
            throw new Exception("create hbase table error!");
        }
    }

    @Override
    public void createDimensTable(String tableName) throws Exception {
        boolean isResult;
        int prePartitionsSize = this.getDefaultPrePartitionSize();
        String[] keys = SysConst._DBKeyPrefixArray;
        List<String> keysList = Arrays.asList(keys);
        List totalGroupKeyList = ListUtil.listPartition(keysList, (int)prePartitionsSize);
        TreeSet<byte[]> rows = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < prePartitionsSize; ++i) {
            List groupKeyList = (List)totalGroupKeyList.get(i);
            if (!CollectionUtils.isNotEmpty((Collection)groupKeyList)) continue;
            String key = (String)((List)totalGroupKeyList.get(i)).get(0);
            rows.add(Bytes.toBytes((String)key));
        }
        byte[][] splitKeys = new byte[rows.size()][];
        Iterator rowKeyIterator = rows.iterator();
        int i = 0;
        while (rowKeyIterator.hasNext()) {
            byte[] tempRow = (byte[])rowKeyIterator.next();
            rowKeyIterator.remove();
            splitKeys[i] = tempRow;
            ++i;
        }
        TableDescriptorBuilder tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.getTableName(tableName));
        ColumnFamilyDescriptor family = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f")).setMaxVersions(1).setInMemory(false).setBloomFilterType(BloomType.ROW).setCompressTags(true).setTimeToLive((int)TimeUnit.DAYS.toSeconds(1095L)).setCompactionCompressionType(algorithm).setCompressionType(algorithm).setBlocksize(16384).setDataBlockEncoding(DataBlockEncoding.FAST_DIFF).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build();
        tableDescriptor.setColumnFamily(family);
        try (Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();){
            hBaseAdmin.createTable(tableDescriptor.build(), (byte[][])splitKeys);
        }
        catch (Exception ex) {
            logger.error("create hbase table,system error.metaName:{}", (Object)tableName, (Object)ex);
            throw ex;
        }
        try {
            isResult = this.isTableExist(tableName);
        }
        catch (Exception ex) {
            logger.error(String.format("create hbase table,check status error.metaName:%s", tableName), (Throwable)ex);
            throw ex;
        }
        if (!isResult) {
            logger.info("create hbase table error,table not created.metaName:{}", (Object)tableName);
            throw new Exception("create hbase table error!");
        }
    }

    @Override
    public boolean isTableExist(String tableName) throws Exception {
        boolean bl;
        block8: {
            Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();
            try {
                TableName tableNameObj = this.getTableName(tableName);
                bl = hBaseAdmin.tableExists(tableNameObj);
                if (hBaseAdmin == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseAdmin != null) {
                        try {
                            hBaseAdmin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("check table exist error,tableName:{}", (Object)tableName, (Object)ex);
                    throw ex;
                }
            }
            hBaseAdmin.close();
        }
        return bl;
    }

    @Override
    public void dropTable(String tableName) throws Exception {
        if (!this.isTableExist(tableName)) {
            return;
        }
        try (Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();){
            TableName table = this.getTableName(tableName);
            hBaseAdmin.disableTable(table);
            hBaseAdmin.deleteTable(table);
        }
        catch (Exception ex) {
            logger.error("drop table error,tableName:{}", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    public List<RegionInfo> getRegionInfo(String tableName) throws Exception {
        List list;
        block8: {
            Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();
            try {
                list = hBaseAdmin.getRegions(this.getTableName(tableName));
                if (hBaseAdmin == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseAdmin != null) {
                        try {
                            hBaseAdmin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("getRegionInfo error,tableName:{}", (Object)tableName, (Object)ex);
                    throw ex;
                }
            }
            hBaseAdmin.close();
        }
        return list;
    }

    public TableName[] listTables() throws Exception {
        TableName[] tableNameArray;
        block8: {
            Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();
            try {
                tableNameArray = hBaseAdmin.listTableNames();
                if (hBaseAdmin == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseAdmin != null) {
                        try {
                            hBaseAdmin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("listTables error!", (Throwable)ex);
                    throw ex;
                }
            }
            hBaseAdmin.close();
        }
        return tableNameArray;
    }

    public void merge(String tableName, int targetRegions) throws Exception {
        List<RegionInfo> list = this.getRegionInfo(tableName);
        if (CollectionUtils.isEmpty(list) || list.size() <= targetRegions) {
            logger.info("Merge table:{} regions exit,Current region size is less than target!", (Object)tableName);
            return;
        }
        logger.info("Waiting for merge table regions,table:{}", (Object)tableName);
        List totalGroupLists = ListUtil.listPartition(list, (int)targetRegions);
        try (Admin hBaseAdmin = HBaseWarehouseStorageEngine.getConnection().getAdmin();){
            for (int i = 0; i < totalGroupLists.size(); ++i) {
                List groupLists = (List)totalGroupLists.get(i);
                if (CollectionUtils.isEmpty((Collection)groupLists) || groupLists.size() <= 1) continue;
                byte[][] bytesArray = new byte[groupLists.size()][];
                for (int n = 0; n < groupLists.size(); ++n) {
                    RegionInfo regionInfo = (RegionInfo)groupLists.get(n);
                    bytesArray[n] = Bytes.toBytes((String)regionInfo.getEncodedName());
                }
                logger.info("Start to merge group index:{},regions:{}", (Object)i, (Object)groupLists.stream().map(RegionInfo::getEncodedName).collect(Collectors.joining(",")));
                hBaseAdmin.mergeRegionsAsync((byte[][])bytesArray, false);
                logger.info("Merge group index:{} completed!", (Object)i);
            }
            logger.info("Merge table regions[{}] completed!", (Object)tableName);
        }
        catch (Exception ex) {
            logger.error("Merge table regions[{}] failed!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void increment(String tableName, LdpIncrement ldpIncrement) throws Exception {
        String rowKey = ldpIncrement.getKey();
        String column = ldpIncrement.getColumn();
        long step = ldpIncrement.getStep();
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            Increment increment = new Increment(Bytes.toBytes((String)rowKey));
            increment.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), step);
            long ttl = ldpIncrement.getTtl();
            Validate.isTrue((ttl != 0L ? 1 : 0) != 0);
            increment.setTTL(ttl);
            increment.setReturnResults(false);
            increment.setDurability(Durability.SYNC_WAL);
            table.increment(increment);
        }
        catch (Exception ex) {
            logger.error("hbase put error,tableName:{}!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void increments(String tableName, List<LdpIncrement> ldpIncrements) throws Exception {
        if (CollectionUtils.isEmpty(ldpIncrements)) {
            return;
        }
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            ArrayList rows = Lists.newArrayListWithCapacity((int)ldpIncrements.size());
            for (LdpIncrement ldpIncrement : ldpIncrements) {
                String rowKey = ldpIncrement.getKey();
                String column = ldpIncrement.getColumn();
                long step = ldpIncrement.getStep();
                long ttl = ldpIncrement.getTtl();
                Validate.isTrue((ttl != 0L ? 1 : 0) != 0);
                Increment increment = new Increment(Bytes.toBytes((String)rowKey));
                increment.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), step);
                increment.setTTL(ttl);
                increment.setReturnResults(false);
                increment.setDurability(Durability.SYNC_WAL);
                rows.add(increment);
            }
            table.batch((List)rows, null);
        }
        catch (Exception ex) {
            logger.error("batch increment error,tableName:{}!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void put(String tableName, LdpPut ldpPut) throws Exception {
        Object value = ldpPut.getData();
        String rowKey = ldpPut.getKey();
        String column = ldpPut.getColumn();
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            Put dbPut = new Put(Bytes.toBytes((String)rowKey));
            if (value.getClass() == String.class) {
                dbPut.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((String)value.toString()));
            } else if (value.getClass() == Long.class) {
                dbPut.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((long)((Long)value)));
            } else {
                throw new IllegalArgumentException(String.format("Current type(%s) not supported!", value.getClass()));
            }
            long ttl = ldpPut.getTtl();
            Validate.isTrue((ttl != 0L ? 1 : 0) != 0);
            dbPut.setTTL(ttl);
            dbPut.setDurability(Durability.SYNC_WAL);
            table.put(dbPut);
        }
        catch (Exception ex) {
            logger.error("hbase put error,metaName:{}!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void puts(String tableName, List<LdpPut> ldpPuts) throws Exception {
        if (CollectionUtils.isEmpty(ldpPuts)) {
            return;
        }
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            ArrayList puts = Lists.newArrayListWithCapacity((int)ldpPuts.size());
            for (LdpPut ldpPut : ldpPuts) {
                String rowKey = ldpPut.getKey();
                String column = ldpPut.getColumn();
                Object value = ldpPut.getData();
                long ttl = ldpPut.getTtl();
                Validate.isTrue((ttl != 0L ? 1 : 0) != 0);
                Put put = new Put(Bytes.toBytes((String)rowKey));
                put.setDurability(Durability.SYNC_WAL);
                if (value.getClass() == String.class) {
                    put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((String)value.toString()));
                } else if (value.getClass() == Long.class) {
                    put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((long)((Long)value)));
                } else {
                    throw new IllegalArgumentException(String.format("Current type(%s) not supported!", value.getClass()));
                }
                put.setTTL(ttl);
                puts.add(put);
            }
            table.put((List)puts);
        }
        catch (Exception ex) {
            logger.error("hbase batch put error,tableName:{}!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    @Override
    public <R> LdpResult<R> get(String tableName, LdpGet ldpGet, Class<R> clazz) throws Exception {
        Result dbResult;
        String rowKey = ldpGet.getKey();
        String column = ldpGet.getColumn();
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            Get get = new Get(Bytes.toBytes((String)rowKey));
            dbResult = table.get(get);
        }
        catch (Exception ex) {
            logger.error("hbase get error!", (Throwable)ex);
            throw ex;
        }
        Cell cell = dbResult.getColumnLatestCell(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column));
        LdpResult ldpResult = new LdpResult();
        if (cell != null) {
            byte[] b = CellUtil.cloneValue((Cell)cell);
            long timestamp = cell.getTimestamp();
            Object data = null;
            if (clazz == Long.class || clazz == Long.TYPE) {
                data = clazz.cast(Bytes.toLong((byte[])b));
            } else if (clazz == String.class) {
                data = clazz.cast(Bytes.toString((byte[])b));
            } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                data = clazz.cast(Bytes.toInt((byte[])b));
            } else if (clazz == Double.class || clazz == Double.TYPE) {
                data = clazz.cast(Bytes.toDouble((byte[])b));
            } else if (clazz == Float.class || clazz == Float.TYPE) {
                data = clazz.cast(Float.valueOf(Bytes.toFloat((byte[])b)));
            } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                data = clazz.cast(Bytes.toBoolean((byte[])b));
            }
            ldpResult.setData(data);
            ldpResult.setTimestamp(timestamp);
        }
        ldpResult.setKey(rowKey);
        ldpResult.setColumn(column);
        return ldpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> List<LdpResult<R>> gets(String tableName, List<LdpGet> ldpGets, Class<R> clazz) throws Exception {
        int totalSize = ldpGets.size();
        int loopSize = totalSize % 200 == 0 ? totalSize / 200 : totalSize / 200 + 1;
        ArrayList<Future<R>> results = new ArrayList<Future<R>>();
        for (int loop = 0; loop < loopSize; ++loop) {
            int end = Math.min((loop + 1) * 200, totalSize);
            List<LdpGet> list = ldpGets.subList(loop * 200, end);
            HBaseGetterThread<R> hBaseGetterThread = new HBaseGetterThread<R>(this.getTableName(tableName), list, clazz);
            ExecutorService executorService = pool;
            synchronized (executorService) {
                Future<R> result = pool.submit(hBaseGetterThread);
                results.add(result);
                continue;
            }
        }
        ArrayList<LdpResult<R>> totalResult = new ArrayList<LdpResult<R>>();
        for (Future future : results) {
            List ldpResults = (List)future.get();
            if (!CollectionUtils.isNotEmpty((Collection)ldpResults)) continue;
            totalResult.addAll(ldpResults);
        }
        return totalResult;
    }

    @Override
    public <R> List<LdpResult<R>> scan(String tableName, String startRow, String endRow, int limit, Class<R> clazz) throws Exception {
        ArrayList<LdpResult<R>> resultList = new ArrayList<LdpResult<R>>();
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            Scan scan = new Scan();
            scan.setStartRow(Bytes.toBytes((String)(startRow + ".")));
            scan.setStopRow(Bytes.toBytes((String)endRow));
            scan.setMaxResultSize((long)limit);
            scan.setCaching(20);
            scan.setBatch(100);
            try (ResultScanner scanner = table.getScanner(scan);){
                int count = 0;
                Result dbResult = scanner.next();
                while (dbResult != null) {
                    String rowKey = Bytes.toString((byte[])dbResult.getRow());
                    LdpResult ldpResult = new LdpResult();
                    Cell cell = dbResult.getColumnLatestCell(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"v"));
                    if (cell != null) {
                        byte[] b = CellUtil.cloneValue((Cell)cell);
                        long timestamp = cell.getTimestamp();
                        Object data = null;
                        if (clazz == Long.class || clazz == Long.TYPE) {
                            data = clazz.cast(Bytes.toLong((byte[])b));
                        } else if (clazz == String.class) {
                            data = clazz.cast(Bytes.toString((byte[])b));
                        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                            data = clazz.cast(Bytes.toInt((byte[])b));
                        } else if (clazz == Double.class || clazz == Double.TYPE) {
                            data = clazz.cast(Bytes.toDouble((byte[])b));
                        } else if (clazz == Float.class || clazz == Float.TYPE) {
                            data = clazz.cast(Float.valueOf(Bytes.toFloat((byte[])b)));
                        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                            data = clazz.cast(Bytes.toBoolean((byte[])b));
                        }
                        ldpResult.setData(data);
                        ldpResult.setTimestamp(timestamp);
                    }
                    ldpResult.setKey(rowKey);
                    if (limit != -1 && ++count > limit) {
                        break;
                    }
                    resultList.add(ldpResult);
                    dbResult = scanner.next();
                }
            }
            catch (Exception ex) {
                logger.error("hbase scan error!", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error("hbase scan error!", (Throwable)ex);
            throw ex;
        }
        return resultList;
    }

    @Override
    public void delete(String tableName, String key) throws Exception {
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            Delete delete = new Delete(Bytes.toBytes((String)key));
            table.delete(delete);
        }
        catch (Exception ex) {
            logger.error("delete table {} data error!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void deletes(String tableName, List<String> keyList) throws Exception {
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (String key : keyList) {
                Delete delete = new Delete(Bytes.toBytes((String)key));
                deletes.add(delete);
            }
            table.delete(deletes);
        }
        catch (Exception ex) {
            logger.error("delete table {} data error!", (Object)tableName, (Object)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putsWithCompare(String tableName, CompareOperator compareOperator, List<LdpPut> ldpPuts) throws Exception {
        if (CollectionUtils.isEmpty(ldpPuts)) {
            return;
        }
        Map<Long, List<LdpPut>> map = ldpPuts.stream().collect(Collectors.groupingBy(x -> HashUtil.BKDRHash((String)(x.getKey() + "_" + x.getColumn())) % 4L));
        for (Long object : map.keySet()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            String lockKey = "COMPARE_PUT_LOCK_" + tableName + "_" + compareOperator + "_" + object;
            boolean isLock = RedissonLock.tryLock(lockKey, 8L, 3L, TimeUnit.MINUTES);
            if (isLock) {
                try {
                    List<LdpPut> subList = map.get(object);
                    ArrayList<LdpGet> getList = new ArrayList<LdpGet>();
                    for (LdpPut ldpPut : subList) {
                        LdpGet ldpGet = new LdpGet();
                        ldpGet.setKey(ldpPut.getKey());
                        ldpGet.setColumn(ldpPut.getColumn());
                        getList.add(ldpGet);
                    }
                    List<LdpResult<Long>> dbResults = this.gets(tableName, getList, Long.class);
                    Map<String, Long> dbValueMap = null;
                    if (CollectionUtils.isNotEmpty(dbResults)) {
                        dbValueMap = dbResults.stream().filter(x -> x.getData() != null).collect(Collectors.toMap(x -> x.getKey() + ";" + x.getColumn(), LdpResult::getData));
                    }
                    ArrayList puts = Lists.newArrayList();
                    for (LdpPut ldpPut : subList) {
                        Put put;
                        String rowKey = ldpPut.getKey();
                        String column = ldpPut.getColumn();
                        Object value = ldpPut.getData();
                        long ttl = ldpPut.getTtl();
                        Validate.isTrue((ttl != 0L ? 1 : 0) != 0);
                        String aggregateKey = rowKey + ";" + column;
                        if (compareOperator == CompareOperator.GREATER) {
                            if (!MapUtils.isEmpty(dbValueMap) && dbValueMap.containsKey(aggregateKey) && (Long)ldpPut.getData() <= dbValueMap.get(aggregateKey)) continue;
                            put = new Put(Bytes.toBytes((String)rowKey));
                            if (value.getClass() == String.class) {
                                put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((String)value.toString()));
                            } else if (value.getClass() == Long.class) {
                                put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((long)((Long)value)));
                            } else {
                                throw new IllegalArgumentException(String.format("Current type(%s) not supported!", value.getClass()));
                            }
                            put.setTTL(ttl);
                            put.setDurability(Durability.SYNC_WAL);
                            puts.add(put);
                            continue;
                        }
                        if (!MapUtils.isEmpty(dbValueMap) && dbValueMap.containsKey(aggregateKey) && (Long)ldpPut.getData() >= dbValueMap.get(aggregateKey)) continue;
                        put = new Put(Bytes.toBytes((String)rowKey));
                        if (value.getClass() == String.class) {
                            put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((String)value.toString()));
                        } else if (value.getClass() == Long.class) {
                            put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column), Bytes.toBytes((long)((Long)value)));
                        } else {
                            throw new IllegalArgumentException(String.format("Current type(%s) not supported!", value.getClass()));
                        }
                        put.setTTL(ttl);
                        put.setDurability(Durability.SYNC_WAL);
                        puts.add(put);
                    }
                    try {
                        Table table = HBaseWarehouseStorageEngine.getConnection().getTable(this.getTableName(tableName));
                        try {
                            table.put((List)puts);
                            continue;
                        }
                        finally {
                            if (table != null) {
                                table.close();
                            }
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        logger.error("execute batch put error,tableName:{}!", (Object)tableName, (Object)ex);
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    logger.error("batch put error!", (Throwable)ex);
                    continue;
                }
                finally {
                    RedissonLock.unLock(lockKey);
                    continue;
                }
            }
            logger.error("try lock failed,thread unable to acquire lock,this batch data may be lost,cost:{}ms!", (Object)stopWatch.getTime());
        }
    }

    private static <R> List<LdpResult<R>> partGets(TableName tableName, List<LdpGet> ldpGets, Class<R> clazz) throws Exception {
        Result[] dbResults;
        String column;
        ArrayList<Get> getList = new ArrayList<Get>();
        for (LdpGet ldpGet : ldpGets) {
            String rowKey = ldpGet.getKey();
            column = ldpGet.getColumn();
            Get get = new Get(Bytes.toBytes((String)rowKey));
            get.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column));
            getList.add(get);
        }
        try (Table table = HBaseWarehouseStorageEngine.getConnection().getTable(tableName);){
            dbResults = table.get(getList);
        }
        catch (Exception ex) {
            logger.error("hbase get error!", (Throwable)ex);
            throw ex;
        }
        ArrayList<LdpResult<R>> resultList = new ArrayList<LdpResult<R>>();
        for (int i = 0; i < dbResults.length; ++i) {
            column = ldpGets.get(i).getColumn();
            String key = ldpGets.get(i).getKey();
            Result dbResult = dbResults[i];
            if (dbResult == null) continue;
            LdpResult ldpResult = new LdpResult();
            Cell cell = dbResult.getColumnLatestCell(Bytes.toBytes((String)"f"), Bytes.toBytes((String)column));
            if (cell != null) {
                byte[] b = CellUtil.cloneValue((Cell)cell);
                long timestamp = cell.getTimestamp();
                Object data = null;
                if (clazz == Long.class || clazz == Long.TYPE) {
                    data = clazz.cast(Bytes.toLong((byte[])b));
                } else if (clazz == String.class) {
                    data = clazz.cast(Bytes.toString((byte[])b));
                } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                    data = clazz.cast(Bytes.toInt((byte[])b));
                } else if (clazz == Double.class || clazz == Double.TYPE) {
                    data = clazz.cast(Bytes.toDouble((byte[])b));
                } else if (clazz == Float.class || clazz == Float.TYPE) {
                    data = clazz.cast(Float.valueOf(Bytes.toFloat((byte[])b)));
                } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                    data = clazz.cast(Bytes.toBoolean((byte[])b));
                }
                ldpResult.setData(data);
                ldpResult.setTimestamp(timestamp);
            }
            ldpResult.setKey(key);
            ldpResult.setColumn(column);
            resultList.add(ldpResult);
        }
        return resultList;
    }

    @Override
    public boolean isAppendable(String tableName) throws Exception {
        return true;
    }

    @Override
    public long getTableMaxValidPeriod() throws Exception {
        return TimeUnit.DAYS.toSeconds(120L);
    }

    static {
        String compression = LDPConfig.getOrDefault("data.storage.compression.type", "zstd", String.class);
        if (StringUtil.isNotEmpty((String)compression)) {
            switch (compression) {
                case "snappy": {
                    algorithm = Compression.Algorithm.SNAPPY;
                    break;
                }
                case "bzip2": {
                    algorithm = Compression.Algorithm.BZIP2;
                    break;
                }
                case "zstd": {
                    algorithm = Compression.Algorithm.ZSTD;
                    break;
                }
                case "gz": {
                    algorithm = Compression.Algorithm.GZ;
                    break;
                }
                case "lzo": {
                    algorithm = Compression.Algorithm.LZO;
                    break;
                }
                default: {
                    algorithm = Compression.Algorithm.NONE;
                }
            }
        }
        pool = Executors.newFixedThreadPool(5, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("HBase-WarehouseEngine-schedule-pool-%d").build());
    }

    private static class HBaseGetterThread<R>
    implements Callable<List<LdpResult<R>>> {
        private final TableName tableName;
        private final List<LdpGet> getList;
        private final Class<R> clazz;

        public HBaseGetterThread(TableName tableName, List<LdpGet> getList, Class<R> clazz) {
            this.getList = getList;
            this.tableName = tableName;
            this.clazz = clazz;
        }

        @Override
        public List<LdpResult<R>> call() throws Exception {
            return HBaseWarehouseStorageEngine.partGets(this.tableName, this.getList, this.clazz);
        }
    }
}

