/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.warehouse.mysql;

import com.dtstep.lighthouse.common.exception.InitializationException;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.dao.DBConnectionSource;
import com.dtstep.lighthouse.core.dao.RDBMSConfiguration;
import com.dtstep.lighthouse.core.lock.RedissonLock;
import com.dtstep.lighthouse.core.storage.common.CompareOperator;
import com.dtstep.lighthouse.core.storage.common.LdpGet;
import com.dtstep.lighthouse.core.storage.common.LdpIncrement;
import com.dtstep.lighthouse.core.storage.common.LdpPut;
import com.dtstep.lighthouse.core.storage.common.LdpResult;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngine;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLWarehouseStorageEngine
implements WarehouseStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(MySQLWarehouseStorageEngine.class);
    private static final BasicDataSource basicDataSource;
    private static final RDBMSConfiguration mySQLConfiguration;
    private static final ThreadLocal<Connection> connectionHolder;
    private static final String MYSQL_PUTS_LOCK_PREFIX = "MYSQL_PUTS_LOCK_PREFIX";
    private static final String MYSQL_INCREMENT_PUT_LOCK = "MYSQL_INCREMENT_PUT_LOCK";
    private static final String MYSQL_INCREMENTS_LOCK_PREFIX = "MYSQL_INCREMENTS_PUT_LOCK";
    private static final int batchSalt = 4;
    private static final String MYSQL_COMPARE_PUT_LOCK_PREFIX = "MYSQL_COMPARE_PUT_LOCK_PREFIX";
    private static final int BATCH_GET_SIZE = 200;
    private static final ExecutorService pool;

    private Connection getConnection() throws Exception {
        Connection conn = connectionHolder.get();
        if (conn == null || conn.isClosed()) {
            conn = basicDataSource.getConnection();
            connectionHolder.set(conn);
        }
        return conn;
    }

    private void closeConnection() throws Exception {
        Connection conn = connectionHolder.get();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                connectionHolder.remove();
            }
        }
    }

    @Override
    public String getDefaultNamespace() {
        return null;
    }

    @Override
    public void createNamespaceIfNotExist(String namespace) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createResultTable(String tableName) throws Exception {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            String sql = String.format("CREATE TABLE IF NOT EXISTS %s (id BIGINT AUTO_INCREMENT PRIMARY KEY, k VARCHAR(200) NOT NULL, v bigint NOT NULL DEFAULT '0', upd_time timestamp NOT NULL, exp_time timestamp NOT NULL, UNIQUE KEY `k_UNIQUE` (`k`), KEY `index_exp_time` (`exp_time`)) ENGINE=InnoDB AUTO_INCREMENT=100000 DEFAULT CHARSET=utf8mb3", tableName);
            statement = connection.createStatement();
            statement.execute(sql);
            logger.info("Mysql Table '{}' created successfully!", (Object)tableName);
            this.release(null, statement, connection);
        }
        catch (SQLException ex) {
            try {
                logger.error("Mysql Table '{}' created failed!", (Object)tableName, (Object)ex);
                ex.printStackTrace();
                this.release(null, statement, connection);
            }
            catch (Throwable throwable) {
                this.release(null, statement, connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDimensTable(String tableName) throws Exception {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            String sql = String.format("CREATE TABLE IF NOT EXISTS %s (id BIGINT AUTO_INCREMENT PRIMARY KEY, k VARCHAR(200) NOT NULL, v VARCHAR(800) NOT NULL, upd_time timestamp NOT NULL, exp_time timestamp NOT NULL, UNIQUE KEY `k_UNIQUE` (`k`), KEY `index_exp_time` (`exp_time`)) ENGINE=InnoDB AUTO_INCREMENT=100000 DEFAULT CHARSET=utf8mb3", tableName);
            statement = connection.createStatement();
            statement.execute(sql);
            logger.info("Mysql Table '{}' created successfully!", (Object)tableName);
            this.release(null, statement, connection);
        }
        catch (SQLException ex) {
            try {
                logger.error("Mysql Table '{}' created failed!", (Object)tableName, (Object)ex);
                ex.printStackTrace();
                this.release(null, statement, connection);
            }
            catch (Throwable throwable) {
                this.release(null, statement, connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableExist(String tableName) throws Exception {
        String query = "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(query);
            ps.setString(1, mySQLConfiguration.getDatabase());
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) > 0;
                this.release(rs, ps, connection);
                return bl;
            }
            this.release(rs, ps, connection);
        }
        catch (Exception ex) {
            logger.error("check mysql table exist error!", (Throwable)ex);
        }
        finally {
            this.release(rs, ps, connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String tableName) throws Exception {
        String sql = String.format("DROP TABLE %s", tableName);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            statement.execute(sql);
            logger.info("drop table:{} successfully!", (Object)tableName);
        }
        catch (Exception ex) {
            logger.error("drop table:{} error!", (Object)tableName, (Object)ex);
            ex.printStackTrace();
        }
        finally {
            this.release(null, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String tableName, LdpPut ldpPut) throws Exception {
        Object value = ldpPut.getData();
        String sql = "INSERT ignore INTO " + tableName + " (`k`, `v`, `exp_time`, `upd_time`) VALUES (?, ?, ?, ?) on duplicate key update v = ?,exp_time = ? , upd_time = ?";
        Connection connection = null;
        PreparedStatement ps = null;
        long current = System.currentTimeMillis();
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, MySQLWarehouseStorageEngine.getDBKey(ldpPut.getKey(), ldpPut.getColumn()));
            if (value.getClass() == String.class) {
                ps.setString(2, ldpPut.getData().toString());
            } else if (value.getClass() == Long.class) {
                ps.setLong(2, (Long)ldpPut.getData());
            } else {
                throw new IllegalArgumentException(String.format("Current type(%s) not supported!", value.getClass()));
            }
            ps.setTimestamp(3, new Timestamp(current + ldpPut.getTtl()));
            ps.setTimestamp(4, new Timestamp(current));
            if (value.getClass() == String.class) {
                ps.setString(5, ldpPut.getData().toString());
            } else {
                ps.setLong(5, (Long)ldpPut.getData());
            }
            ps.setTimestamp(6, new Timestamp(current + ldpPut.getTtl()));
            ps.setTimestamp(7, new Timestamp(current));
            ps.executeUpdate();
        }
        catch (Exception ex) {
            logger.error("put data to mysql error,tableName:{}!", (Object)tableName, (Object)ex);
            ex.printStackTrace();
        }
        finally {
            this.release(null, ps, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void puts(String tableName, List<LdpPut> ldpPuts) throws Exception {
        String sql = "INSERT ignore INTO " + tableName + " (`k`, `v`, `exp_time`, `upd_time`) VALUES (?, ?, ?, ?) on duplicate key update v = ?,exp_time = ? , upd_time = ?";
        Connection connection = null;
        PreparedStatement ps = null;
        long current = System.currentTimeMillis();
        Map<Long, List<LdpPut>> map = ldpPuts.stream().collect(Collectors.groupingBy(x -> HashUtil.BKDRHash((String)MySQLWarehouseStorageEngine.getDBKey(x.getKey(), x.getColumn())) % 4L));
        for (Long object : map.keySet()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            List<LdpPut> subList = map.get(object);
            String lockKey = "MYSQL_PUTS_LOCK_PREFIX_" + tableName + "_" + object;
            boolean isLock = RedissonLock.tryLock(lockKey, 8L, 3L, TimeUnit.MINUTES);
            if (isLock) {
                try {
                    connection = this.getConnection();
                    ps = connection.prepareStatement(sql);
                    for (LdpPut ldpPut : subList) {
                        Object value = ldpPut.getData();
                        ps.setString(1, MySQLWarehouseStorageEngine.getDBKey(ldpPut.getKey(), ldpPut.getColumn()));
                        if (value.getClass() == String.class) {
                            ps.setString(2, ldpPut.getData().toString());
                        } else if (value.getClass() == Long.class) {
                            ps.setLong(2, (Long)ldpPut.getData());
                        } else {
                            throw new IllegalArgumentException(String.format("Current type(%s) not supported!", value.getClass()));
                        }
                        ps.setTimestamp(3, new Timestamp(current + ldpPut.getTtl()));
                        ps.setTimestamp(4, new Timestamp(current));
                        if (value.getClass() == String.class) {
                            ps.setString(5, ldpPut.getData().toString());
                        } else {
                            ps.setLong(5, (Long)ldpPut.getData());
                        }
                        ps.setTimestamp(6, new Timestamp(current + ldpPut.getTtl()));
                        ps.setTimestamp(7, new Timestamp(current));
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    ps.clearBatch();
                    continue;
                }
                catch (Exception ex) {
                    logger.error("puts data to mysql error,tableName:{},putsSize:{}!", new Object[]{tableName, subList.size(), ex});
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    this.release(null, ps, connection);
                    try {
                        RedissonLock.unLock(lockKey);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
            }
            logger.error("try lock failed,thread unable to acquire lock,this batch data may be lost,cost:{}ms!", (Object)stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void increment(String tableName, LdpIncrement ldpIncrement) throws Exception {
        block12: {
            Validate.notNull((Object)ldpIncrement);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Connection connection = null;
            PreparedStatement ps = null;
            long current = System.currentTimeMillis();
            String sql = "INSERT INTO " + tableName + "(`k`,`v`,`exp_time`,`upd_time`) values (?, ?, ?, ?) on duplicate key update `v` = `v` + ?, `exp_time` = ? , `upd_time` = ?";
            String dbKey = MySQLWarehouseStorageEngine.getDBKey(ldpIncrement.getKey(), ldpIncrement.getColumn());
            String lockKey = "MYSQL_INCREMENT_PUT_LOCK_" + tableName + "_" + dbKey;
            boolean isLock = RedissonLock.tryLock(lockKey, 8L, 3L, TimeUnit.MINUTES);
            if (isLock) {
                connection = this.getConnection();
                ps = connection.prepareStatement(sql);
                ps.setString(1, dbKey);
                ps.setLong(2, ldpIncrement.getStep());
                ps.setTimestamp(3, new Timestamp(current + ldpIncrement.getTtl()));
                ps.setTimestamp(4, new Timestamp(current));
                ps.setLong(5, ldpIncrement.getStep());
                ps.setTimestamp(6, new Timestamp(current + ldpIncrement.getTtl()));
                ps.setTimestamp(7, new Timestamp(current));
                ps.executeUpdate();
            } else {
                logger.error("try lock failed,thread unable to acquire lock,this batch data may be lost,cost:{}ms!", (Object)stopWatch.getTime());
            }
            this.release(null, ps, connection);
            try {
                RedissonLock.unLock(lockKey);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            break block12;
            catch (Exception ex) {
                try {
                    logger.error("increment process error!", (Throwable)ex);
                    ex.printStackTrace();
                    this.release(null, ps, connection);
                }
                catch (Throwable throwable) {
                    this.release(null, ps, connection);
                    try {
                        RedissonLock.unLock(lockKey);
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    RedissonLock.unLock(lockKey);
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increments(String tableName, List<LdpIncrement> ldpIncrements) throws Exception {
        long current = System.currentTimeMillis();
        String sql = "INSERT INTO " + tableName + "(`k`,`v`,`exp_time`,`upd_time`) values (?, ?, ?, ?) on duplicate key update `v` = `v` + ?, `exp_time` = ? , `upd_time` = ?";
        Map<Long, List<LdpIncrement>> map = ldpIncrements.stream().collect(Collectors.groupingBy(x -> HashUtil.BKDRHash((String)MySQLWarehouseStorageEngine.getDBKey(x.getKey(), x.getColumn())) % 4L));
        for (Long object : map.keySet()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            List<LdpIncrement> subList = map.get(object);
            String lockKey = "MYSQL_INCREMENTS_PUT_LOCK_" + tableName + "_" + object;
            boolean isLock = RedissonLock.tryLock(lockKey, 8L, 3L, TimeUnit.MINUTES);
            if (isLock) {
                Connection connection = null;
                PreparedStatement ps = null;
                try {
                    connection = this.getConnection();
                    ps = connection.prepareStatement(sql);
                    for (LdpIncrement ldpIncrement : subList) {
                        ps.setString(1, MySQLWarehouseStorageEngine.getDBKey(ldpIncrement.getKey(), ldpIncrement.getColumn()));
                        ps.setLong(2, ldpIncrement.getStep());
                        ps.setTimestamp(3, new Timestamp(current + ldpIncrement.getTtl()));
                        ps.setTimestamp(4, new Timestamp(current));
                        ps.setLong(5, ldpIncrement.getStep());
                        ps.setTimestamp(6, new Timestamp(current + ldpIncrement.getTtl()));
                        ps.setTimestamp(7, new Timestamp(current));
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    ps.clearBatch();
                    continue;
                }
                catch (Exception ex) {
                    logger.error("increments process error!", (Throwable)ex);
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    this.release(null, ps, connection);
                    try {
                        RedissonLock.unLock(lockKey);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
            }
            logger.error("try lock failed,thread unable to acquire lock,this batch data may be lost,cost:{}ms!", (Object)stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putsWithCompare(String tableName, CompareOperator compareOperator, List<LdpPut> ldpPuts) throws Exception {
        if (CollectionUtils.isEmpty(ldpPuts)) {
            return;
        }
        Map<Long, List<LdpPut>> map = ldpPuts.stream().collect(Collectors.groupingBy(x -> HashUtil.BKDRHash((String)MySQLWarehouseStorageEngine.getDBKey(x.getKey(), x.getColumn())) % 4L));
        for (Long object : map.keySet()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            String lockKey = "MYSQL_COMPARE_PUT_LOCK_PREFIX_" + tableName + "_" + compareOperator + "_" + object;
            boolean isLock = RedissonLock.tryLock(lockKey, 8L, 3L, TimeUnit.MINUTES);
            if (isLock) {
                try {
                    List<LdpPut> subList = map.get(object);
                    ArrayList<LdpGet> getList = new ArrayList<LdpGet>();
                    for (LdpPut ldpPut : subList) {
                        LdpGet ldpGet = new LdpGet();
                        ldpGet.setKey(ldpPut.getKey());
                        ldpGet.setColumn(ldpPut.getColumn());
                        getList.add(ldpGet);
                    }
                    List<LdpResult<Long>> dbResults = this.gets(tableName, getList, Long.class);
                    Map<String, Long> dbValueMap = null;
                    if (CollectionUtils.isNotEmpty(dbResults)) {
                        dbValueMap = dbResults.stream().filter(x -> x.getData() != null).collect(Collectors.toMap(x -> MySQLWarehouseStorageEngine.getDBKey(x.getKey(), x.getColumn()), LdpResult::getData));
                    }
                    ArrayList<LdpPut> filterPuts = new ArrayList<LdpPut>();
                    for (LdpPut ldpPut : subList) {
                        String rowKey = ldpPut.getKey();
                        String column = ldpPut.getColumn();
                        String aggregateKey = MySQLWarehouseStorageEngine.getDBKey(rowKey, column);
                        if (compareOperator == CompareOperator.GREATER) {
                            if (!MapUtils.isEmpty(dbValueMap) && dbValueMap.containsKey(aggregateKey) && (Long)ldpPut.getData() <= dbValueMap.get(aggregateKey)) continue;
                            filterPuts.add(ldpPut);
                            continue;
                        }
                        if (!MapUtils.isEmpty(dbValueMap) && dbValueMap.containsKey(aggregateKey) && (Long)ldpPut.getData() >= dbValueMap.get(aggregateKey)) continue;
                        filterPuts.add(ldpPut);
                    }
                    this.puts(tableName, filterPuts);
                    continue;
                }
                catch (Exception ex) {
                    logger.error("batch put error!", (Throwable)ex);
                    continue;
                }
                finally {
                    RedissonLock.unLock(lockKey);
                    continue;
                }
            }
            logger.error("try lock failed,thread unable to acquire lock,this batch data may be lost,cost:{}ms!", (Object)stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> LdpResult<R> get(String tableName, LdpGet ldpGet, Class<R> clazz) throws Exception {
        String sql = "SELECT v FROM " + tableName + " WHERE `k` = ?";
        String ldpKey = ldpGet.getKey();
        String ldpColumn = ldpGet.getColumn();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        LdpResult ldpResult = new LdpResult();
        ldpResult.setKey(ldpKey);
        ldpResult.setColumn(ldpColumn);
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, MySQLWarehouseStorageEngine.getDBKey(ldpKey, ldpColumn));
            rs = ps.executeQuery();
            Object result = null;
            while (rs.next()) {
                if (clazz == Long.class) {
                    result = clazz.cast(rs.getString(1));
                    continue;
                }
                if (clazz != String.class) continue;
                result = clazz.cast(rs.getLong(1));
            }
            ldpResult.setData(result);
            this.release(rs, ps, connection);
        }
        catch (Exception ex) {
            logger.error("get data from mysql error!", (Throwable)ex);
        }
        finally {
            this.release(rs, ps, connection);
        }
        return ldpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<LdpResult<R>> partGets(String tableName, List<LdpGet> ldpGets, Class<R> clazz) throws Exception {
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(ldpGets.size(), "?"));
        String sql = "SELECT `k`,`v`,`upd_time` FROM " + tableName + " WHERE k IN(" + placeholders + ")";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<LdpResult<R>> ldpResults = new ArrayList<LdpResult<R>>();
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            for (int i = 0; i < ldpGets.size(); ++i) {
                LdpGet ldpGet = ldpGets.get(i);
                String tempKey = MySQLWarehouseStorageEngine.getDBKey(ldpGet.getKey(), ldpGet.getColumn());
                ps.setString(i + 1, tempKey);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String key;
                LdpResult ldpResult = new LdpResult();
                Object r = null;
                String dbKey = rs.getString("k");
                if (clazz == Long.class) {
                    r = clazz.cast(rs.getLong("v"));
                } else if (clazz == String.class) {
                    r = clazz.cast(rs.getString("v"));
                }
                Timestamp updTime = rs.getTimestamp("upd_time");
                String column = null;
                if (dbKey.contains(";")) {
                    key = dbKey.split(";")[0];
                    column = dbKey.split(";")[1];
                } else {
                    key = dbKey;
                }
                ldpResult.setKey(key);
                ldpResult.setColumn(column);
                ldpResult.setData(r);
                ldpResult.setTimestamp(updTime.getTime());
                ldpResults.add(ldpResult);
            }
            this.release(rs, ps, connection);
        }
        catch (Exception ex) {
            logger.error("query data info error!", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            this.release(rs, ps, connection);
        }
        return ldpResults;
    }

    private void release(ResultSet rs, Statement statement, Connection connection) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> List<LdpResult<R>> gets(String tableName, List<LdpGet> ldpGets, Class<R> clazz) throws Exception {
        int totalSize = ldpGets.size();
        int loopSize = totalSize % 200 == 0 ? totalSize / 200 : totalSize / 200 + 1;
        ArrayList<Future<R>> results = new ArrayList<Future<R>>();
        for (int loop = 0; loop < loopSize; ++loop) {
            int end = Math.min((loop + 1) * 200, totalSize);
            List<LdpGet> list = ldpGets.subList(loop * 200, end);
            MysqlGetterThread<R> hBaseGetterThread = new MysqlGetterThread<R>(tableName, list, clazz);
            ExecutorService executorService = pool;
            synchronized (executorService) {
                Future<R> result = pool.submit(hBaseGetterThread);
                results.add(result);
                continue;
            }
        }
        ArrayList<LdpResult<R>> totalResult = new ArrayList<LdpResult<R>>();
        for (Future future : results) {
            List ldpResults = (List)future.get();
            if (!CollectionUtils.isNotEmpty((Collection)ldpResults)) continue;
            totalResult.addAll(ldpResults);
        }
        return totalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> List<LdpResult<R>> scan(String tableName, String startRow, String endRow, int limit, Class<R> clazz) throws Exception {
        String sql = "SELECT `k` , `v` ,`upd_time` from " + tableName + " where k >= ? and k < ? order by k asc limit ?";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<LdpResult<R>> ldpResults = new ArrayList<LdpResult<R>>();
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, startRow);
            ps.setString(2, endRow);
            ps.setInt(3, limit);
            rs = ps.executeQuery();
            while (rs.next()) {
                String key;
                LdpResult ldpResult = new LdpResult();
                Object r = null;
                String dbKey = rs.getString("k");
                if (clazz == Long.class) {
                    r = clazz.cast(rs.getLong("v"));
                } else if (clazz == String.class) {
                    r = clazz.cast(rs.getString("v"));
                }
                Timestamp updTime = rs.getTimestamp("upd_time");
                String column = null;
                if (dbKey.contains(";")) {
                    key = dbKey.split(";")[0];
                    column = dbKey.split(";")[1];
                } else {
                    key = dbKey;
                }
                ldpResult.setKey(key);
                ldpResult.setColumn(column);
                ldpResult.setData(r);
                ldpResult.setTimestamp(updTime.getTime());
                ldpResults.add(ldpResult);
            }
            this.release(rs, ps, connection);
        }
        catch (Exception ex) {
            logger.error("scan mysql data error!", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            this.release(rs, ps, connection);
        }
        return ldpResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String tableName, String key) throws Exception {
        String sql = "DELETE FROM " + tableName + " WHERE k = ?";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, key);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            logger.error("delete mysql data error!", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            this.release(null, ps, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletes(String tableName, List<String> keyList) throws Exception {
        if (keyList == null || keyList.isEmpty()) {
            logger.warn("Key list is empty, nothing to delete.");
            return;
        }
        StringBuilder sql = new StringBuilder("DELETE FROM " + tableName + " WHERE k IN (");
        sql.append("?,".repeat(keyList.size()));
        sql.setLength(sql.length() - 1);
        sql.append(")");
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql.toString());
            for (int i = 0; i < keyList.size(); ++i) {
                ps.setString(i + 1, keyList.get(i));
            }
            ps.executeUpdate();
            this.release(null, ps, connection);
        }
        catch (Exception ex) {
            try {
                logger.error("Batch delete mysql data error!", (Throwable)ex);
                ex.printStackTrace();
                this.release(null, ps, connection);
            }
            catch (Throwable throwable) {
                this.release(null, ps, connection);
                throw throwable;
            }
        }
    }

    @Override
    public boolean isAppendable(String tableName) throws Exception {
        return true;
    }

    @Override
    public long getTableMaxValidPeriod() throws Exception {
        return TimeUnit.DAYS.toSeconds(120L);
    }

    private static String getDBKey(String ldpKey, String ldpColumn) {
        if (StringUtil.isNotEmpty((String)ldpColumn)) {
            return ldpKey + ";" + ldpColumn;
        }
        return ldpKey;
    }

    static {
        connectionHolder = new ThreadLocal();
        String driverClassName = LDPConfig.getVal("warehouse.storage.engine.javax.jdo.option.driverClassName");
        String connectionUrl = LDPConfig.getVal("warehouse.storage.engine.javax.jdo.option.ConnectionURL");
        String connectionUserName = LDPConfig.getVal("warehouse.storage.engine.javax.jdo.option.ConnectionUserName");
        String connectionPassword = LDPConfig.getVal("warehouse.storage.engine.javax.jdo.option.ConnectionPassword");
        try {
            Validate.isTrue((boolean)StringUtil.isNotEmpty((String)driverClassName));
            Validate.isTrue((boolean)StringUtil.isNotEmpty((String)connectionUrl));
            Validate.isTrue((boolean)StringUtil.isNotEmpty((String)connectionUserName));
            Validate.isTrue((boolean)StringUtil.isNotEmpty((String)connectionPassword));
            mySQLConfiguration = new RDBMSConfiguration(driverClassName, connectionUrl, connectionUserName, connectionPassword);
            basicDataSource = DBConnectionSource.getBasicDataSource(mySQLConfiguration);
            logger.info("Database[{}] connection initialization completed!", (Object)mySQLConfiguration.getDatabase());
        }
        catch (Exception ex) {
            logger.error("init mysql warehouse connection error!", (Throwable)ex);
            throw new InitializationException("init mysql warehouse connection error!");
        }
        pool = Executors.newFixedThreadPool(5, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("MySql-WarehouseEngine-schedule-pool-%d").build());
    }

    private class MysqlGetterThread<R>
    implements Callable<List<LdpResult<R>>> {
        private final String tableName;
        private final List<LdpGet> getList;
        private final Class<R> clazz;

        public MysqlGetterThread(String tableName, List<LdpGet> getList, Class<R> clazz) {
            this.getList = getList;
            this.tableName = tableName;
            this.clazz = clazz;
        }

        @Override
        public List<LdpResult<R>> call() throws Exception {
            return MySQLWarehouseStorageEngine.this.partGets(this.tableName, this.getList, this.clazz);
        }
    }
}

