/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.template;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.LimitTypeEnum;
import com.dtstep.lighthouse.common.enums.function.FunctionEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.formula.FormulaTranslate;
import com.dtstep.lighthouse.core.formula.TemplateUtil;
import com.dtstep.lighthouse.core.template.ImitateCompile;
import com.dtstep.lighthouse.core.template.Parser;
import com.dtstep.lighthouse.core.template.TemplateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class IterativeParsePattern
implements Parser {
    private static final Pattern columnExtractPattern = Pattern.compile("(?![^']*'[^']*(?:'[^']*')*$)\\b(?=\\w*[a-zA-Z])\\w+\\b(?!\\s*\\()");

    @Override
    public ServiceResult<TemplateEntity> parseConfig(TemplateContext context) {
        Pair<String, List<StatState>> statePair;
        String limit;
        TemplateEntity templateEntity = new TemplateEntity();
        String template = context.getTemplate();
        Document document = Jsoup.parse((String)template, (String)"", (org.jsoup.parser.Parser)org.jsoup.parser.Parser.xmlParser());
        Elements elements = document.select("stat-item");
        if (elements == null || elements.size() == 0) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserNoValidItem);
        }
        if (elements.size() > 1) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserValidFailed);
        }
        Element element = (Element)elements.get(0);
        Attributes attributes = element.attributes();
        List fieldList = TemplateEntity.getTemplateAttrs();
        for (Attribute attribute : attributes) {
            if (!fieldList.contains(attribute.getKey())) {
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserInValidAttrExist, (String[])new String[]{attribute.getKey()}));
            }
            if (!StringUtil.isEmpty((String)attribute.getValue())) continue;
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserAttrCannotBeEmpty, (String[])new String[]{attribute.getKey()}));
        }
        String title = element.attr("title");
        if (StringUtil.isEmpty((String)title)) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserTitleCannotBeEmpty);
        }
        if (StringUtil.getBLen((String)title.trim()) < 5) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserTitleLengthValidFailed);
        }
        if (StringUtil.getBLen((String)title.trim()) >= 40) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserTitleLengthValidFailed);
        }
        templateEntity.setTitle(title);
        String stat = element.attr("stat");
        if (StringUtil.isEmpty((String)stat)) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserStatCannotBeEmpty);
        }
        templateEntity.setStat(stat);
        List<Column> columnList = context.getColumnList();
        List groupColumnList = columnList.stream().map(Column::getName).collect(Collectors.toList());
        List<String> statFormulaColumnsList = IterativeParsePattern.extractColumnsList(stat);
        statFormulaColumnsList.removeAll(groupColumnList);
        if (statFormulaColumnsList.size() > 0) {
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserColumnNotExist, (String[])new String[]{String.join((CharSequence)",", statFormulaColumnsList)}));
        }
        String dimensFormula = element.attr("dimens");
        if (!StringUtil.isEmpty((String)dimensFormula)) {
            String[] dimensArray;
            for (String dimens : dimensArray = TemplateUtil.split(dimensFormula)) {
                if (StringUtil.isLetterNumOrUnderLine((String)dimens) && !groupColumnList.contains(dimens)) {
                    return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserDimensNotExist, (String[])new String[]{dimens}));
                }
                boolean checkFlag = ImitateCompile.imitateDimensFormula(context.getStatId(), dimens, columnList);
                if (checkFlag) continue;
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserDimensValidFailed, (String[])new String[]{dimens}));
            }
            if (dimensArray.length > 5) {
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.dimensColumnsExceedLimit, (String[])new String[]{String.format("%s > %s", dimensArray.length, 5)}));
            }
            templateEntity.setDimens(dimensFormula);
            templateEntity.setDimensArray(dimensArray);
            List<String> dimensFormulaColumnsList = IterativeParsePattern.extractColumnsList(dimensFormula);
            dimensFormulaColumnsList.removeAll(groupColumnList);
            if (dimensFormulaColumnsList.size() > 0) {
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserColumnNotExist, (String[])new String[]{String.join((CharSequence)",", dimensFormulaColumnsList)}));
            }
        }
        if (!StringUtil.isEmpty((String)(limit = element.attr("limit")))) {
            int duration;
            String sizeStr;
            if (limit.startsWith("top")) {
                sizeStr = limit.substring(3);
                templateEntity.setLimitTypeEnum(LimitTypeEnum.TOP);
            } else if (limit.startsWith("last")) {
                sizeStr = limit.substring(4);
                templateEntity.setLimitTypeEnum(LimitTypeEnum.LAST);
            } else {
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserLimitValidFailed, (String[])new String[]{limit}));
            }
            if (StringUtil.isEmpty((String)sizeStr) || !StringUtil.isInt((String)sizeStr) || Integer.parseInt(sizeStr) < 0) {
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserLimitValidFailed, (String[])new String[]{limit}));
            }
            if (Integer.parseInt(sizeStr) > 200) {
                return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserLimitValueExceed, (String[])new String[]{sizeStr}));
            }
            String timeParam = context.getTimeParam();
            if (!StringUtil.isEmpty((String)timeParam) && timeParam.endsWith("minute") && (duration = Integer.parseInt(timeParam.split("-")[0])) < 5) {
                return ServiceResult.result((ResultCode)ResultCode.templateParserLimitMinuteNotSupport);
            }
            if (StringUtil.isEmpty((String)dimensFormula)) {
                return ServiceResult.result((ResultCode)ResultCode.templateParserLimitDimensExistTogether);
            }
            templateEntity.setLimit(limit);
            templateEntity.setLimitSize(Integer.parseInt(sizeStr));
        }
        try {
            statePair = FormulaTranslate.translate(stat);
        }
        catch (Exception ex) {
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserStatValidFailed, (String[])new String[]{stat}));
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)statePair.getRight()))) {
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserStatValidFailed, (String[])new String[]{stat}));
        }
        String completeStat = (String)statePair.getLeft();
        boolean checkFlag = ImitateCompile.imitateStatFormula(context.getStatId(), completeStat, columnList);
        if (!checkFlag) {
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserStatValidFailed, (String[])new String[]{stat}));
        }
        templateEntity.setCompleteStat(completeStat);
        List stateList = (List)statePair.getRight();
        for (StatState statState : stateList) {
            if (StatState.isCountState((StatState)statState) || !CollectionUtils.isEmpty((Collection)statState.getUnitList())) continue;
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.templateParserStatValidFailed, (String[])new String[]{stat}));
        }
        if (stateList.size() > 3) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserStateExceedLimit);
        }
        boolean isSequence = stateList.stream().anyMatch(x -> x.getFunctionEnum() == FunctionEnum.SEQ);
        if (isSequence && stateList.size() > 1) {
            return ServiceResult.result((ResultCode)ResultCode.templateParserSeqTogether);
        }
        templateEntity.setStatStateList(stateList);
        return ServiceResult.result((ResultCode)ResultCode.success, (Object)templateEntity);
    }

    public static List<String> extractColumnsList(String input) {
        String replaceInput = IterativeParsePattern.replaceQuotedContent(input);
        ArrayList<String> validMatches = new ArrayList<String>();
        Matcher matcher = columnExtractPattern.matcher(replaceInput);
        while (matcher.find()) {
            String match = matcher.group();
            if (!IterativeParsePattern.isValidMatch(match)) continue;
            validMatches.add(match);
        }
        return validMatches;
    }

    public static String replaceQuotedContent(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                if (!inQuotes) {
                    inQuotes = true;
                    result.append('-');
                    continue;
                }
                inQuotes = false;
                continue;
            }
            if (inQuotes) {
                result.append('-');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isValidMatch(String match) {
        return match.matches(".*[a-zA-Z].*");
    }
}

