/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.entity.AlarmExtEntity;
import com.dtstep.lighthouse.common.entity.AlarmTemplateExtEntity;
import com.dtstep.lighthouse.common.enums.AlarmMatchEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.modal.Alarm;
import com.dtstep.lighthouse.common.modal.AlarmChannel;
import com.dtstep.lighthouse.common.modal.AlarmCondition;
import com.dtstep.lighthouse.common.modal.AlarmSettings;
import com.dtstep.lighthouse.common.modal.AlarmTemplate;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmDBWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AlarmDBWrapper.class);
    private static final Integer _CacheExpireMinutes = 5;
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final Cache<Integer, Optional<AlarmExtEntity>> ALARM_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100000L).softValues().build();
    private static final Cache<Integer, Optional<AlarmChannel>> AlarmChannelCache = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100L).softValues().build();
    private static final Cache<Integer, Optional<List<AlarmExtEntity>>> STAT_ALARM_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(200000L).softValues().build();

    public static AlarmExtEntity queryById(Integer id) {
        Optional optional = (Optional)ALARM_CACHE.get((Object)id, k -> AlarmDBWrapper.actualQueryById(id));
        assert (optional != null);
        return optional.orElse(null);
    }

    public static AlarmChannel queryAlarmChannel() {
        Optional optional = (Optional)AlarmChannelCache.get((Object)0, k -> AlarmDBWrapper.actualQueryAlarmChannel());
        assert (optional != null);
        return optional.orElse(null);
    }

    public static List<AlarmExtEntity> queryByStatId(Integer statId) {
        Optional optional = (Optional)STAT_ALARM_CACHE.get((Object)statId, k -> AlarmDBWrapper.actualQueryByStatId(statId));
        assert (optional != null);
        return optional.orElse(null);
    }

    private static Optional<AlarmExtEntity> actualQueryById(Integer id) {
        AlarmExtEntity alarmExtEntity = null;
        try {
            Alarm alarm = AlarmDBWrapper.queryAlarmFromDB(id);
            alarmExtEntity = AlarmDBWrapper.translate(alarm);
        }
        catch (Exception ex) {
            logger.error("query alarm info error!", (Throwable)ex);
        }
        return Optional.ofNullable(alarmExtEntity);
    }

    private static Optional<AlarmChannel> actualQueryAlarmChannel() {
        AlarmChannel alarmChannel = null;
        try {
            alarmChannel = AlarmDBWrapper.queryAlarmChannelFromDB();
        }
        catch (Exception ex) {
            logger.error("query alarm info error!", (Throwable)ex);
        }
        return Optional.ofNullable(alarmChannel);
    }

    public static AlarmExtEntity translate(Alarm alarm) throws Exception {
        String dimens;
        AlarmTemplate alarmTemplate;
        if (alarm == null) {
            return null;
        }
        AlarmExtEntity alarmExtEntity = new AlarmExtEntity(alarm);
        int templateId = alarm.getTemplateId();
        if (templateId != 0 && (alarmTemplate = AlarmDBWrapper.queryAlarmTemplateFromDB(templateId)) != null) {
            String config = alarmTemplate.getConfig();
            AlarmTemplateExtEntity.AlarmTemplateConfig alarmTemplateConfig = (AlarmTemplateExtEntity.AlarmTemplateConfig)JsonUtil.toJavaObject((String)config, AlarmTemplateExtEntity.AlarmTemplateConfig.class);
            AlarmTemplateExtEntity alarmTemplateExtEntity = new AlarmTemplateExtEntity(alarmTemplate);
            alarmTemplateExtEntity.setTemplateConfig(alarmTemplateConfig);
            alarmExtEntity.setTemplateExtEntity(alarmTemplateExtEntity);
        }
        if (StringUtil.isNotEmpty((String)(dimens = alarmExtEntity.getDimens()))) {
            String[] matchList = dimens.split("\n");
            LinkedHashMap<String, Pattern> dimensMatchMap = new LinkedHashMap<String, Pattern>();
            for (String matchDimens : matchList) {
                if (!StringUtil.isNotEmpty((String)matchDimens)) continue;
                try {
                    Pattern pattern = Pattern.compile(matchDimens);
                    dimensMatchMap.put(matchDimens, pattern);
                }
                catch (Exception ex) {
                    logger.error("regular expression parsing error!", (Throwable)ex);
                    dimensMatchMap.put(matchDimens, null);
                }
            }
            alarmExtEntity.setDimensMatchMap(dimensMatchMap);
        }
        return alarmExtEntity;
    }

    private static Optional<List<AlarmExtEntity>> actualQueryByStatId(Integer statId) {
        ArrayList<AlarmExtEntity> alarmExtEntityList = new ArrayList<AlarmExtEntity>();
        try {
            List<Alarm> alarmList = AlarmDBWrapper.queryAlarmListFromDB(statId);
            if (CollectionUtils.isNotEmpty(alarmList)) {
                for (Alarm alarm : alarmList) {
                    AlarmExtEntity alarmExtEntity = AlarmDBWrapper.translate(alarm);
                    alarmExtEntityList.add(alarmExtEntity);
                }
            }
        }
        catch (Exception ex) {
            logger.error("query alarm info error!", (Throwable)ex);
        }
        return Optional.of(alarmExtEntityList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Alarm queryAlarmFromDB(Integer id) throws Exception {
        Alarm alarm;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            alarm = (Alarm)queryRunner.query(conn, String.format("select `id`,`title`,`unique_code`,`divide`,`state`,`silent`,`match`,`conditions`,`template_id`,`recover`,`delay`,`dimens`,`create_time`,`update_time` from ldp_alarms where id = '%s'", id), (ResultSetHandler)new AlarmSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return alarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Alarm> queryAlarmListFromDB(Integer statId) throws Exception {
        List alarmList;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            alarmList = (List)queryRunner.query(conn, String.format("select `id`,`title`,`unique_code`,`divide`,`state`,`silent`,`match`,`conditions`,`template_id`,`recover`,`delay`,`dimens`,`create_time`,`update_time` from ldp_alarms where resource_id = '%s' and resource_type = '%s'", statId, ResourceTypeEnum.Stat.getResourceType()), (ResultSetHandler)new AlarmListSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return alarmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AlarmTemplate queryAlarmTemplateFromDB(Integer id) throws Exception {
        AlarmTemplate alarmTemplate;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            alarmTemplate = (AlarmTemplate)queryRunner.query(conn, String.format("select `id`,`title`,`config`,`user_ids`,`department_ids`,`create_time`,`update_time` from ldp_alarm_templates where id = '%s'", id), (ResultSetHandler)new AlarmTemplateSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return alarmTemplate;
    }

    private static AlarmChannel queryAlarmChannelFromDB() throws Exception {
        AlarmChannel alarmChannel;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            alarmChannel = (AlarmChannel)queryRunner.query(conn, "select value from ldp_env where param = 'alarm_settings'", (ResultSetHandler)new AlarmChannelSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return alarmChannel;
    }

    private static class AlarmChannelSetHandler
    implements ResultSetHandler<AlarmChannel> {
        private AlarmChannelSetHandler() {
        }

        public AlarmChannel handle(ResultSet resultSet) throws SQLException {
            AlarmSettings settings;
            String alarmSettingsStr;
            AlarmChannel alarmChannel = null;
            if (resultSet.next() && StringUtil.isNotEmpty((String)(alarmSettingsStr = resultSet.getString("value"))) && (settings = (AlarmSettings)JsonUtil.toJavaObject((String)alarmSettingsStr, AlarmSettings.class)) != null) {
                String activeChannel = settings.getActiveChannel();
                alarmChannel = (AlarmChannel)settings.getChannels().get(activeChannel);
            }
            return alarmChannel;
        }
    }

    private static class AlarmTemplateSetHandler
    implements ResultSetHandler<AlarmTemplate> {
        private AlarmTemplateSetHandler() {
        }

        public AlarmTemplate handle(ResultSet rs) throws SQLException {
            AlarmTemplate alarmTemplate = null;
            if (rs.next()) {
                Object departmentIds;
                alarmTemplate = new AlarmTemplate();
                int id = rs.getInt("id");
                String config = rs.getString("config");
                Object userIds = rs.getObject("user_ids");
                if (userIds != null) {
                    List userIdList = JsonUtil.toJavaObjectList((String)userIds.toString(), Integer.class);
                    alarmTemplate.setUserIds(userIdList);
                }
                if ((departmentIds = rs.getObject("department_ids")) != null) {
                    List departmentIdList = JsonUtil.toJavaObjectList((String)departmentIds.toString(), Integer.class);
                    alarmTemplate.setDepartmentIds(departmentIdList);
                }
                alarmTemplate.setId(Integer.valueOf(id));
                alarmTemplate.setConfig(config);
            }
            return alarmTemplate;
        }
    }

    private static class AlarmListSetHandler
    implements ResultSetHandler<List<Alarm>> {
        private AlarmListSetHandler() {
        }

        public List<Alarm> handle(ResultSet rs) throws SQLException {
            ArrayList<Alarm> alarmList = new ArrayList<Alarm>();
            while (rs.next()) {
                Alarm alarm = new Alarm();
                int id = rs.getInt("id");
                String title = rs.getString("title");
                String uniqueCode = rs.getString("unique_code");
                boolean divide = rs.getBoolean("divide");
                boolean state = rs.getBoolean("state");
                int match = rs.getInt("match");
                Integer delay = rs.getInt("delay");
                int silent = rs.getInt("silent");
                String conditions = rs.getString("conditions");
                Integer templateId = rs.getInt("template_id");
                boolean recover = rs.getBoolean("recover");
                String dimens = rs.getString("dimens");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                alarm.setId(Integer.valueOf(id));
                alarm.setTitle(title);
                alarm.setUniqueCode(uniqueCode);
                alarm.setDelay(delay);
                alarm.setDivide(divide);
                alarm.setMatch(AlarmMatchEnum.forValue((int)match));
                alarm.setDimens(dimens);
                alarm.setState(state);
                alarm.setSilent((long)silent);
                List conditionList = JsonUtil.toJavaObjectList((String)conditions, AlarmCondition.class);
                alarm.setConditions(conditionList);
                alarm.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                alarm.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
                alarm.setTemplateId(templateId);
                alarm.setRecover(recover);
                alarmList.add(alarm);
            }
            return alarmList;
        }
    }

    private static class AlarmSetHandler
    implements ResultSetHandler<Alarm> {
        private AlarmSetHandler() {
        }

        public Alarm handle(ResultSet rs) throws SQLException {
            Alarm alarm = null;
            if (rs.next()) {
                alarm = new Alarm();
                int id = rs.getInt("id");
                String title = rs.getString("title");
                String uniqueCode = rs.getString("unique_code");
                boolean divide = rs.getBoolean("divide");
                boolean state = rs.getBoolean("state");
                int match = rs.getInt("match");
                Integer delay = rs.getInt("delay");
                int silent = rs.getInt("silent");
                String conditions = rs.getString("conditions");
                Integer templateId = rs.getInt("template_id");
                boolean recover = rs.getBoolean("recover");
                String dimens = rs.getString("dimens");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                alarm.setId(Integer.valueOf(id));
                alarm.setTitle(title);
                alarm.setUniqueCode(uniqueCode);
                alarm.setDelay(delay);
                alarm.setSilent((long)silent);
                alarm.setDivide(divide);
                alarm.setMatch(AlarmMatchEnum.forValue((int)match));
                alarm.setDimens(dimens);
                alarm.setState(state);
                List conditionList = JsonUtil.toJavaObjectList((String)conditions, AlarmCondition.class);
                alarm.setConditions(conditionList);
                alarm.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                alarm.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
                alarm.setTemplateId(templateId);
                alarm.setRecover(recover);
            }
            return alarm;
        }
    }
}

