/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.modal.Notification;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import java.math.BigInteger;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class NotificationDBWrapper {
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long insert(Notification notification) throws Exception {
        int id;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            ScalarHandler keyHandler = new ScalarHandler();
            BigInteger result = (BigInteger)queryRunner.insert(conn, "INSERT INTO ldp_notifications (`resource_id`, `resource_type`,`content`,`state`,`user_ids`,`department_ids`,`notification_type`,`p1`,`p2`,`p3`,`create_time`,`update_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (ResultSetHandler)keyHandler, new Object[]{notification.getResourceId(), notification.getResourceType().getResourceType(), notification.getContent(), notification.getState().getState(), CollectionUtils.isNotEmpty((Collection)notification.getUserIds()) ? JsonUtil.toJSONString((Object)notification.getUserIds()) : null, CollectionUtils.isNotEmpty((Collection)notification.getDepartmentIds()) ? JsonUtil.toJSONString((Object)notification.getDepartmentIds()) : null, notification.getNotificationType().getType(), notification.getP1(), notification.getP2(), notification.getP3(), notification.getCreateTime(), notification.getUpdateTime()});
            id = result.intValue();
        }
        finally {
            storageEngine.closeConnection();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] batchInsert(List<Notification> notifications) throws Exception {
        int[] result;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        LocalDateTime localDateTime = LocalDateTime.now();
        String sql = "INSERT INTO ldp_notifications (`resource_id`, `resource_type`,`content`,`state`,`user_ids`,`department_ids`,`notification_type`,`p1`,`p2`,`p3`,`create_time`,`update_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Object[][] params = (Object[][])notifications.stream().map(notification -> new Object[]{notification.getResourceId(), notification.getResourceType().getResourceType(), notification.getContent(), notification.getState().getState(), CollectionUtils.isNotEmpty((Collection)notification.getUserIds()) ? JsonUtil.toJSONString((Object)notification.getUserIds()) : null, CollectionUtils.isNotEmpty((Collection)notification.getDepartmentIds()) ? JsonUtil.toJSONString((Object)notification.getDepartmentIds()) : null, notification.getNotificationType().getType(), notification.getP1(), notification.getP2(), notification.getP3(), localDateTime, localDateTime}).toArray(x$0 -> new Object[x$0][]);
        try {
            result = queryRunner.batch(conn, sql, params);
        }
        finally {
            storageEngine.closeConnection();
        }
        return result;
    }
}

