/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.entity.AlarmExtEntity;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.entity.state.StatUnit;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.common.modal.Alarm;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.modal.LimitingParam;
import com.dtstep.lighthouse.common.modal.RenderConfig;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.formula.FormulaTranslate;
import com.dtstep.lighthouse.core.plugins.PluginManager;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.dtstep.lighthouse.core.template.TemplateContext;
import com.dtstep.lighthouse.core.template.TemplateParser;
import com.dtstep.lighthouse.core.wrapper.AlarmDBWrapper;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatDBWrapper {
    private static final Logger logger = LoggerFactory.getLogger(StatDBWrapper.class);
    private static final Integer _CacheExpireMinutes = 3;
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final LoadingCache<Integer, Optional<StatExtEntity>> statCache = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).softValues().maximumSize(500000L).build(StatDBWrapper::actualQueryById);
    private static final LoadingCache<Integer, Optional<List<StatExtEntity>>> groupStatListCache = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(500000L).softValues().build(StatDBWrapper::actualQueryListByGroupId);

    public static StatExtEntity queryById(int statId) {
        return Objects.requireNonNull((Optional)statCache.get((Object)statId)).orElse(null);
    }

    public static Optional<StatExtEntity> actualQueryById(int statId) {
        if (BuiltinLoader.isBuiltinStat(statId)) {
            return Optional.ofNullable(BuiltinLoader.getBuiltinStat(statId));
        }
        StatExtEntity statExtEntity = null;
        try {
            Stat statEntity = StatDBWrapper.queryStatByIdFromDB(statId);
            if (statEntity != null) {
                statExtEntity = StatDBWrapper.combineExtInfo(statEntity, false);
            }
            return Optional.ofNullable(statExtEntity);
        }
        catch (Exception ex) {
            logger.error("query stat info error,id:{}", (Object)statId, (Object)ex);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Stat queryStatByIdFromDB(int statId) throws Exception {
        Stat stat;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            stat = (Stat)queryRunner.query(conn, String.format("select a.*,b.token,b.columns,c.private_type,c.title as project_title from ldp_stats a left join ldp_groups b on a.group_id = b.id left join ldp_projects c on a.project_id = c.id where a.id = '%s'", statId), (ResultSetHandler)new StatResultSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Stat> queryStatByGroupIDFromDB(int groupId) throws Exception {
        List statList;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            statList = (List)queryRunner.query(conn, String.format("select a.*,b.token,b.columns from ldp_stats a left join ldp_groups b on a.group_id = b.id where a.group_id = '%s'", groupId), (ResultSetHandler)new StatResultListHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return statList;
    }

    public static Optional<List<StatExtEntity>> actualQueryListByGroupId(int groupId) throws Exception {
        List<Stat> entityList = StatDBWrapper.queryStatByGroupIDFromDB(groupId);
        if (CollectionUtils.isEmpty(entityList)) {
            return Optional.empty();
        }
        ArrayList extEntityList = new ArrayList();
        entityList.forEach(z -> {
            try {
                StatExtEntity statExtEntity = StatDBWrapper.combineExtInfo(z, false);
                if (statExtEntity != null) {
                    extEntityList.add(statExtEntity);
                }
            }
            catch (Exception ex) {
                logger.error("query stat info error,id:{}", (Object)z.getId(), (Object)ex);
            }
        });
        return Optional.of(extEntityList);
    }

    public static StatExtEntity combineExtInfo(Stat statEntity, boolean isBuiltIn) throws Exception {
        List<Column> dimensRelatedColumns;
        String groupColumns = statEntity.getGroupColumns();
        assert (StringUtil.isNotEmpty((String)groupColumns));
        List groupColumnList = JsonUtil.toJavaObjectList((String)groupColumns, Column.class);
        StatExtEntity statExtEntity = new StatExtEntity(statEntity);
        String timeParam = statExtEntity.getTimeparam();
        String[] timeParamArr = timeParam.split("-");
        statExtEntity.setTimeParamInterval(Integer.parseInt(timeParamArr[0]));
        if ("minute".equals(timeParamArr[1])) {
            statExtEntity.setTimeUnit(TimeUnit.MINUTES);
        } else if ("hour".equals(timeParamArr[1])) {
            statExtEntity.setTimeUnit(TimeUnit.HOURS);
        } else if ("day".equals(timeParamArr[1])) {
            statExtEntity.setTimeUnit(TimeUnit.DAYS);
        } else if ("second".equals(timeParamArr[1])) {
            statExtEntity.setTimeUnit(TimeUnit.SECONDS);
        }
        StatStateEnum stateEnum = statExtEntity.getState();
        if (!isBuiltIn) {
            GroupStateEnum groupStateEnum = GroupDBWrapper.getState(statEntity.getGroupId());
            if (groupStateEnum == GroupStateEnum.LIMITING && stateEnum == StatStateEnum.RUNNING) {
                statExtEntity.setState(StatStateEnum.LIMITING);
            } else if (StatExtEntity.isLimitedExpired((StatExtEntity)statExtEntity)) {
                StatDBWrapper.changeState(statEntity.getId(), StatStateEnum.RUNNING, LocalDateTime.now());
            }
        }
        String template = statExtEntity.getTemplate();
        ServiceResult<TemplateEntity> serviceResult = TemplateParser.parseConfig(new TemplateContext(statEntity.getId(), template, timeParam, groupColumnList));
        if (!serviceResult.isSuccess()) {
            return null;
        }
        TemplateEntity templateEntity = (TemplateEntity)serviceResult.getData();
        statExtEntity.setTemplateEntity(templateEntity);
        ArrayList<Column> relatedColumns = new ArrayList<Column>();
        String stat = templateEntity.getStat();
        List<Column> statRelatedColumns = FormulaTranslate.queryRelatedColumns(groupColumnList, stat);
        if (CollectionUtils.isNotEmpty(statRelatedColumns)) {
            relatedColumns.addAll(statRelatedColumns);
        }
        for (StatState statState : templateEntity.getStatStateList()) {
            ArrayList<Column> stateRelatedColumns = new ArrayList<Column>();
            List unitList = statState.getUnitList();
            if (CollectionUtils.isNotEmpty((Collection)unitList)) {
                int index;
                for (int i = index = StatState.isBitCountState((StatState)statState) ? 1 : 0; i < unitList.size(); ++i) {
                    StatUnit statUnit = (StatUnit)unitList.get(i);
                    List<Column> unitRelatedColumns = FormulaTranslate.queryRelatedColumns(groupColumnList, statUnit.getOrigin());
                    if (!CollectionUtils.isNotEmpty(unitRelatedColumns)) continue;
                    stateRelatedColumns.addAll(unitRelatedColumns);
                }
            }
            statState.setBuiltIn(isBuiltIn);
            statState.setStatId(statExtEntity.getId().intValue());
            statState.setGroupId(statExtEntity.getGroupId().intValue());
            statState.setRelatedColumnSet(stateRelatedColumns.stream().map(Column::getName).collect(Collectors.toSet()));
        }
        String dimens = templateEntity.getDimens();
        if (!StringUtil.isEmpty((String)dimens) && !(dimensRelatedColumns = FormulaTranslate.queryRelatedColumns(groupColumnList, dimens)).isEmpty()) {
            relatedColumns.addAll(dimensRelatedColumns);
        }
        statExtEntity.setRelatedColumnSet(relatedColumns.stream().map(Column::getName).collect(Collectors.toSet()));
        if (PluginManager.getAlarmPlugin().isPresent()) {
            List<AlarmExtEntity> alarmList = AlarmDBWrapper.queryByStatId(statEntity.getId());
            statExtEntity.setAlarmList(alarmList);
            statExtEntity.setNeedAlarm(CollectionUtils.isNotEmpty(alarmList) && alarmList.stream().anyMatch(Alarm::isState));
        }
        return statExtEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int changeState(int statId, StatStateEnum statStateEnum, LocalDateTime date) throws Exception {
        int result;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            if (statStateEnum == StatStateEnum.LIMITING) {
                long startTime = DateUtil.translateToTimeStamp((LocalDateTime)date);
                long endTime = DateUtil.getMinuteAfter((long)startTime, (int)15);
                LimitingParam limitingParam = new LimitingParam();
                limitingParam.setStartTime(startTime);
                limitingParam.setEndTime(endTime);
                result = queryRunner.update(conn, "update ldp_stats set state = ?,refresh_time = ?,limiting_param =? where id = ? and state = ?", new Object[]{statStateEnum.getState(), date, JsonUtil.toJSONString((Object)limitingParam), statId, StatStateEnum.RUNNING.getState()});
            } else {
                result = queryRunner.update(conn, "update ldp_stats set state = ?,refresh_time = ? where id = ?", new Object[]{statStateEnum.getState(), date, statId});
            }
        }
        finally {
            storageEngine.closeConnection();
        }
        return result;
    }

    public static List<StatExtEntity> queryListByGroupId(int groupId) {
        return Objects.requireNonNull((Optional)groupStatListCache.get((Object)groupId)).orElse(null);
    }

    public static List<StatExtEntity> queryRunningListByGroupId(int groupId) {
        List<StatExtEntity> entityList = BuiltinLoader.isBuiltinGroup(groupId) ? BuiltinLoader.getBuiltinStatByGroupId(groupId) : StatDBWrapper.queryListByGroupId(groupId);
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return entityList.stream().filter(x -> x.getState() == StatStateEnum.RUNNING).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RefreshEntity> queryRefreshIdList() throws Exception {
        List ids;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            long time = DateUtil.getMinuteBefore((long)System.currentTimeMillis(), (int)_CacheExpireMinutes);
            ids = (List)queryRunner.query(conn, "select a.id,a.group_id,a.refresh_time,b.token from ldp_stats a inner join ldp_groups b on a.group_id = b.id where a.refresh_time >= ? limit 10000", (ResultSetHandler)new RefreshListSetHandler(), new Object[]{new Date(time)});
        }
        finally {
            storageEngine.closeConnection();
        }
        return ids;
    }

    static {
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("stat-cache-refresh-schedule-pool-%d").daemon(true).build());
        service.scheduleWithFixedDelay(new RefreshThread(), 0L, 20L, TimeUnit.SECONDS);
    }

    static class RefreshThread
    implements Runnable {
        RefreshThread() {
        }

        @Override
        public void run() {
            try {
                List<RefreshEntity> entities = StatDBWrapper.queryRefreshIdList();
                if (CollectionUtils.isNotEmpty(entities)) {
                    for (RefreshEntity refreshEntity : entities) {
                        Optional groupStatCache;
                        Optional statCacheById = (Optional)statCache.getIfPresent((Object)refreshEntity.getId());
                        if (statCacheById != null && ((StatExtEntity)statCacheById.get()).getRefreshTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() < refreshEntity.getRefreshTime()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("clear stat local cache,id:{}", (Object)refreshEntity.getId());
                            }
                            statCache.invalidate((Object)refreshEntity.getId());
                        }
                        if ((groupStatCache = (Optional)groupStatListCache.getIfPresent((Object)refreshEntity.getGroupId())) == null) continue;
                        List statCacheList = (List)groupStatCache.get();
                        List cacheIdList = statCacheList.stream().map(Stat::getId).collect(Collectors.toList());
                        if (!cacheIdList.contains(refreshEntity.getId())) {
                            logger.info("discover new statistic item:{}, clear group:{} cache!", (Object)refreshEntity.getId(), (Object)refreshEntity.getGroupId());
                            groupStatListCache.invalidate((Object)refreshEntity.getGroupId());
                            continue;
                        }
                        List entityList = statCacheList.stream().filter(x -> x.getId().intValue() == refreshEntity.getId().intValue() && x.getRefreshTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() < refreshEntity.getRefreshTime()).collect(Collectors.toList());
                        if (!CollectionUtils.isNotEmpty(entityList)) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("clear group-stats local cache,groupId:{},token:{}", (Object)refreshEntity.getGroupId(), (Object)refreshEntity.getToken());
                        }
                        groupStatListCache.invalidate((Object)refreshEntity.getGroupId());
                    }
                }
            }
            catch (Exception ex) {
                logger.error("statistic group cache refresh error!", (Throwable)ex);
            }
        }
    }

    private static class RefreshListSetHandler
    implements ResultSetHandler<List<RefreshEntity>> {
        private RefreshListSetHandler() {
        }

        public List<RefreshEntity> handle(ResultSet resultSet) throws SQLException {
            ArrayList<RefreshEntity> list = new ArrayList<RefreshEntity>();
            while (resultSet.next()) {
                Integer id = resultSet.getInt("id");
                Integer groupId = resultSet.getInt("group_id");
                long refreshTime = resultSet.getTimestamp("refresh_time").getTime();
                String token = resultSet.getString("token");
                list.add(new RefreshEntity(id, groupId, token, refreshTime));
            }
            return list;
        }
    }

    private static class RefreshEntity {
        private Integer id;
        private Integer groupId;
        private String token;
        private Long refreshTime;

        public RefreshEntity(Integer id, Integer groupId, String token, Long refreshTime) {
            this.id = id;
            this.token = token;
            this.groupId = groupId;
            this.refreshTime = refreshTime;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Long getRefreshTime() {
            return this.refreshTime;
        }

        public void setRefreshTime(Long refreshTime) {
            this.refreshTime = refreshTime;
        }

        public Integer getGroupId() {
            return this.groupId;
        }

        public void setGroupId(Integer groupId) {
            this.groupId = groupId;
        }
    }

    private static class StatResultSetHandler
    implements ResultSetHandler<Stat> {
        private StatResultSetHandler() {
        }

        public Stat handle(ResultSet rs) throws SQLException {
            Stat stat = null;
            if (rs.next()) {
                String limitingParam;
                stat = new Stat();
                Integer id = rs.getInt("id");
                String title = rs.getString("title");
                Integer groupId = rs.getInt("group_id");
                Integer projectId = rs.getInt("project_id");
                String token = rs.getString("token");
                String template = rs.getString("template");
                String timeparam = rs.getString("timeparam");
                Integer dataVersion = rs.getInt("data_version");
                Long expired = rs.getLong("expired");
                int state = rs.getInt("state");
                String renderConfig = rs.getString("render_config");
                if (StringUtil.isNotEmpty((String)renderConfig)) {
                    stat.setRenderConfig((RenderConfig)JsonUtil.toJavaObject((String)renderConfig, RenderConfig.class));
                }
                if (StringUtil.isNotEmpty((String)(limitingParam = rs.getString("limiting_param")))) {
                    LimitingParam statLimitingParam = (LimitingParam)JsonUtil.toJavaObject((String)limitingParam, LimitingParam.class);
                    stat.setLimitingParam(statLimitingParam);
                }
                int privateType = rs.getInt("private_type");
                String projectTitle = rs.getString("project_title");
                Integer metaId = rs.getInt("meta_id");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                long refreshTime = rs.getTimestamp("refresh_time").getTime();
                String randomId = rs.getString("random_id");
                String columns = rs.getString("columns");
                stat.setId(id);
                stat.setTitle(title);
                stat.setGroupId(groupId);
                stat.setProjectId(projectId);
                stat.setToken(token);
                stat.setTemplate(template);
                stat.setTimeparam(timeparam);
                stat.setExpired(expired);
                stat.setProjectTitle(projectTitle);
                StatStateEnum statStateEnum = StatStateEnum.getByState((int)state);
                stat.setState(statStateEnum);
                stat.setPrivateType(PrivateTypeEnum.forValue((int)privateType));
                stat.setMetaId(metaId);
                stat.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                stat.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
                stat.setRefreshTime(DateUtil.timestampToLocalDateTime((long)refreshTime));
                stat.setRandomId(randomId);
                stat.setGroupColumns(columns);
                stat.setDataVersion(dataVersion);
            }
            return stat;
        }
    }

    private static class StatResultListHandler
    implements ResultSetHandler<List<Stat>> {
        private StatResultListHandler() {
        }

        public List<Stat> handle(ResultSet rs) throws SQLException {
            ArrayList<Stat> statList = new ArrayList<Stat>();
            while (rs.next()) {
                String limitingParam;
                Stat stat = new Stat();
                Integer id = rs.getInt("id");
                String title = rs.getString("title");
                Integer groupId = rs.getInt("group_id");
                Integer projectId = rs.getInt("project_id");
                Integer dataVersion = rs.getInt("data_version");
                String template = rs.getString("template");
                String timeparam = rs.getString("timeparam");
                Long expired = rs.getLong("expired");
                int state = rs.getInt("state");
                String renderConfig = rs.getString("render_config");
                if (StringUtil.isNotEmpty((String)renderConfig)) {
                    stat.setRenderConfig((RenderConfig)JsonUtil.toJavaObject((String)renderConfig, RenderConfig.class));
                }
                if (StringUtil.isNotEmpty((String)(limitingParam = rs.getString("limiting_param")))) {
                    LimitingParam statLimitingParam = (LimitingParam)JsonUtil.toJavaObject((String)limitingParam, LimitingParam.class);
                    stat.setLimitingParam(statLimitingParam);
                }
                Integer metaId = rs.getInt("meta_id");
                long createTime = rs.getTimestamp("create_time").getTime();
                long updateTime = rs.getTimestamp("update_time").getTime();
                long refreshTime = rs.getTimestamp("refresh_time").getTime();
                String randomId = rs.getString("random_id");
                String columns = rs.getString("columns");
                stat.setId(id);
                stat.setTitle(title);
                stat.setGroupId(groupId);
                stat.setProjectId(projectId);
                stat.setTemplate(template);
                stat.setTimeparam(timeparam);
                stat.setDataVersion(dataVersion);
                stat.setExpired(expired);
                StatStateEnum statStateEnum = StatStateEnum.getByState((int)state);
                stat.setState(statStateEnum);
                stat.setMetaId(metaId);
                stat.setCreateTime(DateUtil.timestampToLocalDateTime((long)createTime));
                stat.setUpdateTime(DateUtil.timestampToLocalDateTime((long)updateTime));
                stat.setRefreshTime(DateUtil.timestampToLocalDateTime((long)refreshTime));
                stat.setRandomId(randomId);
                stat.setGroupColumns(columns);
                statList.add(stat);
            }
            return statList;
        }
    }
}

