/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.wrapper;

import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDBWrapper {
    private static final CMDBStorageEngine<Connection> storageEngine = CMDBStorageEngineProxy.getInstance();
    private static final Integer _CacheExpireMinutes = 10;
    private static final Logger logger = LoggerFactory.getLogger(UserDBWrapper.class);
    private static final Cache<Integer, Optional<List<Integer>>> DEPARTMENT_USER_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100000L).softValues().build();
    private static final Cache<Integer, Optional<List<Integer>>> USER_ROLE_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100000L).softValues().build();
    private static final Cache<Integer, Optional<User>> USER_CACHE = Caffeine.newBuilder().expireAfterWrite((long)_CacheExpireMinutes.intValue(), TimeUnit.MINUTES).maximumSize(100000L).softValues().build();

    public static List<Integer> queryUseIdListByDepartment(Integer departmentId) {
        Optional optional = (Optional)DEPARTMENT_USER_CACHE.get((Object)departmentId, k -> UserDBWrapper.actualQueryUserIdListByDepartment(departmentId));
        assert (optional != null);
        return optional.orElse(null);
    }

    public static List<Integer> queryUserIdListByRoleId(Integer roleId) {
        Optional optional = (Optional)USER_ROLE_CACHE.get((Object)roleId, k -> UserDBWrapper.actualQueryUserIdListByRoleId(roleId));
        assert (optional != null);
        return optional.orElse(null);
    }

    public static User queryById(Integer userId) {
        Optional optional = (Optional)USER_CACHE.get((Object)userId, k -> UserDBWrapper.actualQueryUserById(userId));
        assert (optional != null);
        return optional.orElse(null);
    }

    private static Optional<List<Integer>> actualQueryUserIdListByDepartment(Integer departmentId) {
        List<Integer> userIdList = null;
        try {
            userIdList = UserDBWrapper.queryUserIdListByDepartmentFromDB(departmentId);
        }
        catch (Exception ex) {
            logger.error("query caller info error!", (Throwable)ex);
        }
        return Optional.ofNullable(userIdList);
    }

    private static Optional<List<Integer>> actualQueryUserIdListByRoleId(Integer roleId) {
        List<Integer> userIdList = null;
        try {
            userIdList = UserDBWrapper.queryUserIdListByRoleFromDB(roleId);
        }
        catch (Exception ex) {
            logger.error("query caller info error!", (Throwable)ex);
        }
        return Optional.ofNullable(userIdList);
    }

    private static Optional<User> actualQueryUserById(Integer userId) {
        User user = null;
        try {
            user = UserDBWrapper.queryUserFromDB(userId);
        }
        catch (Exception ex) {
            logger.error("query user info error!", (Throwable)ex);
        }
        return Optional.ofNullable(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User queryUserFromDB(Integer userId) throws Exception {
        User user;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            user = (User)queryRunner.query(conn, String.format("select id,username,phone,email,state from ldp_users where id = '%s'", userId), (ResultSetHandler)new UserSetHandler());
        }
        finally {
            storageEngine.closeConnection();
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> queryUserIdListByRoleFromDB(Integer roleId) throws Exception {
        List userIds;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            String sql = "select owner_id from ldp_permissions where owner_type = '1' and role_id = ? limit 100";
            userIds = (List)queryRunner.query(conn, sql, (ResultSetHandler)new ColumnListHandler(), new Object[]{roleId});
        }
        finally {
            storageEngine.closeConnection();
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> queryUserIdListByDepartmentFromDB(Integer departmentId) throws Exception {
        List userIds;
        Connection conn = storageEngine.getConnection();
        QueryRunner queryRunner = new QueryRunner();
        try {
            String sql = "WITH RECURSIVE sub_departments AS (  SELECT id FROM ldp_departments WHERE id = ?   UNION ALL   SELECT d.id FROM ldp_departments d   INNER JOIN sub_departments sd ON d.pid = sd.id ) SELECT u.id AS user_id FROM ldp_users u WHERE u.`state` = 2 and u.department_id IN (SELECT id FROM sub_departments) limit 100";
            userIds = (List)queryRunner.query(conn, sql, (ResultSetHandler)new ColumnListHandler(), new Object[]{departmentId});
        }
        finally {
            storageEngine.closeConnection();
        }
        return userIds;
    }

    private static class UserSetHandler
    implements ResultSetHandler<User> {
        private UserSetHandler() {
        }

        public User handle(ResultSet rs) throws SQLException {
            User user = null;
            if (rs.next()) {
                user = new User();
                int id = rs.getInt("id");
                String username = rs.getString("username");
                String phone = rs.getString("phone");
                String email = rs.getString("email");
                int state = rs.getInt("state");
                user.setId(Integer.valueOf(id));
                user.setUsername(username);
                user.setPhone(phone);
                user.setEmail(email);
                user.setState(UserStateEnum.forValue((int)state));
            }
            return user;
        }
    }
}

