/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.CellSortReducer;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.MultiTableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MapReduceExtendedCell;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class WALPlayer
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(WALPlayer.class);
    static final String NAME = "WALPlayer";
    public static final String BULK_OUTPUT_CONF_KEY = "wal.bulk.output";
    public static final String TABLES_KEY = "wal.input.tables";
    public static final String TABLE_MAP_KEY = "wal.input.tablesmap";
    public static final String INPUT_FILES_SEPARATOR_KEY = "wal.input.separator";
    public static final String IGNORE_MISSING_FILES = "wal.input.ignore.missing.files";
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";

    public WALPlayer() {
    }

    protected WALPlayer(Configuration c) {
        super(c);
    }

    void setupTime(Configuration conf, String option) throws IOException {
        long ms;
        String val = conf.get(option);
        if (null == val) {
            return;
        }
        try {
            ms = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS").parse(val).getTime();
        }
        catch (ParseException pe) {
            try {
                ms = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(option + " must be specified either in the form 2001-02-20T16:35:06.99 or as number of milliseconds");
            }
        }
        conf.setLong(option, ms);
    }

    public Job createSubmittableJob(String[] args) throws IOException {
        String[] tableMap;
        String[] tables;
        Configuration conf = this.getConf();
        this.setupTime(conf, "wal.start.time");
        this.setupTime(conf, "wal.end.time");
        String inputDirs = args[0];
        String[] stringArray = tables = args.length == 1 ? new String[]{} : args[1].split(",");
        if (args.length > 2) {
            tableMap = args[2].split(",");
            if (tableMap.length != tables.length) {
                throw new IOException("The same number of tables and mapping must be provided.");
            }
        } else {
            tableMap = tables;
        }
        conf.setStrings(TABLES_KEY, tables);
        conf.setStrings(TABLE_MAP_KEY, tableMap);
        conf.set("mapreduce.input.fileinputformat.inputdir", inputDirs);
        Job job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "WALPlayer_" + EnvironmentEdgeManager.currentTime()));
        job.setJarByClass(WALPlayer.class);
        job.setInputFormatClass(WALInputFormat.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
        if (hfileOutPath != null) {
            LOG.debug("add incremental job :" + hfileOutPath + " from " + inputDirs);
            if (tables.length != 1) {
                throw new IOException("Exactly one table must be specified for the bulk export option");
            }
            TableName tableName = TableName.valueOf((String)tables[0]);
            job.setMapperClass(WALCellMapper.class);
            job.setReducerClass(CellSortReducer.class);
            Path outputDir = new Path(hfileOutPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
            job.setMapOutputValueClass(MapReduceExtendedCell.class);
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 Table table = conn.getTable(tableName);
                 RegionLocator regionLocator = conn.getRegionLocator(tableName);){
                HFileOutputFormat2.configureIncrementalLoad(job, table.getDescriptor(), regionLocator);
            }
            TableMapReduceUtil.addDependencyJarsForClasses(job.getConfiguration(), Preconditions.class);
        } else {
            job.setMapperClass(WALMapper.class);
            job.setOutputFormatClass(MultiTableOutputFormat.class);
            TableMapReduceUtil.addDependencyJars(job);
            TableMapReduceUtil.initCredentials(job);
            job.setNumReduceTasks(0);
        }
        String codecCls = WALCellCodec.getWALCellCodecClass((Configuration)conf).getName();
        try {
            TableMapReduceUtil.addDependencyJarsForClasses(job.getConfiguration(), Class.forName(codecCls));
        }
        catch (Exception e) {
            throw new IOException("Cannot determine wal codec class " + codecCls, e);
        }
        return job;
    }

    private void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: WALPlayer [options] <WAL inputdir> [<tables> <tableMappings>]");
        System.err.println(" <WAL inputdir>   directory of WALs to replay.");
        System.err.println(" <tables>         comma separated list of tables. If no tables specified,");
        System.err.println("                  all are imported (even hbase:meta if present).");
        System.err.println(" <tableMappings>  WAL entries can be mapped to a new set of tables by passing");
        System.err.println("                  <tableMappings>, a comma separated list of target tables.");
        System.err.println("                  If specified, each table in <tables> must have a mapping.");
        System.err.println("To generate HFiles to bulk load instead of loading HBase directly, pass:");
        System.err.println(" -Dwal.bulk.output=/path/for/output");
        System.err.println(" Only one table can be specified, and no mapping allowed!");
        System.err.println("To specify a time range, pass:");
        System.err.println(" -Dwal.start.time=[date|ms]");
        System.err.println(" -Dwal.end.time=[date|ms]");
        System.err.println(" The start and the end date of timerange (inclusive). The dates can be");
        System.err.println(" expressed in milliseconds-since-epoch or yyyy-MM-dd'T'HH:mm:ss.SS format.");
        System.err.println(" E.g. 1234567890120 or 2009-02-13T23:32:30.12");
        System.err.println("Other options:");
        System.err.println(" -Dmapreduce.job.name=jobName");
        System.err.println(" Use the specified mapreduce job name for the wal player");
        System.err.println(" -Dwal.input.separator=' '");
        System.err.println(" Change WAL filename separator (WAL dir names use default ','.)");
        System.err.println("For performance also consider the following options:\n  -Dmapreduce.map.speculative=false\n  -Dmapreduce.reduce.speculative=false");
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new WALPlayer(HBaseConfiguration.create()), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        Job job;
        if (args.length < 1) {
            this.usage("Wrong number of arguments: " + args.length);
            System.exit(-1);
        }
        return (job = this.createSubmittableJob(args)).waitForCompletion(true) ? 0 : 1;
    }

    protected static class WALMapper
    extends Mapper<WALKey, WALEdit, ImmutableBytesWritable, Mutation> {
        private Map<TableName, TableName> tables = new TreeMap<TableName, TableName>();

        protected WALMapper() {
        }

        public void map(WALKey key, WALEdit value, Mapper.Context context) throws IOException {
            context.getCounter((Enum)Counter.WALEDITS).increment(1L);
            try {
                if (this.tables.isEmpty() || this.tables.containsKey(key.getTableName())) {
                    TableName targetTable = this.tables.isEmpty() ? key.getTableName() : this.tables.get(key.getTableName());
                    ImmutableBytesWritable tableOut = new ImmutableBytesWritable(targetTable.getName());
                    Put put = null;
                    Delete del = null;
                    Cell lastCell = null;
                    for (Cell cell : value.getCells()) {
                        context.getCounter((Enum)Counter.CELLS_READ).increment(1L);
                        if (WALEdit.isMetaEditFamily((Cell)cell)) continue;
                        if (this.filter(context, cell)) {
                            if (lastCell == null || lastCell.getTypeByte() != cell.getTypeByte() || !CellUtil.matchingRows((Cell)lastCell, (Cell)cell)) {
                                if (put != null) {
                                    context.write((Object)tableOut, put);
                                    context.getCounter((Enum)Counter.PUTS).increment(1L);
                                }
                                if (del != null) {
                                    context.write((Object)tableOut, del);
                                    context.getCounter((Enum)Counter.DELETES).increment(1L);
                                }
                                if (CellUtil.isDelete((Cell)cell)) {
                                    del = new Delete(CellUtil.cloneRow((Cell)cell));
                                } else {
                                    put = new Put(CellUtil.cloneRow((Cell)cell));
                                }
                            }
                            if (CellUtil.isDelete((Cell)cell)) {
                                del.add(cell);
                            } else {
                                put.add(cell);
                            }
                            context.getCounter((Enum)Counter.CELLS_WRITTEN).increment(1L);
                        }
                        lastCell = cell;
                    }
                    if (put != null) {
                        context.write((Object)tableOut, put);
                        context.getCounter((Enum)Counter.PUTS).increment(1L);
                    }
                    if (del != null) {
                        context.getCounter((Enum)Counter.DELETES).increment(1L);
                        context.write((Object)tableOut, del);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        protected boolean filter(Mapper.Context context, Cell cell) {
            return true;
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            super.cleanup(context);
        }

        public void setup(Mapper.Context context) throws IOException {
            String[] tableMap = context.getConfiguration().getStrings(WALPlayer.TABLE_MAP_KEY);
            String[] tablesToUse = context.getConfiguration().getStrings(WALPlayer.TABLES_KEY);
            if (tableMap == null) {
                tableMap = tablesToUse;
            }
            if (tablesToUse != null && tablesToUse.length != tableMap.length) {
                throw new IOException("Incorrect table mapping specified .");
            }
            int i = 0;
            if (tablesToUse != null) {
                for (String table : tablesToUse) {
                    this.tables.put(TableName.valueOf((String)table), TableName.valueOf((String)tableMap[i++]));
                }
            }
        }
    }

    protected static enum Counter {
        PUTS,
        DELETES,
        CELLS_READ,
        CELLS_WRITTEN,
        WALEDITS;

    }

    static class WALCellMapper
    extends Mapper<WALKey, WALEdit, ImmutableBytesWritable, Cell> {
        private byte[] table;

        WALCellMapper() {
        }

        public void map(WALKey key, WALEdit value, Mapper.Context context) throws IOException {
            try {
                if (Bytes.equals((byte[])this.table, (byte[])key.getTableName().getName())) {
                    for (Cell cell : value.getCells()) {
                        if (WALEdit.isMetaEditFamily((Cell)cell)) continue;
                        context.write((Object)new ImmutableBytesWritable(CellUtil.cloneRow((Cell)cell)), (Object)new MapReduceExtendedCell(cell));
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setup(Mapper.Context context) throws IOException {
            String[] tables = context.getConfiguration().getStrings(WALPlayer.TABLES_KEY);
            if (tables == null || tables.length != 1) {
                throw new IOException("Exactly one table must be specified for bulk HFile case.");
            }
            this.table = Bytes.toBytes((String)tables[0]);
        }
    }

    @Deprecated
    static class WALKeyValueMapper
    extends Mapper<WALKey, WALEdit, ImmutableBytesWritable, KeyValue> {
        private byte[] table;

        WALKeyValueMapper() {
        }

        public void map(WALKey key, WALEdit value, Mapper.Context context) throws IOException {
            try {
                if (Bytes.equals((byte[])this.table, (byte[])key.getTableName().getName())) {
                    for (Cell cell : value.getCells()) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (WALEdit.isMetaEditFamily((Cell)kv)) continue;
                        context.write((Object)new ImmutableBytesWritable(CellUtil.cloneRow((Cell)kv)), (Object)kv);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setup(Mapper.Context context) throws IOException {
            String[] tables = context.getConfiguration().getStrings(WALPlayer.TABLES_KEY);
            if (tables == null || tables.length != 1) {
                throw new IOException("Exactly one table must be specified for bulk HFile case.");
            }
            this.table = Bytes.toBytes((String)tables[0]);
        }
    }
}

