/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.ice.servant.rpc.ice;

import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.StatVerifyEntity;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.ice.LightRpcException;
import com.dtstep.lighthouse.common.ice.RemoteLightServer;
import com.dtstep.lighthouse.common.serializer.SerializerProxy;
import com.dtstep.lighthouse.core.builtin.CallerStat;
import com.dtstep.lighthouse.core.ipc.RPCServer;
import com.dtstep.lighthouse.core.ipc.impl.RPCServerImpl;
import com.dtstep.lighthouse.core.tools.ObjectSize;
import com.zeroc.Ice.Current;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICERemoteLightServerImpl
implements RemoteLightServer {
    private static final Logger logger = LoggerFactory.getLogger(ICERemoteLightServerImpl.class);
    private static final RPCServer rpc = new RPCServerImpl();

    public byte[] process(byte[] message, Current current) throws LightRpcException {
        try {
            rpc.process(message);
        }
        catch (Exception ex) {
            logger.error("process message error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
        return null;
    }

    public byte[] queryGroupInfo(String token, Current current) throws LightRpcException {
        GroupVerifyEntity groupVerifyEntity;
        try {
            groupVerifyEntity = rpc.queryGroupInfo(token);
        }
        catch (Exception ex) {
            logger.error("query group info error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
        if (groupVerifyEntity == null) {
            return null;
        }
        try {
            return SerializerProxy.instance().serialize((Object)groupVerifyEntity);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] queryStatInfo(int id, Current current) throws LightRpcException {
        StatVerifyEntity statVerifyEntity;
        try {
            statVerifyEntity = rpc.queryStatInfo(id);
        }
        catch (Exception ex) {
            logger.error("query stat info error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
        if (statVerifyEntity == null) {
            return null;
        }
        try {
            return SerializerProxy.instance().serialize((Object)statVerifyEntity);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataQuery(int statId, String dimensValue, List<Long> batchList, Current current) throws LightRpcException {
        List statValues;
        try {
            statValues = rpc.dataQuery(statId, dimensValue, batchList);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataDurationQuery(int statId, String dimensValue, long startTime, long endTime, Current current) throws LightRpcException {
        List statValues;
        try {
            statValues = rpc.dataDurationQuery(statId, dimensValue, startTime, endTime);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataQueryWithDimensList(int statId, List<String> dimensValueList, List<Long> batchList, Current current) throws LightRpcException {
        Map statValues;
        try {
            statValues = rpc.dataQueryWithDimensList(statId, dimensValueList, batchList);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataDurationQueryWithDimensList(int statId, List<String> dimensValueList, long startTime, long endTime, Current current) throws LightRpcException {
        Map statValues;
        try {
            statValues = rpc.dataDurationQueryWithDimensList(statId, dimensValueList, startTime, endTime);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] limitQuery(int statId, long batchTime, Current current) throws LightRpcException {
        List limitValues;
        try {
            limitValues = rpc.limitQuery(statId, batchTime);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)limitValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataDurationQueryV2(String callerName, String callerKey, int statId, String dimensValue, long startTime, long endTime, Current current) throws LightRpcException {
        List statValues;
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey);
        long outBytes = 0L;
        try {
            statValues = rpc.dataDurationQuery(statId, dimensValue, startTime, endTime);
            outBytes = ObjectSize.getObjectSize((Object)statValues);
            CallerStat.stat((int)callerId, (String)"dataDurationQuery", (int)1, (Long)inBytes, (Long)outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataDurationQuery", (int)1, (Long)inBytes, (Long)outBytes);
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataQueryV2(String callerName, String callerKey, int statId, String dimensValue, List<Long> batchList, Current current) throws LightRpcException {
        List statValues;
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey);
        long outBytes = 0L;
        try {
            statValues = rpc.dataQuery(statId, dimensValue, batchList);
            outBytes = ObjectSize.getObjectSize((Object)statValues);
            CallerStat.stat((int)callerId, (String)"dataQuery", (int)1, (Long)inBytes, (Long)outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataQuery", (int)1, (Long)inBytes, (Long)outBytes);
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataDurationQueryWithDimensListV2(String callerName, String callerKey, int statId, List<String> dimensValueList, long startTime, long endTime, Current current) throws LightRpcException {
        Map statValues;
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey);
        long outBytes = 0L;
        try {
            statValues = rpc.dataDurationQueryWithDimensList(statId, dimensValueList, startTime, endTime);
            outBytes = ObjectSize.getObjectSize((Object)statValues);
            CallerStat.stat((int)callerId, (String)"dataDurationQueryWithDimensList", (int)1, (Long)inBytes, (Long)outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataDurationQueryWithDimensList", (int)1, (Long)inBytes, (Long)outBytes);
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] dataQueryWithDimensListV2(String callerName, String callerKey, int statId, List<String> dimensValueList, List<Long> batchList, Current current) throws LightRpcException {
        Map statValues;
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey);
        long outBytes = 0L;
        try {
            statValues = rpc.dataQueryWithDimensList(statId, dimensValueList, batchList);
            outBytes = ObjectSize.getObjectSize((Object)statValues);
            CallerStat.stat((int)callerId, (String)"dataQueryWithDimensList", (int)1, (Long)inBytes, (Long)outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataQueryWithDimensList", (int)1, (Long)inBytes, (Long)outBytes);
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)statValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public byte[] limitQueryV2(String callerName, String callerKey, int statId, long batchTime, Current current) throws LightRpcException {
        List limitValues;
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException(ex.getMessage());
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey);
        long outBytes = 0L;
        try {
            limitValues = rpc.limitQuery(statId, batchTime);
            outBytes = ObjectSize.getObjectSize((Object)limitValues);
            CallerStat.stat((int)callerId, (String)"limitQuery", (int)1, (Long)inBytes, (Long)outBytes);
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"limitQuery", (int)1, (Long)inBytes, (Long)outBytes);
            throw new LightRpcException(ex.getMessage());
        }
        try {
            return SerializerProxy.instance().serialize((Object)limitValues);
        }
        catch (Exception ex) {
            logger.error("rpc response serialize error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }
}

