/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.insights.config.SeedAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class DefaultAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication.getClass() == SeedAuthenticationToken.class) {
            return new SeedAuthenticationToken(((SeedAuthenticationToken)authentication).getUserId(), ((SeedAuthenticationToken)authentication).getSeed());
        }
        String username = String.valueOf(authentication.getPrincipal());
        String password = String.valueOf(authentication.getCredentials());
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        if (userDetails != null && this.passwordEncoder.matches((CharSequence)password, userDetails.getPassword())) {
            return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, userDetails.getAuthorities());
        }
        throw new BadCredentialsException("Authentication Error!");
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.equals(authentication) || SeedAuthenticationToken.class.equals(authentication);
    }
}

