/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.insights.config.RepeatableRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RepeatableRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public RepeatableRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.body = this.getRequestBodyBytes(request);
    }

    private byte[] getRequestBodyBytes(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (ServletInputStream inputStream = request.getInputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        return result.toByteArray();
    }

    public ServletInputStream getInputStream() {
        return new ServletInputStreamWrapper(this.body);
    }

    public BufferedReader getReader() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new BufferedReader(new InputStreamReader((InputStream)inputStream, this.getCharacterEncoding()));
    }
}

