/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.insights.config.RepeatableResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class RepeatableResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream cachedOutputStream = new ByteArrayOutputStream();
    private PrintWriter cachedWriter;
    private ServletOutputStream cachedServletOutputStream;

    public RepeatableResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.cachedServletOutputStream == null) {
            this.cachedServletOutputStream = new CachedServletOutputStream(this.cachedOutputStream);
        }
        return this.cachedServletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.cachedWriter == null) {
            this.cachedWriter = new PrintWriter(this.cachedOutputStream);
        }
        return this.cachedWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.cachedWriter != null) {
            this.cachedWriter.flush();
        }
        if (this.cachedServletOutputStream != null) {
            this.cachedServletOutputStream.flush();
        }
        super.flushBuffer();
    }

    public byte[] getContentAsByteArray() throws IOException {
        this.flushBuffer();
        return this.cachedOutputStream.toByteArray();
    }
}

