/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.OrderTypeEnum;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.insights.dto.ApplyOrderQueryParam;
import com.dtstep.lighthouse.insights.dto.OrderCreateParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.OrderService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.OrderVO;
import com.dtstep.lighthouse.insights.vo.ResourceVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class ApplyController {
    private static final Logger logger = LoggerFactory.getLogger(ApplyController.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserService userService;
    @Autowired
    private BaseService baseService;

    @RequestMapping(value={"/apply/create"})
    public ResultData<Integer> create(@Validated @RequestBody OrderCreateParam createParam) throws Exception {
        ResultCode resultCode;
        int currentUserId = this.baseService.getCurrentUserId();
        Validate.isTrue((currentUserId == createParam.getUserId() ? 1 : 0) != 0);
        User user = this.userService.queryById(currentUserId);
        if (createParam.getOrderType() == OrderTypeEnum.VIEW_ACCESS) {
            resultCode = this.orderService.submit(user, createParam.getOrderType(), createParam.getReason(), createParam.getExtendConfig());
            Map extendConfig = createParam.getExtendConfig();
            if (extendConfig.containsKey("resources")) {
                List resourceVOList = JsonUtil.toJavaObjectList((String)JsonUtil.toJSONString(extendConfig.get("resources")), ResourceVO.class);
                Validate.notNull((Object)resourceVOList);
                for (ResourceVO resourceVO : resourceVOList) {
                    HashMap<String, Integer> extendMap = new HashMap<String, Integer>();
                    extendMap.put("statId", resourceVO.getResourceId());
                    resultCode = this.orderService.submit(user, OrderTypeEnum.STAT_ACCESS, createParam.getReason(), extendMap);
                    if (resultCode == ResultCode.success) continue;
                    break;
                }
            }
        } else {
            resultCode = this.orderService.submit(user, createParam.getOrderType(), createParam.getReason(), createParam.getExtendConfig());
        }
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/apply/list"})
    public ResultData<ListData<OrderVO>> list(@Validated @RequestBody ListSearchObject<ApplyOrderQueryParam> searchObject) {
        ApplyOrderQueryParam queryParam = (ApplyOrderQueryParam)searchObject.getQueryParamOrDefault((Object)new ApplyOrderQueryParam());
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.orderService.queryApplyList(queryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }
}

