/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.modal.CommonTreeNode;
import com.dtstep.lighthouse.common.modal.Component;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.insights.dto.ComponentCreateParam;
import com.dtstep.lighthouse.insights.dto.ComponentQueryParam;
import com.dtstep.lighthouse.insights.dto.ComponentUpdateParam;
import com.dtstep.lighthouse.insights.dto.ComponentVerifyParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.ComponentService;
import com.dtstep.lighthouse.insights.vo.ComponentVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class ComponentController {
    @Autowired
    private ComponentService componentService;
    @Autowired
    private BaseService baseService;

    @RequestMapping(value={"/component/verify"})
    public ResultData<List<CommonTreeNode>> verify(@Validated @RequestBody ComponentVerifyParam verifyParam) {
        ResultCode resultCode = this.componentService.verify(verifyParam.getConfiguration());
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/component/create"})
    public ResultData<Integer> create(@Validated @RequestBody ComponentCreateParam createParam) {
        ResultCode resultCode = this.componentService.verify(createParam.getConfiguration());
        if (resultCode != ResultCode.success) {
            return ResultData.result((ResultCode)resultCode);
        }
        Component component = new Component();
        component.setComponentType(createParam.getComponentType());
        component.setPrivateType(createParam.getPrivateType());
        component.setConfiguration(JsonUtil.toJavaObjectList((String)createParam.getConfiguration(), TreeNode.class));
        component.setTitle(createParam.getTitle());
        Integer userId = this.baseService.getCurrentUserId();
        component.setUserId(userId);
        int result = this.componentService.create(component);
        if (result > 0) {
            return ResultData.success();
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/component/update"})
    public ResultData<Integer> update(@Validated @RequestBody ComponentUpdateParam createParam) {
        ResultCode resultCode = this.componentService.verify(createParam.getConfiguration());
        if (resultCode != ResultCode.success) {
            return ResultData.result((ResultCode)resultCode);
        }
        Component component = new Component();
        component.setId(createParam.getId());
        component.setComponentType(createParam.getComponentType());
        component.setPrivateType(createParam.getPrivateType());
        component.setConfiguration(JsonUtil.toJavaObjectList((String)createParam.getConfiguration(), TreeNode.class));
        component.setTitle(createParam.getTitle());
        Integer userId = this.baseService.getCurrentUserId();
        component.setUserId(userId);
        int result = this.componentService.update(component);
        if (result > 0) {
            return ResultData.success();
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/component/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        Component component = this.componentService.queryById(id);
        Validate.notNull((Object)component);
        int result = this.componentService.delete(component);
        if (result > 0) {
            return ResultData.success();
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @PostMapping(value={"/component/list"})
    public ResultData<ListData<ComponentVO>> queryList(@Validated @RequestBody ListSearchObject<ComponentQueryParam> searchObject) {
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.componentService.queryList((ComponentQueryParam)searchObject.getQueryParams(), Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }
}

