/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.UserQueryParam;
import com.dtstep.lighthouse.insights.service.DepartmentService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.ResultData;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class DepartmentController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/department/structure"})
    public ResultData<List<TreeNode>> all() {
        List list = this.departmentService.getStructure();
        return ResultData.success((Object)list);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/department/create"})
    public ResultData<Integer> create(@Validated @RequestBody Department createParam) {
        int level = this.departmentService.getLevel(createParam.getPid());
        if (level >= 4) {
            return ResultData.result((ResultCode)ResultCode.departCreateErrorLevelLimit);
        }
        int result = this.departmentService.create(createParam);
        return ResultData.success((Object)result);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/department/updateById"})
    public ResultData<Integer> updateById(@Validated @RequestBody Department updateParam) {
        int childLevel;
        int pidLevel = this.departmentService.getLevel(updateParam.getPid());
        if (pidLevel + (childLevel = this.departmentService.getChildLevel(updateParam.getId())) >= 4) {
            return ResultData.result((ResultCode)ResultCode.departCreateErrorLevelLimit);
        }
        int id = this.departmentService.update(updateParam);
        if (id > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/department/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        Department department = this.departmentService.queryById(id);
        Validate.notNull((Object)department);
        int childSize = this.departmentService.countChildByPid(id);
        if (childSize > 0) {
            return ResultData.result((ResultCode)ResultCode.departDelErrorChildExist);
        }
        UserQueryParam userQueryParam = new UserQueryParam();
        userQueryParam.setDepartmentIds(List.of(department.getId()));
        int userSize = this.userService.count(userQueryParam);
        if (userSize > 0) {
            return ResultData.result((ResultCode)ResultCode.departDelErrorUserExist);
        }
        int result = this.departmentService.delete(department);
        if (result == 1) {
            return ResultData.success((Object)result);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }
}

