/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.DimensValueDeleteParam;
import com.dtstep.lighthouse.insights.dto.GroupCreateParam;
import com.dtstep.lighthouse.insights.dto.GroupDimensQueryParam;
import com.dtstep.lighthouse.insights.dto.GroupQueryParam;
import com.dtstep.lighthouse.insights.dto.GroupUpdateParam;
import com.dtstep.lighthouse.insights.dto.StatQueryParam;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.GroupService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.vo.GroupVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class GroupController {
    @Autowired
    private GroupService groupService;
    @Autowired
    private StatService statService;
    @Autowired
    private DomainService domainService;

    @RequestMapping(value={"/group/list"})
    public ResultData<ListData<GroupVO>> list(@Validated @RequestBody ListSearchObject<GroupQueryParam> searchObject) throws Exception {
        GroupQueryParam queryParam = (GroupQueryParam)searchObject.getQueryParamOrDefault((Object)new GroupQueryParam());
        ListData listData = this.groupService.queryList(queryParam, Integer.valueOf(searchObject.getPagination().getPageNum()), Integer.valueOf(searchObject.getPagination().getPageSize()));
        return ResultData.success((Object)listData);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="projectId")
    @RequestMapping(value={"/group/create"})
    public ResultData<ObjectNode> create(@Validated @RequestBody GroupCreateParam createParam) {
        GroupQueryParam countByTokenParam = new GroupQueryParam();
        Domain domain = this.domainService.queryDefault();
        String token = String.format("%s:%s", domain.getDefaultTokenPrefix(), createParam.getToken());
        countByTokenParam.setToken(token);
        int tokenCount = this.groupService.count(countByTokenParam);
        if (tokenCount > 0) {
            return ResultData.result((ResultCode)ResultCode.createGroupTokenExist, (Object[])new Object[]{createParam.getToken()});
        }
        GroupQueryParam countByProjectParam = new GroupQueryParam();
        countByProjectParam.setProjectId(createParam.getProjectId());
        int groupCount = this.groupService.count(countByProjectParam);
        if (groupCount >= 10) {
            return ResultData.result((ResultCode)ResultCode.createGroupUnderProjectExceedLimit);
        }
        Group group = new Group();
        group.setToken(token);
        group.setColumns(createParam.getColumns());
        group.setDesc(createParam.getDesc());
        group.setProjectId(createParam.getProjectId());
        int id = this.groupService.create(group);
        ObjectNode objectNode = JsonUtil.createObjectNode();
        objectNode.put("id", id);
        objectNode.put("token", token);
        if (id > 0) {
            return ResultData.success((Object)objectNode);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="projectId")
    @RequestMapping(value={"/group/update"})
    public ResultData<Integer> update(@Validated @RequestBody GroupUpdateParam updateParam) throws Exception {
        Integer id = updateParam.getId();
        GroupVO group = this.groupService.queryById(id);
        group.setColumns(updateParam.getColumns());
        group.setDesc(updateParam.getDesc());
        int result = this.groupService.update((Group)group);
        if (result > 0) {
            return ResultData.success((Object)result);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.GROUP_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/group/queryById"})
    public ResultData<GroupVO> queryById(@Validated @RequestBody GroupQueryParam queryParam) throws Exception {
        GroupVO group = this.groupService.queryById(queryParam.getId());
        return ResultData.success((Object)group);
    }

    @RequestMapping(value={"/group/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) throws Exception {
        GroupVO group = this.groupService.queryById(idParam.getId());
        Validate.notNull((Object)group);
        StatQueryParam queryParam = new StatQueryParam();
        queryParam.setGroupIds(List.of(group.getId()));
        int countStat = this.statService.count(queryParam);
        if (countStat > 0) {
            return ResultData.result((ResultCode)ResultCode.groupDelExistSubStat);
        }
        int result = this.groupService.delete((Group)group);
        if (result > 0) {
            return ResultData.success((Object)result);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.GROUP_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/group/getSecretKey"})
    public ResultData<String> querySecretKey(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        String secretKey = this.groupService.getSecretKey(id);
        return ResultData.success((Object)secretKey);
    }

    @RequestMapping(value={"/group/queryByProjectId"})
    public ResultData<List<Group>> queryByProjectId(@Validated @RequestBody GroupQueryParam queryParam) {
        List groupList = this.groupService.queryByProjectId(queryParam.getProjectId());
        return ResultData.success((Object)groupList);
    }

    @RequestMapping(value={"/group/queryDimensList"})
    public ResultData<List<String>> queryDimensList(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        List dimensList = this.groupService.queryDimensList(id);
        return ResultData.success((Object)dimensList);
    }

    @RequestMapping(value={"/group/queryDimensValueList"})
    public ResultData<List<String>> queryDimensValueList(@Validated @RequestBody GroupDimensQueryParam queryParam) throws Exception {
        Integer groupId = queryParam.getGroupId();
        String dimens = queryParam.getDimens();
        List dimensValueList = this.groupService.queryDimensValueList(groupId, dimens);
        return ResultData.success((Object)dimensValueList);
    }

    @RequestMapping(value={"/group/deleteDimensValue"})
    public ResultData<Integer> deleteDimensValue(@Validated @RequestBody List<DimensValueDeleteParam> deleteParams) throws Exception {
        this.groupService.deleteDimensValue(deleteParams);
        return ResultData.success(null);
    }

    @RequestMapping(value={"/group/clearDimensValue"})
    public ResultData<Integer> clearDimensValue(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer groupId = idParam.getId();
        this.groupService.clearDimensValue(groupId);
        return ResultData.success(null);
    }
}

