/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.insights.dto.LoginParam;
import com.dtstep.lighthouse.insights.service.SystemEnvService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.ResultData;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class LoginController {
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    private SystemEnvService systemEnvService;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    private UserService userService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/user/login"})
    public ResultData<Map<String, String>> login(@Validated @RequestBody LoginParam user) {
        User dbUser = this.userService.queryAllInfoByUserName(user.getUsername());
        if (dbUser == null || !this.passwordEncoder.matches((CharSequence)user.getPassword(), dbUser.getPassword())) {
            return ResultData.result((ResultCode)ResultCode.loginCheckFailed);
        }
        if (dbUser.getState() == UserStateEnum.USER_PEND) {
            return ResultData.result((ResultCode)ResultCode.userPendApprove);
        }
        if (dbUser.getState() == UserStateEnum.USER_REJECT) {
            return ResultData.result((ResultCode)ResultCode.userStateUnAvailableRejected);
        }
        if (dbUser.getState() == UserStateEnum.USER_FROZEN) {
            return ResultData.result((ResultCode)ResultCode.userStateUnAvailableFrozen);
        }
        if (dbUser.getState() != UserStateEnum.USER_NORMAL) {
            return ResultData.result((ResultCode)ResultCode.userStateUnAvailable);
        }
        String signKey = this.systemEnvService.getParam("sign_key");
        long now = System.currentTimeMillis();
        HashMap<String, Object> accessMap = new HashMap<String, Object>();
        accessMap.put("id", dbUser.getId());
        accessMap.put("seed", UUID.randomUUID().toString());
        accessMap.put("expired", DateUtil.getMinuteAfter((long)now, (int)10));
        String accessKey = Jwts.builder().setClaims(accessMap).signWith(SignatureAlgorithm.HS512, signKey).compact();
        HashMap<String, Object> refreshMap = new HashMap<String, Object>();
        refreshMap.put("id", dbUser.getId());
        refreshMap.put("seed", UUID.randomUUID().toString());
        refreshMap.put("username", user.getUsername());
        refreshMap.put("password", dbUser.getPassword());
        LocalDateTime target = Instant.ofEpochMilli(now).atZone(ZoneId.systemDefault()).toLocalDate().plusDays(8L).atStartOfDay();
        long timestamp = target.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        refreshMap.put("expired", timestamp);
        String refreshKey = Jwts.builder().setClaims(refreshMap).signWith(SignatureAlgorithm.HS512, signKey).compact();
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("accessKey", accessKey);
        tokenMap.put("refreshKey", refreshKey);
        return ResultData.success(tokenMap);
    }

    @RequestMapping(value={"/refreshKey"})
    public ResultData<Map<String, String>> refreshKey(HttpServletRequest request) {
        Jws jws;
        String refreshKey = request.getHeader("refreshKey");
        if (StringUtil.isEmpty((String)refreshKey)) {
            return ResultData.result((ResultCode)ResultCode.authRenewalFailed);
        }
        String signKey = this.systemEnvService.getParam("sign_key");
        try {
            jws = Jwts.parser().setSigningKey(signKey).parseClaimsJws(refreshKey);
            if (jws == null) {
                return ResultData.result((ResultCode)ResultCode.authRenewalFailed);
            }
        }
        catch (Exception ex) {
            return ResultData.result((ResultCode)ResultCode.authRenewalFailed);
        }
        Long expired = (Long)((Claims)jws.getBody()).get((Object)"expired");
        if (expired == null || expired <= System.currentTimeMillis()) {
            return ResultData.result((ResultCode)ResultCode.authRenewalFailed);
        }
        String username = (String)((Claims)jws.getBody()).get((Object)"username");
        String password = (String)((Claims)jws.getBody()).get((Object)"password");
        User dbUser = this.userService.queryAllInfoByUserName(username);
        if (dbUser == null || !password.equals(dbUser.getPassword())) {
            return ResultData.result((ResultCode)ResultCode.authRenewalFailed);
        }
        if (dbUser.getState() != UserStateEnum.USER_NORMAL) {
            return ResultData.result((ResultCode)ResultCode.authRenewalFailed);
        }
        User updateParam = new User();
        updateParam.setId(dbUser.getId());
        updateParam.setLastTime(LocalDateTime.now());
        this.userService.update(updateParam);
        long now = System.currentTimeMillis();
        HashMap<String, Object> accessMap = new HashMap<String, Object>();
        accessMap.put("id", dbUser.getId());
        accessMap.put("seed", UUID.randomUUID().toString());
        accessMap.put("expired", DateUtil.getMinuteAfter((long)now, (int)10));
        String accessKey = Jwts.builder().setClaims(accessMap).signWith(SignatureAlgorithm.HS512, signKey).compact();
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("accessKey", accessKey);
        return ResultData.success(tokenMap);
    }

    @RequestMapping(value={"/index"})
    public String index() {
        return "index";
    }
}

