/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.RelationTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.Indicator;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.MetricSet;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.MetricBindParam;
import com.dtstep.lighthouse.insights.dto.MetricBindQueryParam;
import com.dtstep.lighthouse.insights.dto.MetricBindRemoveParam;
import com.dtstep.lighthouse.insights.dto.MetricPendQueryParam;
import com.dtstep.lighthouse.insights.dto.MetricSetCreateParam;
import com.dtstep.lighthouse.insights.dto.MetricSetQueryParam;
import com.dtstep.lighthouse.insights.dto.MetricSetUpdateParam;
import com.dtstep.lighthouse.insights.dto.MetricUpdateStructureParam;
import com.dtstep.lighthouse.insights.dto.PermissionGrantParam;
import com.dtstep.lighthouse.insights.dto.PermissionReleaseParam;
import com.dtstep.lighthouse.insights.dto.RelationQueryParam;
import com.dtstep.lighthouse.insights.service.MetricSetService;
import com.dtstep.lighthouse.insights.service.RelationService;
import com.dtstep.lighthouse.insights.vo.MetricSetVO;
import com.dtstep.lighthouse.insights.vo.RelationVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class MetricSetController {
    @Autowired
    private MetricSetService metricSetService;
    @Autowired
    private RelationService relationService;

    @RequestMapping(value={"/metricset/create"})
    public ResultData<Integer> create(@Validated @RequestBody MetricSetCreateParam createParam) throws Exception {
        MetricSet metricSet = new MetricSet();
        metricSet.setDesc(createParam.getDesc());
        metricSet.setTitle(createParam.getTitle());
        metricSet.setPrivateType(createParam.getPrivateType());
        int id = this.metricSetService.create(metricSet);
        if (id > 0) {
            PermissionGrantParam grantParam = new PermissionGrantParam();
            grantParam.setResourceId(Integer.valueOf(id));
            grantParam.setRoleType(RoleTypeEnum.METRIC_ACCESS_PERMISSION);
            grantParam.setUsersPermissions(createParam.getInitUsersPermission());
            grantParam.setDepartmentsPermissions(createParam.getInitDepartmentsPermission());
            this.metricSetService.batchGrantPermissions(grantParam);
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/metricset/update"})
    public ResultData<Integer> update(@Validated @RequestBody MetricSetUpdateParam updateParam) {
        Integer id = updateParam.getId();
        MetricSetVO metricSet = this.metricSetService.queryById(id);
        Validate.notNull((Object)metricSet);
        metricSet.setDesc(updateParam.getDesc());
        metricSet.setTitle(updateParam.getTitle());
        metricSet.setId(updateParam.getId());
        metricSet.setPrivateType(updateParam.getPrivateType());
        int result = this.metricSetService.update((MetricSet)metricSet);
        if (result > 0) {
            return ResultData.success((Object)result);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/metricset/queryById"})
    public ResultData<MetricSet> queryById(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        MetricSetVO metricSetVO = this.metricSetService.queryById(id);
        if (metricSetVO == null) {
            return ResultData.result((ResultCode)ResultCode.elementNotFound);
        }
        TreeNode structure = this.metricSetService.getStructure(metricSetVO);
        metricSetVO.setStructure(structure);
        return ResultData.success((Object)metricSetVO);
    }

    @RequestMapping(value={"/metricset/binded"})
    public ResultData<MetricSet> binded(@Validated @RequestBody MetricBindParam bindParam) throws Exception {
        this.metricSetService.binded(bindParam);
        return ResultData.success();
    }

    @RequestMapping(value={"/metricset/bindlist"})
    public ResultData<ListData<RelationVO>> bindedList(@Validated @RequestBody ListSearchObject<MetricBindQueryParam> searchObject) throws Exception {
        MetricBindQueryParam bindQueryParam = (MetricBindQueryParam)searchObject.getQueryParamOrDefault((Object)new MetricBindQueryParam());
        Pagination pagination = searchObject.getPagination();
        RelationQueryParam relationQueryParam = new RelationQueryParam();
        relationQueryParam.setRelationType(RelationTypeEnum.MetricSetBindRelation);
        relationQueryParam.setSubjectId(bindQueryParam.getId());
        relationQueryParam.setSearch(bindQueryParam.getSearch());
        ListData listData = this.relationService.queryList(relationQueryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @RequestMapping(value={"/metricset/list"})
    public ResultData<ListData<MetricSetVO>> list(@Validated @RequestBody ListSearchObject<MetricSetQueryParam> searchObject) {
        MetricSetQueryParam queryParam = (MetricSetQueryParam)searchObject.getQueryParamOrDefault((Object)new MetricSetQueryParam());
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.metricSetService.queryList(queryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @RequestMapping(value={"/metricset/bindRemove"})
    public ResultData<MetricSet> bindRemove(@Validated @RequestBody MetricBindRemoveParam removeParam) {
        Integer id = removeParam.getId();
        this.metricSetService.bindRemove(removeParam);
        return ResultData.success();
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.METRIC_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/metricset/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        MetricSetVO metricSet = this.metricSetService.queryById(id);
        Validate.notNull((Object)metricSet);
        int result = this.metricSetService.delete((MetricSet)metricSet);
        if (result > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.METRIC_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/metricset/updateStructure"})
    public ResultData<Integer> updateStructure(@Validated @RequestBody MetricUpdateStructureParam updateStructureParam) {
        ResultCode resultCode = this.metricSetService.updateStructure(updateStructureParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.METRIC_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/metricset/resetStructure"})
    public ResultData<Integer> resetStructure(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        MetricSetVO metricSet = this.metricSetService.queryById(id);
        Validate.notNull((Object)metricSet);
        metricSet.setStructure(new TreeNode(metricSet.getTitle(), (Object)metricSet.getId(), "metric"));
        this.metricSetService.update((MetricSet)metricSet);
        return ResultData.result((ResultCode)ResultCode.success);
    }

    @RequestMapping(value={"/metricset/indicatorList"})
    public ResultData<ListData<Indicator>> indicatorList(@Validated @RequestBody ListSearchObject<MetricPendQueryParam> searchObject) {
        MetricPendQueryParam queryParam = (MetricPendQueryParam)searchObject.getQueryParamOrDefault((Object)new MetricPendQueryParam());
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.metricSetService.queryIndicatorList(queryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @RequestMapping(value={"/metricset/starById"})
    public ResultData<Integer> starById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        MetricSetVO metricSet = this.metricSetService.queryById(id);
        Validate.notNull((Object)metricSet);
        ResultCode resultCode = this.metricSetService.star((MetricSet)metricSet);
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/metricset/unStarById"})
    public ResultData<Integer> unStarById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        MetricSetVO metricSet = this.metricSetService.queryById(id);
        Validate.notNull((Object)metricSet);
        ResultCode resultCode = this.metricSetService.unStar((MetricSet)metricSet);
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/metricset/queryStarList"})
    public ResultData<List<MetricSetVO>> queryStarList() {
        List list = this.metricSetService.queryStarList();
        return ResultData.success((Object)list);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.METRIC_MANAGE_PERMISSION, relationParam="resourceId")
    @RequestMapping(value={"/metricset/grant"})
    public ResultData<Integer> grant(@Validated @RequestBody PermissionGrantParam grantParam) throws Exception {
        ResultCode resultCode = this.metricSetService.batchGrantPermissions(grantParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.METRIC_MANAGE_PERMISSION, relationParam="resourceId")
    @RequestMapping(value={"/metricset/release"})
    public ResultData<Integer> release(@Validated @RequestBody PermissionReleaseParam releaseParam) throws Exception {
        ResultCode resultCode = this.metricSetService.releasePermission(releaseParam);
        return ResultData.result((ResultCode)resultCode);
    }
}

