/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.modal.Order;
import com.dtstep.lighthouse.insights.dto.OrderProcessParam;
import com.dtstep.lighthouse.insights.dto.QueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.OrderService;
import com.dtstep.lighthouse.insights.vo.OrderVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class OrderController {
    @Autowired
    private OrderService orderService;
    @Autowired
    private BaseService baseService;

    @RequestMapping(value={"/order/queryById"})
    public ResultData<OrderVO> queryById(@Validated @RequestBody QueryParam queryParam) throws Exception {
        OrderVO orderVO = this.orderService.queryById(queryParam.getId());
        Validate.notNull((Object)orderVO);
        Object extend = this.orderService.queryRelatedElement((Order)orderVO);
        orderVO.setExtend(extend);
        return ResultData.success((Object)orderVO);
    }

    @PostMapping(value={"/order/process"})
    public ResultData<Integer> process(@Validated @RequestBody OrderProcessParam approveParam) throws Exception {
        int result = this.orderService.process(approveParam);
        return ResultData.success((Object)result);
    }

    @PostMapping(value={"/order/pendCount"})
    public ResultData<Integer> pendCount() {
        int currentUserId = this.baseService.getCurrentUserId();
        int count = this.orderService.pendCount(currentUserId);
        return ResultData.success((Object)count);
    }
}

