/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.AuthRecord;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.insights.dto.PermissionListQueryParam;
import com.dtstep.lighthouse.insights.dto.PermissionQueryParam;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.vo.PermissionVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class PermissionController {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private RoleService roleService;

    @RequestMapping(value={"/permission/list"})
    public ResultData<ListData<PermissionVO>> list(@Validated @RequestBody ListSearchObject<PermissionListQueryParam> searchObject) {
        PermissionListQueryParam listQueryParam = (PermissionListQueryParam)searchObject.getQueryParams();
        Integer resourceId = listQueryParam.getResourceId();
        RoleTypeEnum roleTypeEnum = listQueryParam.getRoleType();
        Role role = this.roleService.queryRole(roleTypeEnum, resourceId);
        Pagination pagination = searchObject.getPagination();
        PermissionQueryParam queryParam = new PermissionQueryParam();
        queryParam.setOwnerType(listQueryParam.getOwnerType());
        queryParam.setRoleId(role.getId());
        queryParam.setSearch(listQueryParam.getSearch());
        ListData listData = this.permissionService.queryList(queryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @RequestMapping(value={"/permission/ownerAuthList"})
    public ResultData<ListData<AuthRecord>> authList(@Validated @RequestBody ListSearchObject<PermissionQueryParam> searchObject) throws Exception {
        PermissionQueryParam listQueryParam = (PermissionQueryParam)searchObject.getQueryParamOrDefault((Object)new PermissionQueryParam());
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.permissionService.queryOwnerAuthList(listQueryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }
}

